function net=add_FC_layer(net, ref_net)


n=numel(net.layers);

%% add one fully connected filter on top 
net.layers{n+1}.numFilter=1;
net.layers{n+1}.sizeFilter_x=net.layers{n}.sumMap_sx; %15
net.layers{n+1}.sizeFilter_y=net.layers{n}.sumMap_sy; %15
net.layers{n+1}.durationFilter= net.layers{n}.sumMap_sz;% 5; %5

net.layers{n+1}.subsampling_width_x=1;%round(firstLayer.sizeFilter* 0.9);
net.layers{n+1}.subsampling_width_y=net.layers{n+1}.subsampling_width_x;
net.layers{n+1}.subsampling_width_z=1;%max(1,round(secondLayer.halfSizeDurationFilter/2));

net.layers{n+1}.halfSizeFilter_x= floor(net.layers{n+1}.sizeFilter_x/2);
net.layers{n+1}.halfSizeFilter_y= floor(net.layers{n+1}.sizeFilter_y/2);
net.layers{n+1}.halfSizeDurationFilter= floor(net.layers{n+1}.durationFilter/2);


net.layers{n+1}.pad_x = 0;
net.layers{n+1}.pad_y = 0;
net.layers{n+1}.pad_z = 0;


net.layers{n+1}.pad=[net.layers{n+1}.pad_x, net.layers{n+1}.pad_x, net.layers{n+1}.pad_y, net.layers{n+1}.pad_y, net.layers{n+1}.pad_z, net.layers{n+1}.pad_z];  % (fully connected layer)
net.layers{n+1}.stride=[net.layers{n+1}.subsampling_width_x, net.layers{n+1}.subsampling_width_y, net.layers{n+1}.subsampling_width_z];

% initialize the filters at the second layer
net.layers{n+1}.filters = gpuArray.randn([net.layers{n+1}.sizeFilter_x, net.layers{n+1}.sizeFilter_y, net.layers{n+1}.durationFilter, net.layers{n}.numFilter, net.layers{n+1}.numFilter], 'single')*0.001;
net.layers{n+1}.bias = gpuArray.zeros(1, net.layers{n+1}.numFilter,'single');

net.layers{n+1}.sumMap_sx= floor( (net.layers{n}.sumMap_sx + 2* net.layers{n+1}.pad_x - net.layers{n+1}.sizeFilter_x) /  net.layers{n+1}.subsampling_width_x)+1;
net.layers{n+1}.sumMap_sy= floor( (net.layers{n}.sumMap_sy + 2* net.layers{n+1}.pad_y - net.layers{n+1}.sizeFilter_y) /  net.layers{n+1}.subsampling_width_y)+1;
net.layers{n+1}.sumMap_sz= floor( (net.layers{n}.sumMap_sz + 2* net.layers{n+1}.pad_z - net.layers{n+1}.durationFilter) /  net.layers{n+1}.subsampling_width_z)+1;

net.layers{n+1}.momentum_filter = zeros(size(net.layers{n+1}.filters), 'single');
net.layers{n+1}.momentum_bias = zeros(size(net.layers{n+1}.bias), 'single');

 net.layers{n+1}.lambdaLearningRate = ref_net.layers{n+1}.FC_lambdaLearningRate;