function mask = generate_missing_patch_3D(sz, mask_duration, noise_level)


num_frame = sz(3);

num_missing_frames = noise_level * num_frame;

num_missing_3D = floor(num_missing_frames/mask_duration);

num_total_3D=floor(num_frame/mask_duration);

ind=randsample(num_total_3D, num_missing_3D);

ind_missing=[];
for i=1:numel(ind)
    add = (ind(i)-1)* mask_duration + [1:mask_duration];
    ind_missing = [ind_missing  add];
end

mask = gpuArray(zeros(sz, 'single'));
mask = gather(mask);

ind_missing=[1,2,3, 4,5, 6,7,8,9,10, 61, 62, 63, 64, 65, 66, 67,68, 69, 70,];

mask(:,:,ind_missing,:)=1;
mask = mask ~= 0;


