function resultPreparation(para, net, currSample_video)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%          Postprocessing
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%% saving synthesized sequences
for iChain=1:para.numChain
    
    outputFolder = [para.outPath_final_result filesep 'synthesis_chain_' num2str(iChain) ];
    if ~exist(outputFolder)
        mkdir(outputFolder); % working directory to store synthesized images files.
    end
    
    for iFrame=1:para.numFrames
        temp=single(uint8(gather(currSample_video(:,:,iFrame,:, iChain)) + gather(para.mean_img))); % add back the mean
        temp=permute(temp,[1,2,4,3]);
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        imwrite(temp, fullfile(outputFolder , ['image_'  num2str(iFrame,'%04d') '.jpg']));
    end
    
    %% make synthesis avi movie
    imagesNamesSyn=dir([outputFolder  filesep '*.jpg']);
    imagesNamesSyn={imagesNamesSyn.name}';
    outputVideo = VideoWriter(fullfile(outputFolder,'synthesisVideo.avi'));
    outputVideo.FrameRate = outputVideo.FrameRate;
    open(outputVideo)
    
    for iFrame = 1:length(imagesNamesSyn)
        img = imread(fullfile(outputFolder, imagesNamesSyn{iFrame}));
        writeVideo(outputVideo,img)
    end
    close(outputVideo)
    
end

%% saving observed sequences
for iVideo=1:para.numVideos
    
    outputFolder = [para.outPath_final_result filesep 'observed_sequence_' num2str(iVideo) ];
    if ~exist(outputFolder)
        mkdir(outputFolder); % working directory to store synthesized images files.
    end
    
    %% remake observed avi movie
    inputFolder= [para.outPath_images, filesep 'sequence_' num2str(iVideo)];
    imagesNamesObs=dir([inputFolder  filesep '*.jpg']);
    imagesNamesObs={imagesNamesObs.name}';
    outputVideo = VideoWriter(fullfile(outputFolder,'observedVideo.avi'));
    outputVideo.FrameRate = outputVideo.FrameRate;
    open(outputVideo)
    
    for iFrame = 1: para.numFrames %length(imagesNames)
        img = imread(fullfile(inputFolder, imagesNamesObs{iFrame}));
        img = imresize(img, [para.sx, para.sy], 'bilinear' );
        writeVideo(outputVideo,img)
    end
    close(outputVideo)
    
end



%% make a comparison video
outPath_comparison = [para.outPath_final_result filesep 'comparison' ];
if ~exist(outPath_comparison)
    mkdir(outPath_comparison); % working directory to store synthesized images files.
end


imagesNamesSyn=dir([para.outPath_final_result filesep 'synthesis_chain_1' filesep '*.jpg']);
imagesNamesSyn={imagesNamesSyn.name}';


outputVideo = VideoWriter(fullfile(outPath_comparison,'ObsSynVideo.avi'));
outputVideo.FrameRate = outputVideo.FrameRate;
open(outputVideo)

if para.numFrames < length(imagesNamesSyn)  % if the number of synthesis images is larger than the number of observed images
    numFrames = length(imagesNamesSyn);
else
    numFrames = para.numFrames;
end

margin=15;
for iFrame = 1: numFrames %length(imagesNames)
    
    combinedImg = zeros(para.sx, (para.numVideos+para.numChain)* para.sy+ (para.numVideos+para.numChain-1)*margin, para.numChannel);
    
    for iVideo=1:para.numVideos
        folder= [para.outPath_images, filesep 'sequence_' num2str(iVideo)];        
        imagesNamesObs=dir([folder  filesep '*.jpg']);
        imagesNamesObs={imagesNamesObs.name}';
        img1 = imread(fullfile(folder, imagesNamesObs{iFrame}));
        img1 = imresize(img1, [para.sx, para.sy], 'bilinear' );
        temp=single(uint8(img1));
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        combinedImg(:, (iVideo-1)*(size(img1,2)+margin)+1: (iVideo-1)*(size(img1,2)+margin)+size(img1,2),:)=temp;        
    end    
    
    
    for iChain=1:para.numChain
        folder = [para.outPath_final_result filesep 'synthesis_chain_' num2str(iChain) ];        
        imagesNamesSyn=dir([folder  filesep '*.jpg']);
        imagesNamesSyn={imagesNamesSyn.name}';
        img2 = imread(fullfile(folder, imagesNamesSyn{iFrame}));
        temp=single(uint8(img2));
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        combinedImg(:, (para.numVideos+ iChain-1)*(size(img2,2)+margin)+1: (para.numVideos+iChain-1)*(size(img2,2)+margin)+size(img2,2),:)=temp;
    end
    writeVideo(outputVideo,combinedImg);
end
close(outputVideo)


%% moving filters from the first layer
saveMovingFilters(net.layers{1}, para);



