function currSequence = sampling_sequence_by_Langevin(net, L, stepsize, currSequence, conserveMemory)

    if nargin < 5
        conserveMemory = true;
    end

    num_layer= numel(net.layers);
    %sequence_syn=currSequence;
    tic
    for i=1:L

        noise = normrnd(0,1,size(currSequence));
        gradientU = grad_U(net, currSequence, num_layer, conserveMemory);
        %%
        currSequence = currSequence - 0.5*(stepsize^2) * gradientU;
        currSequence = currSequence + stepsize * noise;
    end
    disp(['number of sampling steps: '  num2str(L) ', time : ' num2str(toc)]);
end


function gradientU = grad_U(net, sequence_syn, n, conserveMemory)

      %% compute the gradient of I
      % convolution and subsampling
       
      res = struct(...
          'x', cell(1,n+1), ...
          'indicator', cell(1,n+1));      
            
      % bottom-up
      res(1).x = sequence_syn;
      for l=1:n
          res(l+1).x = mex_conv3d(res(l).x, net.layers{l}.filters, net.layers{l}.bias, 'pad', net.layers{l}.pad, 'stride', net.layers{l}.stride);
          
          if l~=n || net.FC==false              
              res(l+1).x = vl_nnrelu(res(l+1).x);
          end         
      end
      
      % top-down
      res(l+1).indicator=gpuArray(ones(size(res(l+1).x),'single' ));      
      for l=n:-1:1            
          
          if l~=n || net.FC==false
              res(l+1).indicator=vl_nnrelu(res(l+1).x, res(l+1).indicator);        
          end              
          
          [res(l).indicator, ~, ~]=mex_conv3d(res(l).x, net.layers{l}.filters, net.layers{l}.bias, res(l+1).indicator, 'pad', net.layers{l}.pad, 'stride', net.layers{l}.stride);   
          
          if conserveMemory
              res(l+1).indicator = [] ;
          end
          
      end
      
      gradientU = -res(1).indicator + sequence_syn; 

end
 
 
 



