function saveMovingFilters(firstLayer, para)

outPath_movingFilter = [para.outPath_final_result filesep 'moving_filters' ];
if ~exist(outPath_movingFilter)
    mkdir(outPath_movingFilter); % working directory to store synthesized images files.
end

outputVideo = VideoWriter(fullfile(outPath_movingFilter, 'dictionary.avi'));
outputVideo.FrameRate = outputVideo.FrameRate;
open(outputVideo)

colsMap=10;
rowsMap=ceil(firstLayer.numFilter/colsMap);
margin=floor(firstLayer.sizeFilter_x*0.5);

for id=1:firstLayer.durationFilter    
    
    saved_movingfilterMap=zeros( [firstLayer.sizeFilter_x*rowsMap + (rowsMap-1)*margin, firstLayer.sizeFilter_y*colsMap + (colsMap-1)*margin, para.numChannel] );
    filtersFrame = gather(firstLayer.filters(:,:,id,:,:)+ para.mean_img);
    filtersFrame = permute(filtersFrame, [1,2,4, 5, 3]);
    
    for iFilter = 1:firstLayer.numFilter
        iRow = floor((iFilter-1)/colsMap)+1;
        iCol = mod(iFilter-1, colsMap)+1;
        %filterSaved= gather(firstLayer.filters(:,:,1,:,ind(iFilter)) + para.mean_img);
        filterSaved= filtersFrame(:,:,:,iFilter);% gather(firstLayer.filters(:,:,1,:,iFilter) + para.mean_img);
        %filterSaved=permute(filterSaved,[1,2,4,3]);
        
        gLow = min(filterSaved(:));
        gHigh = max(filterSaved(:));
        filterSaved = (filterSaved-gLow)/(gHigh-gLow);
        saved_movingfilterMap(1 + (iRow-1)*(firstLayer.sizeFilter_x+margin) :  firstLayer.sizeFilter_x + (iRow-1)*(firstLayer.sizeFilter_x+margin), ...
            1 + (iCol-1)*(firstLayer.sizeFilter_y+margin) : firstLayer.sizeFilter_y + (iCol-1)*(firstLayer.sizeFilter_y+margin),:)= filterSaved;
    end
    
    imwrite(saved_movingfilterMap, fullfile(outPath_movingFilter, ['dictionary_'  num2str(id,'%04d') '.jpg']));
    
    writeVideo(outputVideo,saved_movingfilterMap);   
end
close(outputVideo)