function saveSequence(para, currSample_video, iter)

  % this function only saves the first video if there are more than one in variable of "currSample_video"
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% save the synthesis
    numFrames=size(currSample_video,3);
    col_default=4;
    margin_syn=5;
    row=ceil(numFrames/col_default);
    if numFrames>=col_default
        col=col_default;
    else
        col=numFrames;
    end
    saved_img = zeros(row*para.sx + margin_syn*(row-1), col*para.sy +margin_syn*(col-1), para.numChannel);
    for iFrame=1:numFrames
        iRow=floor((iFrame-1)/col) +1;
        iCol=mod(iFrame-1,col) +1;
        temp=single(uint8(gather(currSample_video(:,:,iFrame, :, 1)) + gather(para.mean_img))); % add back the mean
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        saved_img(1+ (para.sx+margin_syn)*(iRow-1) : para.sx + (para.sx+margin_syn)*(iRow-1), 1+(para.sy+margin_syn)*(iCol-1):para.sy+(para.sy+margin_syn)*(iCol-1),:)=temp;
    end
    imwrite(saved_img, fullfile(para.outPath_synthesis, [num2str(iter,'%04d') '.png']));
    