function saveSequence_inpainting(para, currSample_video, recovered_video, iter)

  % this function only saves the first video if there are more than one in variable of "currSample_video"
  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %% save the synthesis
    col_default=4;
    margin_syn=5;
    row=ceil(para.numFrames/col_default);
    if para.numFrames>=col_default
        col=col_default;
    else
        col=para.numFrames;
    end
    saved_img = zeros(row*para.sx + margin_syn*(row-1), col*para.sy +margin_syn*(col-1), para.numChannel);
    for iFrame=1:para.numFrames
        iRow=floor((iFrame-1)/col) +1;
        iCol=mod(iFrame-1,col) +1;
        temp=single(uint8(gather(currSample_video(:,:,iFrame, :, 1)) + gather(para.mean_img))); % add back the mean
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        saved_img(1+ (para.sx+margin_syn)*(iRow-1) : para.sx + (para.sx+margin_syn)*(iRow-1), 1+(para.sy+margin_syn)*(iCol-1):para.sy+(para.sy+margin_syn)*(iCol-1),:)=temp;
    end
    imwrite(saved_img, fullfile(para.outPath_synthesis, [num2str(iter,'%04d') '.png']));
    


    %% save recovered video
    saved_img = zeros(row*para.sx + margin_syn*(row-1), col*para.sy +margin_syn*(col-1), para.numChannel);
    for iFrame=1:para.numFrames
        iRow=floor((iFrame-1)/col) +1;
        iCol=mod(iFrame-1,col) +1;
        temp=single(uint8(gather(recovered_video(:,:,iFrame, :, 1)) + gather(para.mean_img))); % add back the mean
        gLow = min(temp(:));
        gHigh = max(temp(:));
        temp = (temp-gLow)/(gHigh-gLow);
        saved_img(1+ (para.sx+margin_syn)*(iRow-1) : para.sx + (para.sx+margin_syn)*(iRow-1), 1+(para.sy+margin_syn)*(iCol-1):para.sy+(para.sy+margin_syn)*(iCol-1),:)=temp;
    end
    imwrite(saved_img, fullfile(para.outPath_recovered, [num2str(iter,'%04d') '.png']));
    %%%%%%