
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%%  background inpainting by spatial-temporal generative ConvNet
%%
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 


%% FC_ST_2: 1 convolutional layer + 1 spatial-temporal fully connected layer (end to end)
%% FC_S_3: 1 convolutional layer + 2 spatial fully connected layer (end to end)

clear
category={'boats'}; % 'boats', 'chatelet'

model_type='FC_S_3';


for id=1:length(category)
    
    
    [para, net_ref, video_masked] = config_STGConvNet_background_inpainting(category{id}, model_type);
    
    switch para.learningScheme
        case 'end_to_end'
            net=net_ref;
        case 'layer_by_layer_FC'
            net.layers{1}=net_ref.layers{1};
            net.FC=net_ref.FC;
            para.sub_numIteration=floor(para.numIteration / (numel(net_ref.layers)-1));
        case 'layer_by_layer'
            net.layers{1}=net_ref.layers{1};
            net.FC=net_ref.FC;
            para.sub_numIteration=floor(para.numIteration / numel(net_ref.layers));
        otherwise
            error('No such an option');
    end
    
  
    
    %% initialize the synthesized image
    currSample_video = randn([para.sx, para.sy, para.sz, para.numChannel, para.numChain], 'single');
    error_recover=zeros(1,para.numIteration);
    for iter=1: para.numIteration
        
        
        switch para.learningScheme
            
            case 'layer_by_layer_FC'
                id_layer=min(numel(net_ref.layers),floor((iter-1)/para.sub_numIteration)+1);
                
                if id_layer == numel(net.layers)
                    if id_layer==1
                        net=add_FC_layer(net,net_ref); %% add the FC layer on top
                    else %% remove the top and then add one layer of filters and one single fully connceted filter
                        net.layers = net.layers(1:end-1);  % remove
                        net.layers{id_layer}=net_ref.layers{id_layer}; % copy
                        net.layers{id_layer-1}.lambdaLearningRate=0; % fix the low layer
                        net=add_FC_layer(net, net_ref); % add the FC layer on top
                    end
                end
                disp( [ '################ iteration ' num2str(iter) ' layer ' num2str(id_layer)]);
                
            case 'layer_by_layer'
                id_layer=min(numel(net_ref.layers),floor((iter-1)/para.sub_numIteration)+1);
                
                if id_layer > numel(net.layers)
                    net.layers{id_layer}=net_ref.layers{id_layer}; % copy
                end
                disp( [ '################ iteration ' num2str(iter) ' (per layer:' num2str(para.sub_numIteration) ') for layer ' num2str(id_layer)]);
                
            case 'end_to_end'
                disp( [ '################ iteration ' num2str(iter)]);
                
            otherwise
                error('No such an option');
        end
        
        
        clock_start=tic;
        
        [net, currSample_video, video_masked, error_recover(iter)]=process_epoch_STGConvNet_inpainting(para, net, currSample_video, video_masked);
        toc(clock_start);        
        saveSequence_inpainting(para,currSample_video, video_masked, iter);
    end
    plot(error_recover);
    save(fullfile(para.outPath_synthesis, 'savedVariables.mat'));
    resultPreparation_inpainting(para, net, currSample_video, video_masked);    
    
end
