%
% Learning hierarchical ABC. 
%

%% delete existing filefolds
close all; clear all;
if (exist('output','dir'))%experimental results
    delete('output/*.*'); 
else
    mkdir('output');
end
if exist('working','dir')%working files
    delete('working/*.mat'); 
else
    mkdir('working');
end
if exist('sketch','dir')%image sketches
    delete('sketch/*.*'); 
else
    mkdir('sketch');
end

%% compile c/c++ functions
mex CsharedSketch.c;%learn template by shared sketch algorithm
mex mexc_Sigmoid.cpp;%transform by sigmoid function
mex Ccopy.c;%copy image patch
mex ClocalNormalize.c;%local normalization
mex mexc_ComputeMAX1.cpp;%compute MAX1map
mex mexc_ComputeSUM2.cpp;%compute SUM2map
mex mexc_ComputeMAX2.cpp;%compute MAX2map
mex mexc_ComputeSUM3.cpp;%compute SUM3map
mex mexc_TemplateAffineTransform.cpp;
mex mexc_CropInstance.cpp;%crop image patches
mex mexc_ComputeMAX2MP.cpp;%encode image by matching pursuit

%% set parameters
ParameterSettings;

%% compute SUM1MAP
SUM1MAX1;

%% initial assignment
InitAssignment;

%% EM-style steps
for iter = 1:numOfIteration
    
    %template re-learning by shared sketch algorithm
    TemplateLearning;
    
    %image encoding by matching pursuit algorithm
    ImageEncoding;
    
end;

%% detecting templates and parts
%HABMorphDetector;

% generate html to show experimental results
%GenerateHtml;



