function featureArray = BatchExtractFeatures(imgCell,codeBook)
% numImage = numel(imgCell);
% for iI = 1:numImage
%     img = imgCell{iI}; % image will be resized later in extratFeatureFromOneImage.m
%     feature = extractFeatureOneImage(img,codeBook);
%     featureArray = [featureArray;feature];
% end
%{
if (exist('./output','dir'))%experimental results
    delete('./output/*.*'); 
else
    mkdir('output');
end
%}
if exist('./working','dir')%working files
    delete('./working/*.mat'); 
else
    mkdir('working');
end
if exist('./sketch','dir')%image sketches
    delete('./sketch/*.*'); 
else
    mkdir('sketch');
end

featureArray=[];
%% set parameters
ParameterSettings;
if numOfCluster ~= length(codeBook)
  numOfCluster = length(codeBook);
end
allTemplateAffinityMatrix = cell(numPartRotate*numOfCluster, numCandPart);
for cc = 1:numOfCluster
    templateAffinityMatrix = cell(numPartRotate,numCandPart);
    for iPart = 1:numCandPart
        for r1 = 1:length(partRotationRange)
            angle1 = pi/numOrient * partRotationRange(r1);
            templateAffinityMatrix{r1,iPart} = [];
            jPart = iPart;
            for r2 = 1:length(partRotationRange)
                angle2 = pi/numOrient*partRotationRange(r2);
                if (sin(angle1) - sin(angle2))^2 + (cos(angle1)-cos(angle2))^2 <= minRotationDif
                    templateAffinityMatrix{r1,iPart} = int32( [templateAffinityMatrix{r1,iPart} r2-1] );
                end
            end
        end
    end
    for iPart = 1:numCandPart
        startInd = (cc-1)*numPartRotate + (iPart-1)*numPartRotate*numOfCluster;
        rowId = (cc-1)*numPartRotate;
        for r2 = 1:length(partRotationRange)
            allTemplateAffinityMatrix{rowId+r2, iPart} = templateAffinityMatrix{r2, iPart}(:)+startInd;
        end
    end
end
%% compute SUM1MAP
SUM1MAX1;



%% remove existing files
for cc = 1:numOfCluster
    delete(['working/cluster' num2str(cc) '/*.*']);
end
%% collect templates
allS2T = cell(numOfCluster*numPartRotate, numCandPart);
allS3T = cell(numOfCluster*numRotate,1);
for cc = 1 : numOfCluster
    startIndT2 = (cc-1)*numPartRotate;
    allS2T(startIndT2+1:startIndT2+numPartRotate, :) = codeBook{cc}.S2T;
    startIndT3 = (cc-1)*numRotate;
    allS3T(startIndT3+1:startIndT3+numRotate,:) = codeBook{cc}.S3T;
end

%% start encoding
numOfT = ones(1, numOfCluster);
numOfPartTemplate = numPartRotate*numOfCluster;

for iImg = 1:numel(imgCell)

    disp(['    start computing features in image ' num2str(iImg)]);
    
    %% load data
    load( sprintf('./working/SUM1map_image_%d.mat',iImg), 'SUM1mapFind','MAX1map','M1Trace','M1RowShift','M1ColShift','M1OriShifted');
    
    %% compute SUM2 maps for non-overlapping parts
    SUM2map = cell(numOfPartTemplate, numCandPart, numImgResolution);
    for iRes = 1:numImgResolution
        tmpS2 = mexc_ComputeSUM2( numOrient,...
            MAX1map(iRes,:), allS2T(:), subsampleS2 );
        SUM2map(:,:,iRes) = reshape(tmpS2, [numOfPartTemplate numCandPart]);
    end
    
    %% compute MAX2 maps for overlapping parts (local maximization w.r.t. translation and rotation)
    MAX2map = cell(size(SUM2map));
    MAX2LocTrace = cell(size(SUM2map));
    MAX2TransformTrace = cell(size(SUM2map));
    for iRes = 1:numImgResolution
        [tmpMAX2 tmpMAX2LocTrace tmpMAX2TransformTrace...
            M2RowColShift] = mexc_ComputeMAX2( allTemplateAffinityMatrix(:), ...
            SUM2map(:,:,iRes), ...
            locationPerturbFraction, ...
            int32(partSize*ones(numOfPartTemplate*numCandPart,1)/subsampleS2), subsampleM2 );
        MAX2map(:,:,iRes) = reshape(tmpMAX2,[numOfPartTemplate numCandPart]);
        MAX2LocTrace(:,:,iRes) = reshape(tmpMAX2LocTrace,[numOfPartTemplate numCandPart]);
        MAX2TransformTrace(:,:,iRes) = reshape(tmpMAX2TransformTrace,[numOfPartTemplate numCandPart]);
    end
    
    %% compute SUM3map
    SUM3map = cell(numOfCluster*nTransform, numImgResolution);
    for cc = 1 : numOfCluster
        for r = 1:length(rotationRange) % this is the rotation of the S3 template
            for iRes = 1:numImgResolution
                startInd = (cc-1)*numPartRotate;
                tmpM2 = MAX2map(startInd+1:startInd+numPartRotate,:,iRes);
                startIndT3 = (cc-1)*numRotate;
                tmpS3 = mexc_ComputeSUM3( tmpM2(:), allS3T(startIndT3+r), 1, numPartRotate);
                SUM3map(r+(cc-1)*length(rotationRange), iRes) = tmpS3;
            end
        end
    end
    
    
    %% collapse SUM3map along resolution dimension
    
    num_total_features = size(SUM3map,1) +  size(SUM2map,1)*size(SUM2map,2);
    denseFeatureMaps=cell(num_total_features,1);
    feature_id_offset = 0;
    for i_feature = 1:size(SUM3map,1)
        localMax = SUM3map{i_feature,numImgResolution};
        for i_res = 1:numImgResolution
            tmpMap = imresize(SUM3map{i_feature,i_res},size(localMax),'nearest');
            localMax = max(localMax,tmpMap);
        end
        denseFeatureMaps{i_feature+feature_id_offset}=localMax;
    end
    i_feature = size(SUM3map,1)+1;
    for i = 1:size(SUM2map,1)
        for j = 1:size(SUM2map,2)
            localMax = SUM2map{i,j,1};
            for i_res = 1:size(SUM2map,3)
                tmpMap = imresize(SUM2map{i,j,i_res},size(localMax),'nearest');
                localMax = max(localMax,tmpMap);
            end
            denseFeatureMaps{i_feature} = localMax;
            i_feature = i_feature+1;
        end
    end
    
    %% SPM
    
    numLayers = 3;
    threshold = 0;
    SPM_feature = featureSPM(denseFeatureMaps,numLayers,threshold);
    featureArray = [featureArray; SPM_feature];
end
end % end of function


