% GenerateHtml - Generates html documentation for the learning results.
%
%clear
close all;
% parameter settings
zipname = sprintf('HABC.zip');
imFolder = 'HABC';
tr_or_tt = 'train';
% delete the previous version
html_dir = 'document';
if ~exist(html_dir,'dir')
    mkdir(html_dir);
end

html_path = sprintf('%s/%s.html',html_dir,imFolder);
html = fopen(html_path,'w');

html_img_dir = sprintf('document/%s/',imFolder);
if ~exist(html_img_dir,'dir')
    mkdir(html_img_dir);
end

%% html header
% note: modified on Jan 13, 2010. Some url's are now absolute. Only 
%   copied files are linked with relative url.
tmp = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">\n';
tmp = [tmp '<html>\n'];
tmp = [tmp '<head>\n'];
tmp = [tmp '<title>Unsupervised Learning of Dictionaries of Hierarchical Compositional Model</title>\n'];
tmp = [tmp '</head>\n'];
fprintf(html,tmp);
fprintf(html, '<body>\n');
fprintf( html, '<div id="header">\n');
fprintf( html, '<h1>Unsupervised Learning of Dictionaries of Hierarchical Compositional Model</h1></div>\n' );
fprintf( html, '\n<div id="content">\n');

%% table of content
fprintf( html, '<div id="content">\n' );
fprintf( html, '<div id="TableOfContents">\n' );
fprintf( html, '<p>Contents</p>\n' );
fprintf( html, '<ul>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<A href="#download">Download</A>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n');
fprintf( html, '<a href="#learnedTemplates">Learned templates</a>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '<li>\n' );
fprintf( html, '<a href="#image">Image and Their Sketches</a>\n' );
fprintf( html, '</li>\n' );
fprintf( html, '</ul>\n' );
fprintf( html, '</div>\n' );

%% for download
fprintf( html, '<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div>\n' );
fprintf( html, '<a name="download"></a> <table cellspacing="10" cellpadding="10" class="center" width="60%%">\n' );
fprintf( html, '\n<tr><td>\n' );
fprintf( html, '\n<b>Code and data: (<a href="%s">ZIP</a>).</b>\n', zipname );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n<td>\n' );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n</tr>\n' );
fprintf( html, '\n<tr>\n' );
fprintf( html, '\n<td colspan=2 align=left>\n' );
fprintf( html, '\nRun StartFromHere.m in Matlab. You can monitor intermediate results in the folder: output/. \n' );
fprintf( html, '\n</td>\n' );
fprintf( html, '\n</tr>\n' );
fprintf( html, '\n</table>\n' );

%% explain the parameters
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div> ');
fprintf(html, '\n<p><b>Parameters</b>: <br>');
fprintf( html, sprintf('The number of training images is %d. ',numOfI));
fprintf( html, sprintf('The size of each active basis template is %d (width) by %d (height) pixels. ',templateSize(2),templateSize(1)));
fprintf( html, sprintf('Maximum number of Gabor elements in each template is %d. ',numElement));
fprintf( html, sprintf('Each Gabor element is allowed to move %d pixels and rotate %d orientation step(s) at most. ',locationShiftLimit,orientShiftLimit));
fprintf( html, sprintf('<p>In total the codebook consists of %d active basis templates. ',numOfCluster));
fprintf( html, sprintf('Then %d iterations are carried out. ',numOfIteration));
fprintf( html, sprintf('In the encoding step, the activated templates need to have a SUM3 score of at least %d. ',S3Thre));
fprintf( html, sprintf('For local inhibition between templates, the minimum distance between two activated template is %.2f times the size of template. ',locationPerturbationFraction2));
fprintf( html, sprintf('Allowed template rotations: ['));
fprintf( html, sprintf('%d',rotationRange(1)) );
for rr = rotationRange(2:end)
	fprintf( html, sprintf(', %d',rr) );
end
fprintf( html, ']. ');
fprintf( html, sprintf('Allowed image resolutions (relative): ['));
fprintf( html, sprintf('%.2f',valResolution(1)) );
for rr = valResolution(2:end)
	fprintf( html, sprintf(', %.2f',rr) );
end
fprintf( html, ']. ');
fprintf( html, sprintf('As a pre-processing step, the input images are resized to the min(height, width) of %d.', minHeightOrWidth));
fprintf( html, '</p>\n ');

%% show learned templates
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div> ');
fprintf(html, '\n<p><b>Learned templates</b>. ');
fprintf( html, ['<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div><a name="templates"></a>Show first layer templates for ' num2str(numOfCluster) ' entries of the codebook (after ' num2str(numOfIteration) ' iterations)' ...
    ':\n']);
fprintf( html, '\n</p>' );
fprintf( html, '\n<p>' );
for cc = 1:numOfCluster
    new_img_name = sprintf('cluster_%d_template_iter%d.png',cc,numOfIteration);
    src = sprintf('./output/%s',new_img_name);
    dst = sprintf('document/%s/%s', imFolder,new_img_name);
    copyfile(src,dst);
    fprintf( html, '\n<img src="%s" alt="" width="60"/>', sprintf('%s/%s',imFolder,new_img_name) );
end;
fprintf( html, '\n</p>\n' );

fprintf( html, ['<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div><a name="templates"></a>Show second layer templates for ' num2str(numSecondLayerTemplates) ' entries of parts (after ' num2str(numOfIteration) ' iterations)' ...
    ':\n']);
fprintf( html, '\n</p>' );
fprintf( html, '\n<p>' );
for cc = 1:numOfCluster
    for iTemp = 1:numSecondLayerTemplates
        new_img_name = sprintf('cluster_%d_template_iter%d_part%d_%d.png',cc,numOfIteration,PartLocX(iTemp), PartLocY(iTemp));
        src = sprintf('./output/%s',new_img_name);
        dst = sprintf('document/%s/%s', imFolder,new_img_name);
        copyfile(src,dst);
        fprintf( html, '\n<img src="%s" alt="" width="60"/>', sprintf('%s/%s',imFolder,new_img_name) );
    end
    fprintf( html,'<br>');
end;
fprintf( html, '\n</p>\n' );

%% training examples
fprintf(html, '<div style="border-top:1 solid #dddddd; margin-top:0.3em;"></div> ');
fprintf(html, '\n<p><b>Traing images and their sketches:</b></p>');
% read the training examples
Iname = dir('positiveImage/*.jpg');
n = length(Iname);
selected_img = 1:n;
% render sketched images with activated partial templates
destFolder = sprintf('document/%s',imFolder);
% move the images to img/ folder
for i = 1:length(Iname)
    new_img_name = Iname(i).name;
    src = sprintf('positiveImage/%s',new_img_name);
    dst = sprintf('document/%s/%s_%s',imFolder, tr_or_tt,new_img_name);
    copyfile(src,dst);
end
% generate corresponding html
fprintf( html, '\n<p>' );
for i = 1:length(Iname)
    fprintf( html, '<img src="%s" alt="" height=80/>', sprintf('%s/%s_%s',imFolder,tr_or_tt,Iname(i).name) );
end
fprintf( html, '\n</p>\n' );
% show sketched images
fprintf( html, ['<div style="border-bottom:1 solid #dddddd; margin-top:0.3em;"></div>\n<a name="templates"></a><p>' ...
	'Sketching the observed images by overlaying the activated templates on them:' ...
	'</p>\n']);
fprintf( html, '\n<p>' );
for i = 1:length(Iname)
    new_img_name = sprintf('sketchedI_Image_%d.png', i);
    src = sprintf('sketch/%s',new_img_name);
    dst = sprintf('document/%s/%s_%s',imFolder, tr_or_tt,new_img_name);
    copyfile(src,dst);
end

for i = 1:length(Iname)
	fprintf( html, '<img src="%s" alt="" height=80/>', sprintf('%s/%s_sketchedI_Image_%d.png',imFolder,tr_or_tt,i) );
end
fprintf( html, '\n</p>\n' );

%% finishing off
fprintf( html, '\n\n\n</div> \n');
fprintf( html, '<div id="last" class="footer"></div>' );
fprintf(html, '</body> </html> \n');
fclose(html);
disp('finished generating Html... go to document folder and click the html');

close all
