%%
disp('randomly extract image patches');

halfX = floor(sizeTemplatex/2);
halfY = floor(sizeTemplatey/2);

    PartOnOff = ones(numCandPart,1);
    selectedPart = find(PartOnOff);
    S3SelectedRow = zeros(1,numCandPart,'single');
    S3SelectedCol = zeros(1,numCandPart,'single');
    S3SelectedOri = zeros(1,numCandPart,'single');
    for iPart = 1:numCandPart
        S3SelectedRow(iPart) = PartLocX(iPart) - 1 + floor(partSize/2);
        S3SelectedCol(iPart) = PartLocY(iPart) - 1 + floor(partSize/2);
    end
    allS3SelectedRow = zeros(numRotate,numCandPart,'single');
    allS3SelectedCol = zeros(numRotate,numCandPart,'single');
    allS3SelectedOri = zeros(numRotate,numCandPart,'single');
    
    RotateS3Template;


for cc = 1:numOfCluster
    
    %% collect image patches with the same clustering id
    subFolder = ['./working' '/' 'cluster' num2str(cc)];
    if (exist(subFolder,'dir'))%experimental results
        delete([subFolder '/' '*.*']); 
    else
        mkdir(subFolder);
    end
end
disp('randomly cropping S3T patches on images')
numOfT = ones(1, numOfCluster);
for img = 1:numOfI   
    %% load data
    load( sprintf('./working/SUM1map_image_%d.mat',img), 'SUM1mapFind','MAX1map','M1Trace','M1RowShift','M1ColShift','M1OriShifted','J');
    %% cropping morphed SUM1map
    for ii = 1:numInitWordPerImage
        tmp_unwarp_img = zeros(templateSize,'single');
        tmpSUM1mapFind=cell(1,numOrient);
        for iOrient = 1:numOrient
            tmpSUM1mapFind{1,iOrient}=zeros(templateSize,'single');
        end
        

        clusterID = randi(numOfCluster);
        startIndex = (clusterID-1)*numPartRotate;       
        bestRes = randi(numImgResolution);
        bestRotInd = randi(numRotate); 
        partSizeX = partSize;
        partSizeY = partSize;
        [tmp_sx, tmp_sy]=size(J{bestRes});
        x_min = min(tmp_sx,halfX);
        x_max = max(1,tmp_sx-halfX);
        y_min = min(tmp_sy,halfY);
        y_max = max(1,tmp_sy-halfY);
        therex = randi([x_min,x_max])/subsampleS2/subsampleM2;
        therey = randi([y_min,y_max])/subsampleS2/subsampleM2;
        for iPart = 1:numCandPart
            actualPartRotationInd=find(partRotationRange==rotationRange(bestRotInd)); % assume no rotation
            Fx = therex + floor(.5+allS3SelectedRow(bestRotInd,iPart)/subsampleM2/subsampleS2);
            Fy = therey + floor(.5+allS3SelectedCol(bestRotInd,iPart)/subsampleM2/subsampleS2); % sub-sampled position
        	% find the part location at the higher resolution
        	Fx = (Fx-1 + .5) * subsampleS2 * subsampleM2;
        	Fy = (Fy-1 + .5) * subsampleS2 * subsampleM2;
        	
        	% crop the feature patch that is registered to the part template
            tmpSUM1mapLearn = mexc_CropInstance(SUM1mapFind(bestRes,:),Fx,Fy,...
                partRotationRange(actualPartRotationInd),tScale,1,...
                partOutRow{actualPartRotationInd},partOutCol{actualPartRotationInd},...
                numOrient,1,partSizeX,partSizeY);

            for o = 1:numOrient
               tmpSUM1mapFind{1,o}(PartLocX(iPart)-1+(1:partSizeX),PartLocY(iPart)-1+(1:partSizeY)) = tmpSUM1mapLearn{o};
            end
            
            tmp_patch = mexc_CropInstance(J(bestRes),Fx,Fy,...
                0,tScale,1,...
                partOutRow{actualPartRotationInd},partOutCol{actualPartRotationInd},...
                1,1,partSizeX,partSizeY);
            tmp_unwarp_img(PartLocX(iPart)-1+(1:partSizeX),PartLocY(iPart)-1+(1:partSizeY))=tmp_patch{1};
        end
        partSUM1map = tmpSUM1mapFind;
        activationScore = 0;
        save(['./working' '/' 'cluster' num2str(clusterID) '/' sprintf('ImageAndFeature_%d.mat',numOfT(clusterID))],'partSUM1map','activationScore');
        imwrite(tmp_unwarp_img/255,['./working' '/' 'cluster' num2str(clusterID) '/' sprintf('ImageAndFeature_%d.png',numOfT(clusterID))]);
        numOfT(clusterID)= numOfT(clusterID)+1; 
    end
    
end