function codeBook = LearnDictionary(imgCell)

if (exist('./output','dir'))%experimental results
    delete('./output/*.*'); 
else
    mkdir('output');
end
if exist('./working','dir')%working files
    delete('./working/*.mat'); 
else
    mkdir('working');
end
if exist('./sketch','dir')%image sketches
    delete('./sketch/*.*'); 
else
    mkdir('sketch');
end
%% set parameters
ParameterSettings;

%% compute SUM1MAP
SUM1MAX1;

%% initial assignment
InitAssignment;

%% EM-style steps
for iter = 1:numOfIteration
    
    %template re-learning by shared sketch algorithm
    TemplateLearning;
    
    %image encoding by matching pursuit algorithm
    ImageEncoding;
    
end;

%% return learned templates and necessary parameters

matFileList = dir('./output/learnedCodeWord*.mat');
codeBook = cell(size(matFileList));
for iMat = 1:length(matFileList)
    load(fullfile('./output',matFileList(iMat).name));
    codeWord.S3T = S3T;
    codeWord.S2T = S2T;
    codeBook{iMat}=codeWord;
end
%% clear the working directory and output directory
%{
   delete('./output/*.*');
   rmdir('./output')
   delete('./sketch/*.*');
   rmdir('./sketch');
   delete('./working/*.*');
   rmdir('./working'; 
%}
end



