%% Generate multi-resolution images and compute SUM1, MAX1 maps
disp('start filtering training images at all resolutions'); tic

for img = 1:numOfI
    
    disp(['image' num2str(img)]);
    load (sprintf('./working/image_%d.mat',img),'J');
    save(sprintf('./working/SUM1map_image_%d.mat',img),'J');
    SUM1mapFind = ApplyFilterfft(J, allFilter,...
        localHalfx, localHalfy, thresholdFactor); % filtering images at multiple resolutions
    mexc_Sigmoid(saturation, SUM1mapFind);
    save(sprintf('./working/SUM1map_image_%d.mat',img),'SUM1mapFind', '-append');
    MAX1map = cell(size(SUM1mapFind));
    M1Trace = cell(size(SUM1mapFind));
    for iRes = 1:numImgResolution
        [MAX1map(iRes,:) M1Trace(iRes,:) M1RowShift M1ColShift M1OriShifted] = ...
             mexc_ComputeMAX1( numOrient, SUM1mapFind(iRes,:), locationShiftLimit,...
             orientShiftLimit, 1 );
    end
    save(sprintf('./working/SUM1map_image_%d.mat',img),'MAX1map','M1Trace','M1RowShift','M1ColShift','M1OriShifted','-append');
    
end

disp(['filtering time: ' num2str(toc) ' seconds']);
