%% specify the output information
objLocation = zeros(1,2);
objLocation(1) = floor((templateTherex+.5)*subsampleS2);
objLocation(2) = floor((templateTherey+.5)*subsampleS2);
objRotation = bestRotInd;
objResolution = bestRes;

partAbsoluteLocation = zeros(numCandPart,2);
partAbsoluteRotation = zeros(numCandPart,1);
partAbsoluteResolution = zeros(numCandPart,1);

gaborAbsoluteLocation = zeros(numElement,2);
gaborAbsoluteRotation = zeros(numElement,1);
gaborAbsoluteResolution = zeros(numElement,1);


%% copy the detected patch (at object level)
if doCropBackImage
	patch = mexc_CropInstance(J(templateBestRes),objLocation(1),objLocation(2),...
		rotationRange(templateBestRot),0,1,...
		templateOutRow{templateBestRot},templateOutCol{templateBestRot},...
		1,1,sizeTemplatex,sizeTemplatey);
    patch = patch{1};
end

%% prepare the output variable for visualization of matched template
if showMatchedTemplate
    imageSizeAtBestObjectResolution = size( J{templateBestRes} );
	matchedSym = zeros( imageSizeAtBestObjectResolution );
    matchedBoundingBox = zeros( [imageSizeAtBestObjectResolution,3] );
    
    if showObjectBoundingBox
        margin = 2;
        xx = repmat((1:sizeTemplatex),1,margin*2);
        yy = [];
        for y = [1:margin sizeTemplatey-margin+1:sizeTemplatey]
            yy = [yy,ones(1,sizeTemplatex)*y];
        end
        yy = [yy,repmat((1:sizeTemplatey),1,margin*2)];
        for x = [1:margin sizeTemplatex-margin+1:sizeTemplatey]
            xx = [xx,ones(1,sizeTemplatey)*x];
        end
        inRow = single(xx-floor(sizeTemplatex/2)); inCol = single(yy-floor(sizeTemplatey/2));
        tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');
        [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                templateOutRow{templateBestRot},inRow,inCol,inO,inS,numOrient);
        % directly overwrite the corresponding pixels
        for p = 1:length(outRow)
            x = floor(.5 + floor((therex+.5)*subsampleS2) + outRow(p)); y = floor(.5 + floor((therey+.5)*subsampleS2) + outCol(p));
            if x > 0 && x <= size(matchedBoundingBox,1) && y > 0 && y <= size(matchedBoundingBox,2)
                matchedBoundingBox(x,y,:) = [.2 .8 .5];
            end
        end
    end
end

%% trace back the deformation tree and the associated scores
gaborCount = 0;
partInd = find(partTmpActivations(1,:) == iMember);
for iPart = 1:numCandPart
    
	% ==== continue to trace back Gabor elements based on the part
    partFx = partTmpActivations(2, partInd(iPart));
    partFy = partTmpActivations(3, partInd(iPart));
    clusterID = partTmpActivations(4, partInd(iPart));
    partBestRot = partTmpActivations(5, partInd(iPart));
    partBestRes = partTmpActivations(6, partInd(iPart));
    S2TInd = (clusterID-1)*numPartRotate+partBestRot;
	gaborXX = [];
	gaborYY = [];
	gaborOO = [];
	gaborMM = [];

	% Gabor basis elements locations
	for j = 1:length( allS2T{S2TInd,iPart}.selectedLambda )
		gaborX = floor(partFx +  allS2T{S2TInd,iPart}.selectedRow(j));
		gaborY = floor(partFy +  allS2T{S2TInd,iPart}.selectedCol(j));
		gaborO = allS2T{S2TInd,iPart}.selectedOri(j);
		if gaborX > 0 && gaborX <= size(M1Trace{partBestRes,1},1) && gaborY > 0 && gaborY <= size(M1Trace{partBestRes,1},2)
			trace = M1Trace{partBestRes,gaborO+1}(gaborX,gaborY) + 1;
			dx = M1RowShift{gaborO+1}(trace);
			dy = M1ColShift{gaborO+1}(trace);
			shiftedo = M1OriShifted{gaborO+1}(trace);
			gaborX = floor(.5 + gaborX + single(dx));
			gaborY = floor(.5 + gaborY + single(dy));
			gaborO = single(shiftedo);
		end
		gaborXX = [gaborXX;gaborX];
		gaborYY = [gaborYY;gaborY];
		gaborOO = [gaborOO;gaborO];
		gaborCount = gaborCount + 1;
		gaborAbsoluteLocation(gaborCount,1) = gaborX;
		gaborAbsoluteLocation(gaborCount,2) = gaborY;
		gaborAbsoluteRotation(gaborCount) = gaborO; % start from 0
		gaborAbsoluteResolution(gaborCount) = partBestRes;
		if gaborX > 0 && gaborX <= size(M1Trace{partBestRes,1},1) && gaborY > 0 && gaborY <= size(M1Trace{partBestRes,1},2)
			val = SUM1mapFind{partBestRes,gaborO+1}(gaborX,gaborY);
		else
			val = 0;
		end
		gaborMM = [gaborMM; max(0,sqrt(val)-.2)];
		gaborResponses(gaborCount) = val;
	end
	
	if showMatchedTemplate
		% render the template for each part separately, then overlay the rendered images
		tmpMatchedSym = displayMatchedTemplate(size(J{partBestRes}),gaborXX,...
			gaborYY,gaborOO,zeros(length(gaborXX),1,'single'),gaborMM,allSymbol,numOrient);
		tmpMatchedSym = double( imresize(tmpMatchedSym,imageSizeAtBestObjectResolution,'bilinear') );
		matchedSym = max(matchedSym,tmpMatchedSym);
		if showPartBoundingBox
            margin = 3;
            xx = repmat((1:partSizeX),1,margin*2);
            yy = [];
            for y = [1:margin partSizeY-margin+1:partSizeY]
                yy = [yy,ones(1,partSizeX)*y];
            end
            yy = [yy,repmat((1:partSizeY),1,margin*2)];
            for x = [1:margin partSizeX-margin+1:partSizeX]
                xx = [xx,ones(1,partSizeY)*x];
            end
            inRow = single(xx-floor(partSizeX/2)); inCol = single(yy-floor(partSizeY/2));
            tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');
            [outRow, outCol] = ...
                mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                    partRotationRange(partBestRot),inRow,inCol,inO,inS,numOrient);
                
            % directly overwrite the corresponding pixels
            matchedBoundingBox = imresize(matchedBoundingBox,size(J{partBestRes}),'nearest');
            for p = 1:length(outRow)
                x = floor(.5 + outRow(p) + partFx); y = floor(.5 + outCol(p) + partFy);
                if x > 0 && x <= size(matchedBoundingBox,1) && y > 0 && y <= size(matchedBoundingBox,2)
                    matchedBoundingBox(x,y,:) = [1.0 1.0 1.0];
                end
            end
            matchedBoundingBox = imresize(matchedBoundingBox,size(J{templateBestRes}),'nearest');
		end
	end
end

if showPartBoundingBox
    % overlay
   
    tmpSym = repmat(-matchedSym,[1 1 3]);
    matchedSym = repmat(-matchedSym,[1 1 3]);
    if ((max(matchedSym(:))-min(matchedSym(:))) ~=0)
        matchedSym = 1 * (matchedSym-min(matchedSym(:)))/(max(matchedSym(:))-min(matchedSym(:)));
    end;
    for y = 1:size(matchedSym,2)
        for x = 1:size(matchedSym,1)
            if sum(abs(matchedBoundingBox(x,y,:))) > 0
                matchedSym(x,y,:) = matchedBoundingBox(x,y,:);
            end
        end
    end
end
if mean(matchedSym(:))<0.5
    matchedSym = 1-matchedSym;
end;

if showMatchedTemplate
    imwrite( matchedSym, [sketchDir '\' sprintf('matched_image_%d_part%d.png',img,iMember)] );
    resizedMatch = imresize(matchedSym, [size(indX{1}, 1), size(indX{1}, 2)],'nearest');
    for ii = 1:size(indX{1},1)
        for jj = 1:size(indX{1},2)
            tmp1 = indX{1}(ii, jj);
            tmp2 = indY{1}(ii, jj);
            if (tmp1>=1 && tmp1<=size(newI,1) && tmp2>=1 && tmp2<=size(newI,2))
                newI(tmp1,tmp2,:) = resizedMatch(ii,jj,:);
            end;
        end
    end
    resizedNewI = imresize(newI, [sizeIx, sizeIy], 'nearest');
    sketchI = min(sketchI, resizedNewI);
    partI{iMember} = newI;
end