%function confMat = fourDomainExpV3(srcDomain,tgtDomain,seed)
% four domain names are 'dslr' 'amazon' 'caltech' 'webcam'
numRepetition = 4;
seed = 1;

%% constants
domainPairs = cell(8,2);
domainPairs{1,1}='caltech'; domainPairs{1,2}='amazon';
domainPairs{2,1}='caltech'; domainPairs{2,2}='dslr';
domainPairs{3,1}='amazon'; domainPairs{3,2}='caltech';
domainPairs{4,1}='amazon'; domainPairs{4,2}='webcam';
domainPairs{5,1}='webcam'; domainPairs{5,2}='caltech';
domainPairs{6,1}='webcam'; domainPairs{6,2}='amazon';
domainPairs{7,1}='dslr'; domainPairs{7,2}='amazon';
domainPairs{8,1}='dslr'; domainPairs{8,2}='webcam';

%% code segment
rng(seed); % set the seed so that experiments are reproducible
imgPath = '../dataset/';
sy = 150;
numExp = numRepetition*8;
inPutArgs = cell(numExp,1);
for iExp = 1:numExp
    disp(['cropping data for exp ' num2str(iExp)])
    jExp = mod(iExp-1,8)+1;
    [trainImgs, testImgs, trainLabels,testLabels]=splitData(imgPath,domainPairs{jExp,1},domainPairs{jExp,2},sy);
    inPutArgs{iExp}={trainImgs, testImgs, trainLabels,testLabels};
end

parallel.defaultClusterProfile('test01')
c = parcluster('test01');
tmp_list=ListAttachedFiles;
jobArray=cell(numRepetition,1);
for iBatch = 1:numRepetition
    jobArray{iBatch} = createJob(c);
    jobArray{iBatch}.AttachedFiles = tmp_list;
    createTask(jobArray{iBatch},@oneDomainPairExp,2,inPutArgs((iBatch-1)*8+1:iBatch*8));
    submit(jobArray{iBatch});
end
for iBatch = 1:numRepetition
    disp('Now waiting for the cluster...')
    wait(jobArray{iBatch});
end
resultArray = cell(numRepetition,1);
for iBatch = 1:numRepetition
    resultArray{iBatch} =fetchOutputs(jobArray{iBatch});
end
table = zeros(numRepetition,8);
for iBatch = 1:numRepetition
    for iClass = 1:8
    table(iBatch,iClass) = resultArray{iBatch}{iClass,2}(1);
    end
end

resName = ['result_' datestr(now,'yyyymmddTHHMMSS') '.mat'];
save(resName)
    
