function [codeBook acc]= oneDomainPairExp(trainImgs,testImgs,trainLabels,testLabels)
AttachLoc = getAttachedFilesFolder;
if ~exist( './storedExponentialModel.mat','file')
    copyfile(fullfile(AttachLoc,'storedExponentialModel.mat'),'./storedExponentialModel.mat');
end
    codeBook = [];
    for iClass = 1:10
        idx = (trainLabels==iClass);
        codeWords =LearnDictionary(trainImgs(idx));
        codeBook = [codeBook;codeWords];
        outPath = fullfile('./output', ['class' num2str(iClass,'%02d')]);
        if ~exist( outPath,'dir')
            mkdir(outPath)
        else
            delete(fullfile(outPath,'*.*'));
        end
        fileList = dir('./output/*.png');
        for iFile= 1:length(fileList)
            copyfile(fullfile('./output',fileList(iFile).name),fullfile(outPath,fileList(iFile).name));
        end
    end

    % extract features for training and testing images
    trainFeatures = BatchExtractFeatures(trainImgs,codeBook);
    testFeatures = BatchExtractFeatures(testImgs,codeBook);

    % train the model using muli-class svm
    %{ 
    Details of liblinar options
    -s type : set type of solver (default 1)
      for multi-class classification
             0 -- L2-regularized logistic regression (primal)
             1 -- L2-regularized L2-loss support vector classification (dual)
             2 -- L2-regularized L2-loss support vector classification (primal)
             3 -- L2-regularized L1-loss support vector classification (dual)
             4 -- support vector classification by Crammer and Singer
             5 -- L1-regularized L2-loss support vector classification
             6 -- L1-regularized logistic regression
             7 -- L2-regularized logistic regression (dual)
    -c cost : set the parameter C (default 1)
    -p epsilon : set the epsilon in loss function of epsilon-SVR (default 0.1)
    -e epsilon : set tolerance of termination criterion
    -B bias : if bias >= 0, instance x becomes [x; bias]; if < 0, no bias term added (default -1)
    -wi weight: weights adjust the parameter C of different classes (see README for details)
    -v n: n-fold cross validation mode
    -q : quiet mode (no outputs)
    %}
    libLinearOptions = ['-s 4 -c 1 -B 0 -q'];
    model = train(trainLabels,sparse(trainFeatures),libLinearOptions);

    % test the model, and get confusion matrix
    [~,acc] = predict(testLabels,sparse(testFeatures),model);
   
    %{
    T = zeros(max(testLabels),length(testLabels));
    Y = T;
    for iSample = 1:length(testLabels)
        T(testLabels(iSample),iSample)=1;
        Y(testLabelsHat(iSample),iSample)=1;
    end
    [~,confMat,~,~] =confusion(T,Y);
    datestr(clock)
    %}
end