function [trainImgs, testImgs, trainLabels, testLabels]=splitData(imgPath,srcDomain,tgtDomain,sy)
    numClass = 10;
    if strcmp(srcDomain,'dslr') || strcmp(srcDomain,'webcam')
        num_train_src = 8;
    else
        num_train_src = 20;
    end
    num_train_tgt = 3;

    trainImgs = cell(0);
    testImgs = cell(0);
    trainLabels = [];
    testLabels=[];
    % load images from src domain
    for iClass = 1:numClass
        class_label = domainClassName(srcDomain,iClass);
        if strcmp(srcDomain,'caltech')
            sub_path = ['256_ObjectCategories/' class_label];
        else
            sub_path = [srcDomain '/images/' class_label];
        end
        imgList = dir(fullfile(imgPath,sub_path,'*.jpg'));
        idx= randperm(length(imgList));
        for iImg= 1:num_train_src
            img = imread(fullfile(imgPath,sub_path,imgList(idx(iImg)).name));
            img = imresize(img,[NaN sy]);
            trainImgs{end+1}=img;
            trainLabels = [trainLabels; iClass];
        end
    end

    % load images from target domain
    for iClass = 1:numClass
        class_label = domainClassName(tgtDomain,iClass);
        if strcmp(tgtDomain,'caltech')
            sub_path = ['256_ObjectCategories/' class_label];
        else
            sub_path = [tgtDomain '/images/' class_label];
        end
        imgList = dir(fullfile(imgPath,sub_path,'*.jpg'));
        idx= randperm(length(imgList));

        for iImg= 1:num_train_tgt
            img = imread(fullfile(imgPath,sub_path,imgList(idx(iImg)).name));
            img = imresize(img,[NaN sy]);
            trainImgs{end+1}=img;
            trainLabels = [trainLabels; iClass];
        end

        for iImg = num_train_tgt+1:length(idx)
            img = imread(fullfile(imgPath,sub_path,imgList(idx(iImg)).name));
            img = imresize(img,[NaN sy]);
            testImgs{end+1}=img;
            testLabels = [testLabels; iClass];
        end
    end

end
