%%
disp('randomly extract image patches');
halfX = floor(sizeTemplatex/2);
halfY = floor(sizeTemplatey/2);
activations = zeros(6, numOfRandomPatch*numOfI);
orgR = ceil(numImgResolution/2);
for img = 1:numOfI
    
    load (sprintf('working/image_%d.mat',img),'J');
    sizeIx = size(J{orgR},1);
    sizeIy = size(J{orgR},2);
    tmpActivations = zeros(6,numOfRandomPatch);
    tmpActivations(1,:) = ones(1,numOfRandomPatch)*img;%image ID
    tmpActivations(2,:) = floor( rand(1,numOfRandomPatch)*(sizeIx -2*halfX) + halfX ); %centroid of image patch
    tmpActivations(3,:) = floor( rand(1,numOfRandomPatch)*(sizeIy -2*halfY) + halfY );%centroid of image patch
    tmpActivations(4,:) = ceil( rand(1,numOfRandomPatch)*orgR );%no resolutions change
    tmpActivations(5,:) = (ceil( rand(1,numOfRandomPatch)*numOfCluster )-1)*nTransform + ceil(nTransform/2);%random rotations
    tmpActivations(6,:) = ceil( rand(1,numOfRandomPatch)*1 );%SUM3map score
    startInd = (img-1)*numOfRandomPatch;
    activations(:, startInd+1:startInd+numOfRandomPatch) = tmpActivations;
    
end;

%activations = zeros(6, numOfRandomPatch*numOfCluster);
%tmpActivations = zeros(6,1);
%orgR = ceil(numImgResolution/2);
%for cc = 1:numOfCluster
%    for ii = 1:numOfRandomPatch
%        imgId = ceil(rand(1)*numOfI);
%        tmpActivations(1) = imgId;
%        load (sprintf('working/image_%d.mat',imgId),'J');
%        sizeIx = size(J{orgR},1);
%        sizeIy = size(J{orgR},2);
%        tmpActivations(2) = floor( rand(1)*(sizeIx -2*halfX) + halfX ); %centroid of image patch
%        tmpActivations(3) = floor( rand(1)*(sizeIy -2*halfY) + halfY );%centroid of image patch
%        tmpActivations(4) = orgR;%no resolutions change
%        tmpActivations(5) = (cc-1)*nTransform + ceil(nTransform/2);%no rotation
%        tmpActivations(6) = 1;
%        activations(:, (cc-1)*numOfRandomPatch+ii) = tmpActivations;
%    end
%end

denseX = -floor(templateSize(1)/2) + (1:templateSize(1));
denseY = denseX;
count = 0;
inRow = zeros(length(denseX)*length(denseY),1,'single');
inCol = zeros(length(denseX)*length(denseY),1,'single');
for y = denseY
    for x = denseX
        count = count+1;
        inRow(count) = x;
        inCol(count) = y;
    end
end
tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');

activatedCluster = ceil( ( activations(5,:)) / nTransform );%clustering memberships
activatedTransform = activations(5,:) - (activatedCluster-1) * nTransform;%transformation
for cc = 1:numOfCluster
    
    %% collect image patches with the same clustering id
    subFolder = ['working' '/' 'cluster' num2str(cc)];
    if (exist(subFolder,'dir'))%experimental results
        delete([subFolder '/' '*.*']); 
    else
        mkdir(subFolder);
    end
    ind = find(activatedCluster == cc);
    if length(ind) > maxNumClusterMember% sample a subset if necessary
        idx = randperm(length(ind));
        ind = ind(idx(1:maxNumClusterMember));
        ind = sort(ind,'ascend');
    end
    numImage = length(ind);
    
    %% start cropping image patches
    for iMember = 1:numImage
        currentImg = activations(1, ind(iMember));
        SUM1MAX1mapName = ['working' '/SUM1map_image_' num2str(currentImg)];
        load(SUM1MAX1mapName, 'J','SUM1mapFind');
        nRot = activatedTransform(ind(iMember));
        tmpS = mexc_CropInstance(SUM1mapFind(activations(4,ind(iMember)),:),...
                        activations(2,ind(iMember))-1,...
                        activations(3,ind(iMember))-1,...
                        rotationRange(activatedTransform(ind(iMember))),tScale,1,...
                        templateOutRow{nRot},templateOutCol{nRot},...
                        numOrient,1,templateSize(1),templateSize(2));
        partSUM1map = tmpS;
        save([subFolder '/' sprintf('ImageAndFeature_%d.mat',iMember)], 'partSUM1map');
    end
    
end;
