%% learning templates from cropped image patches
disp(['start re-learning template iteration ' num2str(iter)]);
%update parameters
if iter<numOfIterationInitial
    S3Thre = S3ThreInitial;
    relativePartRotationRange = relativePartRotationRangeInitial;
    partRotations = partRotationsInitial;
    partRotationRange = partRotationRangeInitial;
    numPartRotate = numPartRotateInitial;
    minRotationDif = minRotationDifInitial;
    partLocRange = partLocRangeInitial;
    allTemplateAffinityMatrix = allTemplateAffinityMatrixInitial;
    partOutRow = partOutRowInitial;
    partOutCol = partOutColInitial;
else
    S3Thre = S3ThreFinal;
    relativePartRotationRange = relativePartRotationRangeFinal;
    partRotations = partRotationsFinal;
    partRotationRange = partRotationRangeFinal;
    numPartRotate = numPartRotateFinal;
    minRotationDif = minRotationDifFinal;
    partLocRange = partLocRangeFinal;
    allTemplateAffinityMatrix = allTemplateAffinityMatrixFinal;
    partOutRow = partOutRowFinal;
    partOutCol = partOutColFinal;
end

for cc = 1:numOfCluster
    
    %collect SUM1MAP
    featureName = dir(['working/cluster' num2str(cc) '/' 'ImageAndFeature_*.mat']);
    numImage = length(featureName);
    if numImage >= minImagePatch
        croppedSUM1Map = cell(numImage, numOrient);
        for iMember = 1:numImage
            load(['working/cluster' num2str(cc) '/' sprintf('ImageAndFeature_%d.mat',iMember)],'partSUM1map');
            croppedSUM1Map(iMember,:) = partSUM1map;
        end

        %prepare output variables for learning
        selectedOrient = cell(numCandPart, 1);%orientation and location of selected Gabors
        selectedx = cell(numCandPart, 1);
        selectedy = cell(numCandPart, 1);
        selectedlambda = cell(numCandPart, 1);%weighting parameter for scoring template matching
        selectedLogZ = cell(numCandPart, 1);%normalizing constant

        allSelectedx = cell(numCandPart, numRotate); 
        allSelectedy = cell(numCandPart, numRotate);
        allSelectedOrient = cell(numCandPart, numRotate);

        PartOnOff = ones(numCandPart,1); % all parts are selected initially
        selectedPart = find(PartOnOff);
        S3SelectedRow = zeros(1,numCandPart,'single');
        S3SelectedCol = zeros(1,numCandPart,'single');
        S3SelectedOri = zeros(1,numCandPart,'single');
        for iPart = 1:numCandPart
            S3SelectedRow(iPart) = PartLocX(iPart) - 1 + floor(partSize/2);
            S3SelectedCol(iPart) = PartLocY(iPart) - 1 + floor(partSize/2);
        end
        allS3SelectedRow = zeros(numRotate,numCandPart,'single');
        allS3SelectedCol = zeros(numRotate,numCandPart,'single');
        allS3SelectedOri = zeros(numRotate,numCandPart,'single');

        RotateS3Template;

        % learn large templates
        tmpSelectedx = zeros(numElement,1);
        tmpSelectedy = zeros(numElement,1);
        tmpSelectedo = zeros(numElement,1);
        tmpSelectedlambda = zeros(numElement,1);
        tmpSelectedlogz = zeros(numElement,1);
        deformedTemplate = cell(numImage,1);
        tmpCommonTemplate = zeros( sizeTemplatex, sizeTemplatey, 'single' );
        for i = 1:numImage
            deformedTemplate{i} = zeros( sizeTemplatex, sizeTemplatey, 'single' );
        end

        CsharedSketch(numOrient, locationShiftLimit, orientShiftLimit, subsample, ... % about active basis  
           numElement, numImage, sizeTemplatex, sizeTemplatey,  croppedSUM1Map, ... % about training images 
           halfFilterSize, Correlation, allSymbol(1, :), ... % about filters
           numStoredPoint, storedlambda, storedExpectation, storedLogZ, ... % about exponential model 
           tmpSelectedo, tmpSelectedx, tmpSelectedy, tmpSelectedlambda, tmpSelectedlogz, ... % learned parameters
           tmpCommonTemplate, deformedTemplate); % learned templates

        filename = sprintf('output/cluster_%d_template_iter%d.png',cc,iter);
        towrite = -double(tmpCommonTemplate);
        towrite = uint8(255 * (towrite-min(towrite(:)))/(1e-10+max(towrite(:))-min(towrite(:))));
        if max(towrite(:)) == 0
            towrite(:) = 255;
        end
        colorToWrite = outputT/max(outputT(:));
        [indsX indsY] = find(towrite<150);
        tmpLenX = length(indsX);
        tmpLenY = length(indsY);
        for ii = 1:tmpLenX
            for jj = 1:tmpLenY
                colorToWrite(indsX(ii), indsY(ii), :) = colors(cc,:);
            end
        end
        imwrite(colorToWrite,filename);

        % split the object template into non-overlapping partial templates
        for iPart = 1:numCandPart
            ind = find( tmpSelectedx >= PartLocX(iPart) & tmpSelectedx < PartLocX(iPart) + partSize & ...
                    tmpSelectedy >= PartLocY(iPart) & tmpSelectedy < PartLocY(iPart) + partSize );
            selectedOrient{iPart} = single( tmpSelectedo(ind) );
            selectedx{iPart} = single( floor( tmpSelectedx(ind) - PartLocX(iPart) ) );
            selectedy{iPart} = single( floor( tmpSelectedy(ind) - PartLocY(iPart) ) );
            selectedlambda{iPart} = single( tmpSelectedlambda(ind) );
            selectedLogZ{iPart} = single( tmpSelectedlogz(ind) );
        end

        RotateTemplate;

        S2T = cell( numPartRotate, numCandPart );
        for iPart = 1:numCandPart
            for r = 1:length(partRotationRange)
                S2T{r,iPart} = struct( 'selectedRow',single(allSelectedx{iPart,r}(:)),...
                    'selectedCol', single(allSelectedy{iPart,r}(:)),...
                    'selectedOri', single(allSelectedOrient{iPart,r}(:)),...
                    'selectedScale', zeros(length(allSelectedx{iPart,r}),1,'single'),...
                    'selectedLambda', single(selectedlambda{iPart}(:)),...
                    'selectedLogZ', single(selectedLogZ{iPart}(:)) );
            end
        end

        S3T = cell(length(rotationRange),1);
        for r = 1:length(rotationRange) % this is the rotation of the S3 template
            rot = rotationRange(r);
            selectedTransform = zeros(length(selectedPart),1,'single');
            for j = 1:length(selectedPart)
                selectedTransform(j) = find( allS3SelectedOri(r,j) == partRotationRange );
            end
            S3T{r} = struct( 'selectedRow',single(floor(.5+allS3SelectedRow(r,selectedPart)/subsampleM2/subsampleS2)),...
                    'selectedCol', single(floor(.5+allS3SelectedCol(r,selectedPart)/subsampleM2/subsampleS2)),...
                    'selectedInd', single(selectedPart) - 1,...
                    'selectedTransform', selectedTransform - 1,...
                    'selectedLambda', ones(length(selectedPart),1,'single'),...
                    'selectedLogZ', single( 0*ones(length(selectedPart),1) ) );
        end
    else
        load (sprintf('working/smallTemplate_Iter%d_Cluster%d.mat',iter-1,cc),'S2T','S3T');
        dst = sprintf('output/cluster_%d_template_iter%d.png',cc,iter);
        src = sprintf('output/cluster_%d_template_iter%d.png',cc,iter-1);
        copyfile(src, dst);
    end

    save(sprintf('working/smallTemplate_Iter%d_Cluster%d.mat',iter,cc),'S2T','S3T');

end;