% The detection module for Hierarchical Active Basis.
%
% It takes the HAB model files and a JPEG source image or filtered image as input.
%
% It outputs the following information:
% 1) The hierarchical deformation of HAB: a tree with placements (location, orierntation, scale) of the object, parts and edge elements.
% 2) The hierarchical score of HAB: a tree with scores or responses of the object, parts and edge elements.
% 3) The visualization of deformed HAB on the observed image. 
% 4) (optional) The cropped Gabor filter response map and image patch by
% morphing back from the observed response map or image.
% paths
modelFolder = 'working';
featureFolder = 'working';
reLoadModel = false; % if true -> enforce the model to be reloaded
iter = numOfIteration;
% parameters for "morphing-back"
doMorphBackS1map = true;
doCropBackImage = true;
% parameters for visualization of deformed HAB
showMatchedTemplate = true;
showPartBoundingBox = true;
showObjectBoundingBox = true;
resolutionShiftLimit = 1;
maxPartRelativeRotation = 2;

activatedCluster = ceil( ( activations(5,:)) / nTransform );
activatedTransform = activations(5,:) - (activatedCluster-1) * nTransform;

for img = 1:numOfI
    
    imageName = sprintf('Image_%d', img);
    featurefile = sprintf('%s/%s.mat',featureFolder,imageName);
    imgInd = find(activations(1,:) == img);
    SUM1MAX1mapName = ['working' '/SUM1map_image_' num2str(img)];
    load(SUM1MAX1mapName, 'J','SUM1mapFind');
    sizeIx = size(J{numImgResolution},1); 
    sizeIy = size(J{numImgResolution},2);
    sketchI = ones(sizeIx, sizeIy, 3);
    partI = cell(1, length(imgInd));
    
    
    for iMember = 1:length(imgInd)
        % use mex-C code instead: crop S1 map
        % warning: if the templates are of different sizes, we need to alter outRow and outCol (use only a subset of it).
        load(SUM1MAX1mapName, 'J','SUM1mapFind');
        newI = ones(size(J{activations(4,imgInd(iMember))},1), size(J{activations(4,imgInd(iMember))},2), 3);
        tmpX = single((1:size(newI,1))');
        xI = cell(1,1);
        xI{1} = repmat(tmpX, 1, size(newI,2));
        tmpY = single((1:size(newI,2)));
        yI = cell(1,1);
        yI{1} = repmat(tmpY, size(newI,1), 1);
        
        denseX = -floor(templateSize(1)/2) + (1:templateSize(1));
        denseY = denseX;
        count = 0;
        inRow = zeros(length(denseX)*length(denseY),1,'single');
        inCol = zeros(length(denseX)*length(denseY),1,'single');
        for y = denseY
            for x = denseX
                count = count+1;
                inRow(count) = x;
                inCol(count) = y;
            end
        end
        tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');
        [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                rotationRange(activatedTransform(imgInd(iMember))),inRow,inCol,inO,inS,numOrient);
            
        K = mexc_CropInstance(J(activations(4,imgInd(iMember))),...
                    activations(2,imgInd(iMember))-1,...
                    activations(3,imgInd(iMember))-1,...
                    rotationRange(activatedTransform(imgInd(iMember))),tScale,1,...
                    outRow,outCol,...
                    1,1,templateSize(1),templateSize(2));
                
        indX = mexc_CropInstance(xI(1),...
                    activations(2,imgInd(iMember))-1,...
                    activations(3,imgInd(iMember))-1,...
                    rotationRange(activatedTransform(imgInd(iMember))),tScale,1,...
                    outRow,outCol,...
                    1,1,templateSize(1),templateSize(2));
                
        indY = mexc_CropInstance(yI(1),...
                    activations(2,imgInd(iMember))-1,...
                    activations(3,imgInd(iMember))-1,...
                    rotationRange(activatedTransform(imgInd(iMember))),tScale,1,...
                    outRow,outCol,...
                    1,1,templateSize(1),templateSize(2));
                
        S = mexc_CropInstance(SUM1mapFind(activations(4,imgInd(iMember)),:),...
                    activations(2,imgInd(iMember))-1,...
                    activations(3,imgInd(iMember))-1,...
                    rotationRange(activatedTransform(imgInd(iMember))),tScale,1,...
                    outRow,outCol,...
                    numOrient,1,templateSize(1),templateSize(2));
                
        ImageMultiResolution = cell(1,numImgResolution);
        tmpSUM1 = cell(numImgResolution, numOrient);
        for j=1:numImgResolution
            resolution = valResolution(j);
            ImageMultiResolution{j} = imresize(K{1}, resolution, 'bilinear');  % images at multiple resolutions
            for no = 1:numOrient
                tmpSUM1{j, no} = imresize(S{no}, resolution, 'bilinear');  % images at multiple resolutions
            end
        end

        %SUM1mapFind = ApplyFilterfft(ImageMultiResolution, allFilter,...
        %    localHalfx, localHalfy, thresholdFactor); % filtering images at multiple resolutions
        SUM1mapFind = tmpSUM1;
        mexc_Sigmoid(saturation, SUM1mapFind);

        MAX1map = cell(size(SUM1mapFind));
        M1Trace = cell(size(SUM1mapFind));
        for iRes = 1:numImgResolution
            [MAX1map(iRes,:) M1Trace(iRes,:) M1RowShift M1ColShift M1OriShifted] = ...
                 mexc_ComputeMAX1( numOrient, SUM1mapFind(iRes,:), locationShiftLimit,...
                 orientShiftLimit, 1 );
        end
        
        load (sprintf('working/smallTemplate_Iter%d_Cluster%d.mat',iter,activatedCluster(imgInd(iMember))),'S2T','S3T');
        
        drawTemplate;
        
    end;
    reconstructI = uint8( 255 * (sketchI-min(sketchI(:)))/(max(sketchI(:))-min(sketchI(:))) );
    imwrite( reconstructI, ['sketch' '\' sprintf('sketchedI_%s.png',imageName)] );
end;



	

