S3Thre = 2.0*numElement;
%% parameters at the second layer that corresponds to smaller parts
locationPerturbFraction = 1/20;%part perturbation
subsample = 1;%subsample in computing MAX1 and SUM2 maps   
subsampleS2 = 1; subsampleM2 = 1;
locationShiftLimit = 2;%shift in normal direction = locationShiftLimit*subsample pixels
orientShiftLimit = 1;%shift in orientation
relativePartRotationRange = 1*(-1:1);
partRotations = cell(numRotate, 1);%part rotation (rotation of partial templates)
partRotationRange = [];
for ii = 1:numRotate
    tmpRotation = rotationRange(ii)+relativePartRotationRange;
    partRotations{ii} = tmpRotation;
    partRotationRange = union( partRotationRange, tmpRotation );
end
numPartRotate = length(partRotationRange);
minRotationDif = (sin(1*pi/numOrient)-sin(0))^2 + (cos(1*pi/numOrient)-cos(0))^2 + 1e-10;
partSize = sizeTemplatex/2;
numSecondLayerTemplates = 4;
PartLocX0 = 1:partSize:templateSize(1)-partSize+1;
PartLocY0 = 1:partSize:templateSize(2)-partSize+1;
partLocRange = floor(partSize*locationPerturbFraction);
numCandPart = length(PartLocX0) * length(PartLocY0);
PartLocX = zeros(numCandPart,1);
PartLocY = zeros(numCandPart,1);
iPart = 1;
for x = PartLocX0
    for y = PartLocY0
        PartLocX(iPart) = x;
        PartLocY(iPart) = y;
        iPart = iPart + 1;
    end
end

%% compute affinity matrix
allTemplateAffinityMatrix = cell(numPartRotate*numOfCluster, numCandPart);
for cc = 1:numOfCluster
    templateAffinityMatrix = cell(numPartRotate,numCandPart);
    for iPart = 1:numCandPart
        for r1 = 1:length(partRotationRange)
            angle1 = pi/numOrient * partRotationRange(r1);
            templateAffinityMatrix{r1,iPart} = [];
            jPart = iPart;
            for r2 = 1:length(partRotationRange)
                angle2 = pi/numOrient*partRotationRange(r2);
                if (sin(angle1) - sin(angle2))^2 + (cos(angle1)-cos(angle2))^2 <= minRotationDif
                    templateAffinityMatrix{r1,iPart} = int32( [templateAffinityMatrix{r1,iPart} r2-1] );
                end
            end
        end
    end
    for iPart = 1:numCandPart
        startInd = (cc-1)*numPartRotate + (iPart-1)*numPartRotate*numOfCluster;
        rowId = (cc-1)*numPartRotate;
        for r2 = 1:length(partRotationRange)
            allTemplateAffinityMatrix{rowId+r2, iPart} = templateAffinityMatrix{r2, iPart}(:)+startInd;
        end
    end
end

%% compute template rotation
denseX = -floor(templateSize(1)/2) + (1:templateSize(1));
denseY = denseX;
count = 0;
inRow = zeros(length(denseX)*length(denseY),1,'single');
inCol = zeros(length(denseX)*length(denseY),1,'single');
for y = denseY
    for x = denseX
        count = count+1;
        inRow(count) = x;
        inCol(count) = y;
    end
end
tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');
templateOutRow = cell(numRotate,1);
templateOutCol = cell(numRotate,1);
for nRot = 1:numRotate
   
    [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                rotationRange(nRot),inRow,inCol,inO,inS,numOrient);
    
    templateOutRow{nRot} = outRow;
    templateOutCol{nRot} = outCol;
    
end

%% compute part rotation
denseX = -floor(partSize/2) + (1:partSize);
denseY = denseX;
count = 0;
inRow = zeros(length(denseX)*length(denseY),1,'single');
inCol = zeros(length(denseX)*length(denseY),1,'single');
for y = denseY
    for x = denseX
        count = count+1;
        inRow(count) = x;
        inCol(count) = y;
    end
end
partOutRow = cell(numPartRotate,1);
partOutCol = cell(numPartRotate,1);
for nRot = 1:numPartRotate
   
    [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                partRotationRange(nRot),inRow,inCol,inO,inS,numOrient);
    
    partOutRow{nRot} = outRow;
    partOutCol{nRot} = outCol;
    
end