%% load exponential model
load 'storedExponentialModel';

%% parameters for filters
epsilon = .1;%allowed correlation between selected Gabors 
Correlation = CorrFilter(allFilter, epsilon);%correlation between filters 

%% parameters for images
minHeightOrWidth = 200;%image resize factor
imgResizeFactor = 0.5;%image resize factor
numImgResolution = 3;%number of image resolutions
valResolution = [0.8 1.0 1.2];%values of resolutions
imageFolder = 'net';%training images  
imageName = dir([imageFolder '/*.jpg']);
numOfI = size(imageName, 1);%number of training images
for img = 1 : numOfI%read images
	tmpImg = imread([imageFolder '/' imageName(img).name]);
    if ndims(tmpImg) == 3
		tmpImg = rgb2gray(tmpImg);
    end
    Ix = size(tmpImg,1);
    Iy = size(tmpImg,2);
	%I = imresize(single(tmpImg), minHeightOrWidth/min(Ix, Iy), 'bilinear');%need to be changed
    I = imresize(single(tmpImg), imgResizeFactor,'bilinear');
    J = cell(1, numImgResolution);
    for iResolution = 1:numImgResolution
        J{iResolution} = imresize(I, valResolution(iResolution), 'bilinear');
    end
    save(sprintf('working/image_%d.mat',img),'J');
end

%% parameters for the whole iterative algorithm
numOfIterationInitial = 2;%number of interations when parts are freezen
numOfIteration = 10;%number of iterations
numOfRandomPatch = 10;%the number of image patches initially sampled from each image as starts, should be a large value if the training image is small
minImagePatch = 1;%minimal number of image patches that will be used for re-learning templates

%% parameters for large templates
numOfCluster = 2;%number of large templates
numElement = 70;%number of Gabors in active basis
maxNumClusterMember = 50;%maximal number of patches used for shared sketch algorithm
sizeTemplatex = 120; sizeTemplatey = sizeTemplatex;%template size
templateSize = [sizeTemplatex sizeTemplatex];%template size
rotationRange = 2*(-1:1);%template rotation
numRotate = length(rotationRange);%number of template rotations
nTransform = numRotate;
locationPerturbationFractionMP = .4;%the size of neighborhood for MAX2 pooling, as well as surround supression
S3ThreInitial = 0.5*numElement;%threshold value for matching pursuit at beginning several iterations
S3ThreFinal = 1.0*numElement;%threshold value for matching pursuit at later iterations
denseX = -floor(templateSize(1)/2) + (1:templateSize(1));%template rotation affinity
denseY = denseX;
count = 0;
inRow = zeros(length(denseX)*length(denseY),1,'single');
inCol = zeros(length(denseX)*length(denseY),1,'single');
for y = denseY
    for x = denseX
        count = count+1;
        inRow(count) = x;
        inCol(count) = y;
    end
end
tScale = 0; rScale = 1; cScale = 1; inO = zeros(numel(inRow),1,'single'); inS = zeros(numel(inRow),1,'single');
templateOutRow = cell(numRotate,1);
templateOutCol = cell(numRotate,1);
for nRot = 1:numRotate
   
    [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                rotationRange(nRot),inRow,inCol,inO,inS,numOrient);
    
    templateOutRow{nRot} = outRow;
    templateOutCol{nRot} = outCol;
    
end
colors = colormap(hsv(numOfCluster));%used for display learned templates

%% parameters for small parts
numTemplateSplit = 3;
partSize = sizeTemplatex/numTemplateSplit;
partLocRangeInitial = 0;%initial part location perturbation range
partLocRangeFinal = 4;%final part location perturbation range
subsample = 1;%subsample in computing MAX1 and SUM2 maps   
subsampleS2 = 1; subsampleM2 = 1;
locationShiftLimit = 1;%shift in normal direction = locationShiftLimit*subsample pixels
orientShiftLimit = 1;%shift in orientation
relativePartRotationRangeInitial = 1*(-0:0);
relativePartRotationRangeFinal = 1*(-1:1);
partRotationsInitial = cell(numRotate, 1);%part rotation (rotation of partial templates)
partRotationsFinal = cell(numRotate, 1);%part rotation (rotation of partial templates)
partRotationRangeInitial = [];
partRotationRangeFinal = [];
for ii = 1:numRotate
    tmpRotationInitial = rotationRange(ii)+relativePartRotationRangeInitial;
    partRotationsInitial{ii} = tmpRotationInitial;
    partRotationRangeInitial = union( partRotationRangeInitial, tmpRotationInitial );
    tmpRotationFinal = rotationRange(ii)+relativePartRotationRangeFinal;
    partRotationsFinal{ii} = tmpRotationFinal;
    partRotationRangeFinal = union( partRotationRangeFinal, tmpRotationFinal );
end
numPartRotateInitial = length(partRotationRangeInitial);
numPartRotateFinal = length(partRotationRangeFinal);
minRotationDifInitial = 1e-10;
minRotationDifFinal = (sin(1*pi/numOrient)-sin(0))^2 + (cos(1*pi/numOrient)-cos(0))^2 + 1e-10;
PartLocX0 = 1:partSize:templateSize(1)-partSize+1;
PartLocY0 = 1:partSize:templateSize(2)-partSize+1;
outputT = zeros(sizeTemplatex, sizeTemplatey,3) + 255;%output template
numCandPart = length(PartLocX0) * length(PartLocY0);
PartLocX = zeros(numCandPart,1);
PartLocY = zeros(numCandPart,1);
iPart = 1;
for x = PartLocX0
    for y = PartLocY0
        PartLocX(iPart) = x;
        PartLocY(iPart) = y;
        outputT(x, :, 1) = 50;
        outputT(x, :, 2) = 50;
        outputT(x, :, 3) = 50;
        outputT(:, y, 1) = 50;
        outputT(:, y, 2) = 50;
        outputT(:, y, 3) = 50;
        iPart = iPart + 1;
    end
end
outputT(sizeTemplatex, :, 1) = 50;
outputT(sizeTemplatex, :, 2) = 50;
outputT(sizeTemplatex, :, 3) = 50;
outputT(:, sizeTemplatey, 1) = 50;
outputT(:, sizeTemplatex, 2) = 50;
outputT(:, sizeTemplatey, 3) = 50;

partGainThreshold = 20;%the selection threshold of partial templates to compose into an Active Plate 

%% compute affinity matrix
allTemplateAffinityMatrixInitial = cell(numPartRotateInitial*numOfCluster, numCandPart);
for cc = 1:numOfCluster
    templateAffinityMatrix = cell(numPartRotateInitial,numCandPart);
    for iPart = 1:numCandPart
        for r1 = 1:length(partRotationRangeInitial)
            angle1 = pi/numOrient * partRotationRangeInitial(r1);
            templateAffinityMatrix{r1,iPart} = [];
            jPart = iPart;
            for r2 = 1:length(partRotationRangeInitial)
                angle2 = pi/numOrient*partRotationRangeInitial(r2);
                if (sin(angle1) - sin(angle2))^2 + (cos(angle1)-cos(angle2))^2 <= minRotationDifInitial
                    templateAffinityMatrix{r1,iPart} = int32( [templateAffinityMatrix{r1,iPart} r2-1] );
                end
            end
        end
    end
    for iPart = 1:numCandPart
        startInd = (cc-1)*numPartRotateInitial + (iPart-1)*numPartRotateInitial*numOfCluster;
        rowId = (cc-1)*numPartRotateInitial;
        for r2 = 1:length(partRotationRangeInitial)
            allTemplateAffinityMatrixInitial{rowId+r2, iPart} = templateAffinityMatrix{r2, iPart}(:)+startInd;
        end
    end
end

allTemplateAffinityMatrixFinal = cell(numPartRotateFinal*numOfCluster, numCandPart);
for cc = 1:numOfCluster
    templateAffinityMatrix = cell(numPartRotateFinal,numCandPart);
    for iPart = 1:numCandPart
        for r1 = 1:length(partRotationRangeFinal)
            angle1 = pi/numOrient * partRotationRangeFinal(r1);
            templateAffinityMatrix{r1,iPart} = [];
            jPart = iPart;
            for r2 = 1:length(partRotationRangeFinal)
                angle2 = pi/numOrient*partRotationRangeFinal(r2);
                if (sin(angle1) - sin(angle2))^2 + (cos(angle1)-cos(angle2))^2 <= minRotationDifFinal
                    templateAffinityMatrix{r1,iPart} = int32( [templateAffinityMatrix{r1,iPart} r2-1] );
                end
            end
        end
    end
    for iPart = 1:numCandPart
        startInd = (cc-1)*numPartRotateFinal + (iPart-1)*numPartRotateFinal*numOfCluster;
        rowId = (cc-1)*numPartRotateFinal;
        for r2 = 1:length(partRotationRangeFinal)
            allTemplateAffinityMatrixFinal{rowId+r2, iPart} = templateAffinityMatrix{r2, iPart}(:)+startInd;
        end
    end
end

%% compute part rotation affinity at the beginning several iterations
denseX = -floor(partSize/2) + (1:partSize);
denseY = denseX;
count = 0;
inRow = zeros(length(denseX)*length(denseY),1,'single');
inCol = zeros(length(denseX)*length(denseY),1,'single');
for y = denseY
    for x = denseX
        count = count+1;
        inRow(count) = x;
        inCol(count) = y;
    end
end
partOutRowInitial = cell(numPartRotateInitial,1);
partOutColInitial = cell(numPartRotateInitial,1);
for nRot = 1:numPartRotateInitial
   
    [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                partRotationRangeInitial(nRot),inRow,inCol,inO,inS,numOrient);
    
    partOutRowInitial{nRot} = outRow;
    partOutColInitial{nRot} = outCol;
    
end

%% compute part rotation affinity at later iterations
partOutRowFinal = cell(numPartRotateFinal, 1);
partOutColFinal = cell(numPartRotateFinal, 1);
for nRot = 1:numPartRotateFinal
   
    [outRow, outCol] = ...
            mexc_TemplateAffineTransform(tScale,rScale,cScale,...
                partRotationRangeFinal(nRot),inRow,inCol,inO,inS,numOrient);
    
    partOutRowFinal{nRot} = outRow;
    partOutColFinal{nRot} = outCol;
    
end

%% zip filename
zipfilename = [imageFolder '.zip'];



