%% showing sketches for images
showMatchedTemplate = true;
showPartBoundingBox = true;
showObjectBoundingBox = true;
doCropBackImage = true;
load( sprintf('working/SUM1map_image_%d.mat',img),'J' );%load image
sizeIx = size(J{ceil(numImgResolution/2)},1);%size of sketched image 
sizeIy = size(J{ceil(numImgResolution/2)},2);
sketchI = single(ones(sizeIx, sizeIy, 3));
imageName = ['image' num2str(img)];

partI = cell(1, length(numOfPatch));
for iMember = 1:numOfPatch
    
    templateTherex = tmpActivations(1,iMember);
    templateTherey = tmpActivations(2,iMember);
    templateClusterID = ceil( ( tmpActivations(4,iMember)) / nTransform );
    templateBestRot =  tmpActivations(4,iMember)-(templateClusterID-1)*nTransform;
    templateBestRes = tmpActivations(3,iMember);
    newI = ones(size(J{templateBestRes},1), size(J{templateBestRes},2), 3);
    tmpX = single((1:size(newI,1))');
    xI = cell(1,1);
    xI{1} = repmat(tmpX, 1, size(newI,2));
    tmpY = single((1:size(newI,2)));
    yI = cell(1,1);
    yI{1} = repmat(tmpY, size(newI,1), 1);
    
    K = mexc_CropInstance(J(templateBestRes),...
                templateTherex-1,...
                templateTherey-1,...
                rotationRange(templateBestRot),tScale,1,...
                templateOutRow{templateBestRot},templateOutCol{templateBestRot},...
                1,1,templateSize(1),templateSize(2));
                
    indX = mexc_CropInstance(xI(1),...
                templateTherex-1,...
                templateTherey-1,...
                rotationRange(templateBestRot),tScale,1,...
                templateOutRow{templateBestRot},templateOutCol{templateBestRot},...
                1,1,templateSize(1),templateSize(2));

    indY = mexc_CropInstance(yI(1),...
                templateTherex-1,...
                templateTherey-1,...
                rotationRange(templateBestRot),tScale,1,...
                templateOutRow{templateBestRot},templateOutCol{templateBestRot},...
                1,1,templateSize(1),templateSize(2));
            
    drawTemplate;
            
end

reconstructI = uint8( 255 * (sketchI-min(sketchI(:)))/(max(sketchI(:))-min(sketchI(:))) );
imwrite( reconstructI, [sketchDir '\' sprintf('sketchedI_%s.png',imageName)] );
