#if !defined(FEATURE_EXTRACT_H_H)
#define  FEATURE_EXTRACT_H_H
#include <stdio.h>
#include <stdlib.h>

#include <math.h>

#include "type-def.h"
#include "util.h"
#include "imageio.h"
#include "functions.h"
#include "region_extract.h"

#if defined(FEATURE_EXTRACT_SOURCE_C_C)
#if !defined(NOT_CALC_VALUE_DEFAULT)
#define NOT_CALC_VALUE_DEFAULT          10.
#endif
#define SMOOTH_HIST_SCALE               20
#define SMOOTH_HIST_UNIT                0.025

#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif


EXTERN_FLAG void Homogeous_Between_Test_Before(FILTERBANK *ffamily,
					       IMAGEINT *animage);
EXTERN_FLAG void Homogeous_Layer_Test_Before(FILTERBANK *ffamily,
					     IMAGEINT *animage,
					     CONTROL_INFO *controlInfo,
					     IMAGE_DATABASE *adatabase);
EXTERN_FLAG void Homogeous_Layer_Test_Before_Image(FILTERBANK *ffamily,
						   IMAGEINT *animage,
						   CONTROL_INFO *controlInfo,
						   IMAGE_DATABASE *adatabase);

EXTERN_FLAG void Homogeous_Layer_Test_Before_Db(FILTERBANK *ffamily,
						CONTROL_INFO *controlInfo,
						IMAGE_DATABASE *adatabase);
EXTERN_FLAG void Homogeous_Layer_Test_Before_Var(FILTERBANK *ffamily,
						 CONTROL_INFO *controlInfo,
						 IMAGE_DATABASE *adatabase);

EXTERN_FLAG void Homogeous_Layer_Test_Before_Cross(FILTERBANK *ffamily,
						   CONTROL_INFO *controlInfo,
						   IMAGE_DATABASE *adatabase);

EXTERN_FLAG  void Homogeous_Between_Test_After(int windex,
					       FILTERBANK *ffamily,
					       IMAGEINT *animage,
					       IMAGEVECTOR *featureImg);
EXTERN_FLAG  void Print_Pixel_Feature_Vector(int row, int col, 
					     float *hist,
					     FILTERBANK *ffamily,
					     int windex);
EXTERN_FLAG  void Calc_Between_Layer_Div(int windex,
				    int upindex,
				    FILTERBANK *ffamily,
				    IMAGEINT *animage,
				    IMAGEFLOAT *layerDiv);
EXTERN_FLAG  void Check_Connection_After(int windex,
					 FILTERBANK *ffamily,
					 IMAGEINT *animage,
					 IMAGEVECTOR *featureImg);
EXTERN_FLAG  void Estimate_Region_Parameter(int row, int col, 
					    int segWin,
					    FILTERBANK *ffamily,
					    IMAGEINT *animage,
					    REGION_LABEL *alabel);
EXTERN_FLAG  int Find_Refine_Window(int row, int col,
				    FILTERBANK *ffamily,
				    IMAGEINT *animage,
				    int segWin,
				    float segthresh);

EXTERN_FLAG void Remove_Not_Calc_Points(REGION_LABEL *alabel);

EXTERN_FLAG int Find_Region_Seed_Pixels(IMAGEINT *animage,
					FILTERBANK *ffamily,
					CONTROL_INFO *controlInfo);
/*

EXTERN_FLAG  ;
*/
#undef  EXTERN_FLAG
#endif









