#if !defined(FILTER_UTIL_H_H)
#define FILTER_UTIL_H_H
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"

#if defined(FILTER_UTIL_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG void Update_Patch(FILTERBANK *ffamily, IMAGEINT *syn, 
			      int row, int col);
EXTERN_FLAG void Update_Map(FILTERBANK *ffamily, int row, int col, 
			    int val);
EXTERN_FLAG void  Calc_Energy(FILTERBANK *ffamily, int row, int col, 
			      float *energy);
EXTERN_FLAG void  Calc_Energy_With_Patch_Hist(FILTERBANK *ffamily, 
					      int row, int col, 
					      double *energy,
					      IMAGEFLOAT *patch_hist);

EXTERN_FLAG void Flip(IMAGEINT *syn, FILTERBANK *ffamily,
		      CONTROL_INFO *controlInfo);
EXTERN_FLAG void Flip_With_T(IMAGEINT *syn, FILTERBANK *ffamily,
			     CONTROL_INFO *controlInfo);

EXTERN_FLAG void Flip_With_T_Hole(IMAGEINT *syn, FILTERBANK *ffamily,
				   CONTROL_INFO *controlInfo,
				   ONE_HOLE *synpatch);
				  
#undef  EXTERN_FLAG
#endif
