#if !defined(FUNCTIONS_H_H)
#define FUNCTIONS_H_H
#include <stdio.h>
#include <stdlib.h>

#include <math.h>

#include "type-def.h"
#include "util.h"

#if defined(FUNCTIONS_SOURCE_C_C)
extern POINT2D Neighbor_Table[];
#define GAUSSIAN_SMOOTH_SCALE           5
#if !defined(DELTA)
# define DELTA 1e-9
#endif

#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif


EXTERN_FLAG  
void Smoothing_Hist(float *hist_In, int hist_len, 
		    int iteration);
EXTERN_FLAG  
float Calc_Hist_Divergence(float *H1, float *H2, 
			   int hist_len);
EXTERN_FLAG
float Calc_Hist_Dist_L1(float *H1, float *H2, int hist_len);
EXTERN_FLAG  
float Calc_Hist_Divergence_AFilter(float *H1, float *H2, 
				   int filter_no,
				   FILTERBANK *ffamily);

EXTERN_FLAG  
float Calc_Hist_Chi(float *H1, float *H2, int hist_len);
EXTERN_FLAG  
float Calc_Hist_Chi_AFilter(float *H1, float *H2, 
			    int filter_no,
			    FILTERBANK *ffamily);
EXTERN_FLAG 
void Compute_Local_Window_Hist(int row, int col, int windex,
			       FILTERBANK *ffamily,
			       IMAGEINT *animage,
			       float *histVec) ;
EXTERN_FLAG 
void Compute_Local_Window_Hist_Inside(int row, int col, 
				      int windex,
				      FILTERBANK *ffamily,
				      IMAGEINT *animage,
				      float *histVec);
EXTERN_FLAG  
void Compute_Local_Hist(int row, int col,
			FILTERBANK *ffamily,
			IMAGEINT *animage,
			float **histImage);
EXTERN_FLAG  
void Compute_Image_Level_Hist(int windex,
			      FILTERBANK *ffamily,
			      IMAGEINT *animage,
			      IMAGEVECTOR *featureImg);
EXTERN_FLAG 
int Find_Neighbor_Same_Pixels(int row, int col,
			      int trylabel,
			      IMAGEINT *animage,
			      int wsize);
EXTERN_FLAG 
int Calc_Average_Feature_Vector(FILTERBANK *ffamily,
				CONTROL_INFO *controlInfo,
				IMAGEINT *animage,
				ARRAY fvector);

/*

EXTERN_FLAG  ;
*/
#undef  EXTERN_FLAG
#endif
