#if !defined(JULESZ_UTIL_H_H)
#define JULESZ_UTIL_H_H
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"

#if defined(JULESZ_UTIL_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG 
void Flip_Julesz_Test(IMAGEINT *syn, FILTERBANK *ffamily,
		 CONTROL_INFO *controlInfo);
EXTERN_FLAG 
void Calc_Julesz_Temp_BasedOn_Entropy(IMAGEINT *syn, 
				      FILTERBANK *ffamily,
				      CONTROL_INFO *controlInfo);
EXTERN_FLAG 
int Flip_Julesz(IMAGEINT *syn, FILTERBANK *ffamily,
		CONTROL_INFO *controlInfo,
		float *average_entropy);

EXTERN_FLAG 
void Update_Patch_Julesz(int row, int col,
			 IMAGEINT *syn, FILTERBANK *ffamily);

EXTERN_FLAG 
void Compute_Patch_Histogram_Julesz(FILTERBANK *ffamily);

EXTERN_FLAG 
void Update_Map_Julesz(int row, int col, int val,
		       FILTERBANK *ffamily);

EXTERN_FLAG 
void Update_Histogram_Julesz(int val, FILTERBANK *ffamily);

EXTERN_FLAG 
void  Calc_Energy_Julesz(int row, int col, float *energy,
			 IMAGEINT *syn,
			 FILTERBANK *ffamily,
			 float energyPow);

#undef  EXTERN_FLAG
#endif




