#if !defined(KERNEL_H_H)
#define KERNEL_H_H
#include <stdio.h>
#include <math.h>
#include <float.h>
#include <string.h>
#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"
#include "special_bessel.h"
#if defined(KERNEL_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG void Read_Kernel(FILTER *filter, char *name, int layer_no);
EXTERN_FLAG MAT  Create_Kernel(int height, int  width);
EXTERN_FLAG void Free_Filter(FILTER *filter, FILTERBANK *ffamily);
EXTERN_FLAG void Normalize_Kernel(FILTER *filter);
EXTERN_FLAG int Read_Filters(char *name, FILTERBANK *ffamily);
EXTERN_FLAG int Read_Lambdas(char *name, FILTERBANK *ffamily);
EXTERN_FLAG void Scale_Lambdas(FILTERBANK *ffamily, float divid_factor);
EXTERN_FLAG int Read_Lambdas_Into_Vector(char *name, FILTERBANK *ffamily, 
					 ARRAY lambda_vec);
EXTERN_FLAG int Read_Multi_Lambdas_Into_Image(char *name, FILTERBANK *ffamily, 
					      IMAGEFLOAT *lambda_img,
					      int  num_lambda);

EXTERN_FLAG int Save_Lambdas_Into_Vector(FILTERBANK *ffamily, 
					 ARRAY lambda_vec);

EXTERN_FLAG 
void Free_Filter_Bank(FILTERBANK *ffamily);
EXTERN_FLAG 
int Read_Filter_Marks(char *name, FILTERBANK *ffamily);
EXTERN_FLAG 
int Save_Filter_Marks(char *name, FILTERBANK *ffamily);
EXTERN_FLAG 
int Generate_Marks_From_Image(FILTERBANK *ffamily, 
			      IMAGEINT *animage,
			      CONTROL_INFO *controlInfo);
EXTERN_FLAG 
int Generate_Target_Hist_From_Image(FILTERBANK *ffamily, 
				    IMAGEINT *animage);
EXTERN_FLAG
int Generate_Target_Hist_From_Image_Analytical(FILTERBANK *ffamily, 
					       IMAGEINT *animage,
					       CONTROL_INFO *controlInfo);
EXTERN_FLAG
int Generate_Target_Hist_From_Image_Analytical_All(FILTERBANK *ffamily, 
						   IMAGEINT *animage,
						   CONTROL_INFO *controlInfo);
EXTERN_FLAG 
void Initial_Synthesize_Image(FILTERBANK *ffamily, 
			      IMAGEINT *animage,
			      IMAGEINT *holeimage);

EXTERN_FLAG 
int Generate_Target_Hist_From_Image_WithHoles(FILTERBANK *ffamily, 
					      IMAGEINT *animage,
					      IMAGEINT *holeimage);

EXTERN_FLAG 
int Scale_Target_Hist(FILTERBANK *ffamily, float norm);

EXTERN_FLAG 
int Generate_Hist_From_Map(FILTERBANK *ffamily);
EXTERN_FLAG 
int Generate_Hist_From_Map_Hole(FILTERBANK *ffamily,
				ONE_HOLE *thepatch);

EXTERN_FLAG 
void Initialize_Obs(FILTERBANK *ffamily, IMAGEINT *obs,
		    CONTROL_INFO *controlInfo,
		    IMAGE_DATABASE *adatabase);
EXTERN_FLAG 
void Initialize_Obs_Analytical(FILTERBANK *ffamily, IMAGEINT *obs,
			       CONTROL_INFO *controlInfo);
EXTERN_FLAG 
void Initialize_Obs_Satellite(FILTERBANK *ffamily, 
			      IMAGEINT *obs,
			      CONTROL_INFO *controlInfo,
			      IMAGE_DATABASE *adatabase);
EXTERN_FLAG void Initialize_Obs_Pseudo(FILTERBANK *ffamily, 
				       IMAGEINT *obs,
				       CONTROL_INFO *controlInfo,
				       IMAGE_DATABASE *adatabase);

EXTERN_FLAG void Initialize_Syn_Satellite(FILTERBANK *ffamily, IMAGEINT *syn,
					  CONTROL_INFO *controlInfo);

EXTERN_FLAG void Re_Initialize_Syn(FILTERBANK *ffamily, IMAGEINT *syn,
		    CONTROL_INFO *controlInfo);

EXTERN_FLAG void Initialize_Syn(FILTERBANK *ffamily, IMAGEINT *syn,
				CONTROL_INFO *controlInfo);

EXTERN_FLAG void Update_Syn_Filters(FILTERBANK *ffamily, IMAGEINT *syn);
EXTERN_FLAG void Convolution(IMAGEINT *animage, IMAGEFLOAT *mat, 
			     FILTER *filter);
EXTERN_FLAG void Skip_Comment_Empty(FILE *fp);

EXTERN_FLAG int Load_Database(char *fname, FILTERBANK *ffamily,
			      IMAGE_DATABASE *adatabase);
EXTERN_FLAG int Save_Database(char *fname, FILTERBANK *ffamily,
			      IMAGE_DATABASE *adatabase);
EXTERN_FLAG int Create_Database(CONTROL_INFO *controlInfo, 
				FILTERBANK *ffamily,
				IMAGE_DATABASE *adatabase);
EXTERN_FLAG void Free_Database(IMAGE_DATABASE *adatabase);

#undef  EXTERN_FLAG
#endif


