#define REGION_EXTRACT_SOURCE_C_C

#include "region_extract.h"
int Check_Labeled_Value(int row, int col,
			REGION_LABEL *regLabels,
			IMAGEINT *labelim,
			int new_label)
{
  if (labelim->data[row][col] == 0) return 1;
  if (labelim->data[row][col] == SMALL_REGION_TEMP_LABEL) return 0;
  /* if (labelim->data[row][col] == new_label) return 0; */
  if ( regLabels[labelim->data[row][col]].resImg.data[row][col] <
       regLabels[new_label].resImg.data[row][col])
    return 0;
  return 1;
  
}

void  ScanLineGrowing(int crow, int ccol,
		      REGION_LABEL *regLabels,
		      IMAGEINT *labelim,
		      float gThresh,
		      int new_label,
		      int *regSize)
{
  int i,j;
  int left, right;
  int nowrow;
  
  /* Check condition */
  if (crow <0 || crow >= labelim->nrow) return;
  if (ccol <0 || ccol >= labelim->ncol) return;
  if (labelim->data[crow][ccol] == new_label) return;

  if ( Check_Labeled_Value(crow, ccol, regLabels, 
			   labelim, new_label) == 0) return;
  
  left = ccol-1;
  while (left>=0 ) {
    if ( regLabels[new_label].resImg.data[crow][left] > gThresh) break;
    if ( Check_Labeled_Value(crow, left, regLabels, 
			     labelim, new_label) == 0)
      break;
    left--;
  }

  right = ccol+1;
  while (right < labelim->ncol) {
    if ( regLabels[new_label].resImg.data[crow][right] > gThresh) break;
    if ( Check_Labeled_Value(crow, right, regLabels, 
			     labelim, new_label) == 0)
      break;
    right++;
  }
  
  /* Adjust */
  left++; right--;
  
  /* Relabeling current line */
  for (i=left; i<=right; i++) {
    labelim->data[crow][i] = new_label;
    (*regSize)++;
  }
  /* Check a line up and down*/
  for (nowrow = crow-1; nowrow <= crow+1; nowrow+=2 ) {
    if (nowrow >=0 && nowrow < labelim->nrow ) {
      for (i=left; i<=right; i++) {
	for (j=(i-1); j<= (i+1); j++) {
	  if (j>=0 && j < labelim->ncol) {
	    if ( regLabels[new_label].resImg.data[nowrow][j] <= gThresh &&
		 Check_Labeled_Value(nowrow, j, 
				     regLabels, 
				     labelim, new_label) ) {
	      ScanLineGrowing(nowrow, j,
			      regLabels, labelim,
			      gThresh,
			      new_label,
			      regSize);
	    }
	  }
	}
      }
    }
  }
  return;
}


void  ReLabel_Region(int crow, int ccol,
		     int old_label,
		     int new_label,
		     IMAGEINT *labelim,
		     int *regSize)
{
  int i,j;
  int left, right;
  int nowrow;
  
  /* Check condition */
  if (crow <0 || crow >= labelim->nrow) return;
  if (ccol <0 || ccol >= labelim->ncol) return;
  
  if (old_label == new_label) {
    mexPrintf("Old and new labels are the same.\n");
    return;
  }
  
  if ( labelim->data[crow][ccol] != old_label) return;
  if ( labelim->data[crow][ccol] == new_label) return;
  
  
  left = ccol-1;
  while (left>=0 ) {
    if ( labelim->data[crow][left] != old_label)
      break;
    left--;
  }

  right = ccol+1;
  while (right < labelim->ncol) {
    if ( labelim->data[crow][right] != old_label)
      break;
    right++;
  }
  
  /* Adjust */
  left++; right--;
  
  /* Relabeling current line */
  for (i=left; i<=right; i++) {
    labelim->data[crow][i] = new_label;
    (*regSize)++;
  }
  /* Check a line up and down*/
  for (nowrow = crow-1; nowrow <= crow+1; nowrow+=2 ) {
    if (nowrow >=0 && nowrow < labelim->nrow ) {
      for (i=left; i<=right; i++) {
	for (j=(i-1); j<= (i+1); j++) {
	  if (j>=0 && j < labelim->ncol) {
	    if ( labelim->data[nowrow][j] == old_label) {
	      ReLabel_Region(nowrow, j,
			     old_label,
			     new_label,
			     labelim,
			     regSize);
	    }
	  }
	}
      }
    }
  }
  return;
}


int Extract_OneRegion(REGION_LABEL *regLabels,
		      IMAGEINT *labelim,
		      float gThresh,
		      int new_label,
		      int regThres)
{
  int i,j, k1, k2;
  int regSize;
  POINT2D *smallReg;
  int max_point;
  int npoint;
  int nRegion = 0;
  IMAGEINT tmpImg;

  tmpImg.nrow = 0;
  Create_An_Image_Int(labelim->nrow, labelim->ncol, &tmpImg);
  /* Save the existing labels */
  
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      tmpImg.data[i][j] = labelim->data[i][j];
    }
  }
  
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      if (regLabels[new_label].resImg.data[i][j] > gThresh) continue;
      if (labelim->data[i][j] == SMALL_REGION_TEMP_LABEL) continue;
      if (labelim->data[i][j] == new_label) continue;
      if (labelim->data[i][j] != 0) {
	if (regLabels[labelim->data[i][j]].resImg.data[i][j] <
	    regLabels[new_label].resImg.data[i][j]) continue;
      }
      
      regSize = 0;
      ScanLineGrowing(i, j,
		      regLabels,
		      labelim,
		      gThresh,
		      new_label,
		      &regSize);
      if (regSize < regThres) {
	printf("Reverting region at %d,%d with size %d for label %d\n",
	       j, i, regSize, new_label);
	regSize = 0;
	ReLabel_Region(i, j, new_label, 
		       (int)SMALL_REGION_TEMP_LABEL,
		       labelim,
		       &regSize);
      }
      else {
	nRegion++;
      }
    }
  }
  
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      if (labelim->data[i][j] == SMALL_REGION_TEMP_LABEL) 
	labelim->data[i][j] =  tmpImg.data[i][j];
    }
  }
  
  Free_Image_Int(&tmpImg);
  return nRegion;
}


int Remove_Small_Holes(REGION_LABEL *regLabels,
		       IMAGEINT *labelim)
{
  int i,j;
  int thelabel;
  int nRegion = 0;
  IMAGEINT tmpImg;
  int  regSize;
  char fname[256];
  
  tmpImg.nrow = 0;
  Create_An_Image_Int(labelim->nrow, labelim->ncol, &tmpImg);
  /* Save the existing labels */
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      tmpImg.data[i][j] = labelim->data[i][j];
    }
  }
  
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      if (labelim->data[i][j] == 0) continue;
      if (labelim->data[i][j] == BIG_REGION_TEMP_LABEL) continue;
      if (labelim->data[i][j] == HOLE_REGION_TEMP_LABEL) {
	printf("Error: there should be pixel with value %d\n",
	       HOLE_REGION_TEMP_LABEL);
	continue;
      }
      regSize = 0;
      thelabel = labelim->data[i][j];
      ReLabel_Region(i, j, thelabel, 
		     (int)HOLE_REGION_TEMP_LABEL,
		     labelim,
		     &regSize);

      if ((float)regSize <  regLabels[thelabel].regThres) {
	nRegion++;
	printf("Hole with size %d of label %d is removed.\n",
	       regSize, thelabel);
	regSize = 0;
	
	ReLabel_Region(i, j, (int)HOLE_REGION_TEMP_LABEL,
		       (int)0,
		       labelim,
		       &regSize);
	
      }
      else {
	regSize = 0;
	ReLabel_Region(i, j, (int)HOLE_REGION_TEMP_LABEL,
		       (int)BIG_REGION_TEMP_LABEL,
		       labelim,
		       &regSize);
      }
      
    }
  }
  
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      if (labelim->data[i][j] !=0) 
	labelim->data[i][j] = tmpImg.data[i][j];
    }
  }
  
  Free_Image_Int(&tmpImg); 
  
  return nRegion;
}

float  Check_Calc(int row, int col, REGION_LABEL *regLabels,
		  int trylabel,
		  IMAGEINT *labelim,
		  IMAGEINT *animage,
		  FILTERBANK *ffamily,
		  float *classThreshold)
{
  float tmp =0.0;
  int  i,j, k;
  POINT2D  pCenters[4];
  int  labelNum[4];
  float bestDist;
  float *tmpHist;
  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;
  
  for (k=0; k<4; k++) {
    labelNum[k] = 0;
    if ( pCenters[k].y < regLabels[trylabel].segWsize  ||
	 (pCenters[k].y+regLabels[trylabel].segWsize) >= 
	 labelim->nrow ||
	 pCenters[k].x < regLabels[trylabel].segWsize ||
	 (pCenters[k].x+regLabels[trylabel].segWsize) >=
	 labelim->ncol ) {
      mexPrintf("%d Constructed window %d, %d at %d,%d with size %d ",
	     k, pCenters[k].x, pCenters[k].y, col, row,
	     regLabels[trylabel].segWsize);
      mexPrintf("out of bound.\n");
      continue;
    }
    for (i=0-regLabels[trylabel].segWsize; 
	 i <= regLabels[trylabel].segWsize; i++) {
      for (j=0-regLabels[trylabel].segWsize;
	   j <= regLabels[trylabel].segWsize; j++) {
	labelNum[k] += 
	  (labelim->data[i+pCenters[k].y][j+pCenters[k].x] == trylabel);
      }
    }
  }
  
  i = 0;
  tmpHist = Create_Array(ffamily->totalBin);
  bestDist = NOT_CALC_VALUE_DEFAULT;
  for (k=0; k<4; k++) {
    if (regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]
	> NOT_CALC_VALUE_DEFAULT) {
      Compute_Local_Window_Hist_Inside(pCenters[k].y, pCenters[k].x,
				       regLabels[trylabel].segWin,
				       ffamily,
				       animage,
				       tmpHist);
      regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x] =
	Calc_Hist_Divergence(tmpHist,
			     regLabels[trylabel].fvector,
			     ffamily->totalBin);
      
    }
    tmp = regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]/
      (0.1+(float)labelNum[k]);
    if (bestDist > tmp) {
      bestDist = tmp;
      i = k;
    }
  }
  Free_Array(tmpHist);
  /* Figure out the prob model */
  *classThreshold = 
    regLabels[trylabel].resImg.data[pCenters[i].y][pCenters[i].x];
  
  k = (int)(regLabels[trylabel].resImg.data[pCenters[i].y][pCenters[i].x]/
	    regLabels[trylabel].histUnit);
  if (k <0) k = 0;
  if (k >= regLabels[trylabel].histLen) {
    tmp = 0.0;
  }
  else {
    tmp = regLabels[trylabel].probHist[k];
  }
  return tmp;
}


float  Check_Calc_Threshold(int row, int col, REGION_LABEL *regLabels,
			    int trylabel,
			    IMAGEINT *labelim,
			    IMAGEINT *animage,
			    FILTERBANK *ffamily)
{
  float tmp =0.0;
  int  i,j, k;
  POINT2D  pCenters[4];
  int  labelNum[4];
  float bestDist;
  float *tmpHist;
  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;
  
  for (k=0; k<4; k++) {
    labelNum[k] = 0;
    if ( pCenters[k].y < regLabels[trylabel].segWsize  ||
	 (pCenters[k].y+regLabels[trylabel].segWsize) >= 
	 labelim->nrow ||
	 pCenters[k].x < regLabels[trylabel].segWsize ||
	 (pCenters[k].x+regLabels[trylabel].segWsize) >=
	 labelim->ncol ) {
      mexPrintf("%d Constructed window %d, %d at %d,%d with size %d ",
	     k, pCenters[k].x, pCenters[k].y, col, row,
	     regLabels[trylabel].segWsize);
      mexPrintf("out of bound.\n");
      continue;
    }
    for (i=0-regLabels[trylabel].segWsize; 
	 i <= regLabels[trylabel].segWsize; i++) {
      for (j=0-regLabels[trylabel].segWsize;
	   j <= regLabels[trylabel].segWsize; j++) {
	labelNum[k] += 
	  (labelim->data[i+pCenters[k].y][j+pCenters[k].x] == trylabel);
      }
    }
  }
  
  i = 0;
  tmpHist = Create_Array(ffamily->totalBin);
  bestDist = NOT_CALC_VALUE_DEFAULT;
  for (k=0; k<4; k++) {
    if (regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]
	> NOT_CALC_VALUE_DEFAULT) {
      Compute_Local_Window_Hist_Inside(pCenters[k].y, pCenters[k].x,
				       regLabels[trylabel].segWin,
				       ffamily,
				       animage,
				       tmpHist);
      regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x] =
	Calc_Hist_Divergence(tmpHist,
			     regLabels[trylabel].fvector,
			     ffamily->totalBin);
      
    }
    tmp = regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]/
      (0.1+(float)labelNum[k]);
    if (bestDist > tmp) {
      bestDist = tmp;
      i = k;
    }
  }
  Free_Array(tmpHist);
  tmp = regLabels[trylabel].resImg.data[pCenters[i].y][pCenters[i].x];
  return tmp;
}




float  Check_Calc_Threshold_Cross(int row, int col, 
				  REGION_LABEL *regLabels,
				  int trylabel,
				  int crosslabel,
				  IMAGEINT *labelim,
				  IMAGEINT *animage,
				  FILTERBANK *ffamily)
{
  float tmp =0.0;
  int  i,j, k;
  POINT2D  pCenters[4];
  int  labelNum[4];
  float bestDist;
  float *tmpHist;
  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;
  
  for (k=0; k<4; k++) {
    labelNum[k] = 0;
    if ( pCenters[k].y < regLabels[trylabel].segWsize  ||
	 (pCenters[k].y+regLabels[trylabel].segWsize) >= 
	 labelim->nrow ||
	 pCenters[k].x < regLabels[trylabel].segWsize ||
	 (pCenters[k].x+regLabels[trylabel].segWsize) >=
	 labelim->ncol ) {
      mexPrintf("%d Constructed window %d, %d at %d,%d with size %d ",
	     k, pCenters[k].x, pCenters[k].y, col, row,
	     regLabels[trylabel].segWsize);
      mexPrintf("out of bound.\n");
      continue;
    }
    for (i=0-regLabels[trylabel].segWsize; 
	 i <= regLabels[trylabel].segWsize; i++) {
      for (j=0-regLabels[trylabel].segWsize;
	   j <= regLabels[trylabel].segWsize; j++) {
	labelNum[k] += 
	  (labelim->data[i+pCenters[k].y][j+pCenters[k].x] == trylabel);
      }
    }
  }
  
  i = 0;
  tmpHist = Create_Array(ffamily->totalBin);
  bestDist = NOT_CALC_VALUE_DEFAULT;
  for (k=0; k<4; k++) {
    if (regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]
	> NOT_CALC_VALUE_DEFAULT) {
      Compute_Local_Window_Hist_Inside(pCenters[k].y, pCenters[k].x,
				       regLabels[trylabel].segWin,
				       ffamily,
				       animage,
				       tmpHist);
      regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x] =
	Calc_Hist_Divergence(tmpHist,
			     regLabels[trylabel].fvector,
			     ffamily->totalBin);
      
    }
    tmp = regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]/
      (0.1+(float)labelNum[k]);
    if (bestDist > tmp) {
      bestDist = tmp;
      i = k;
    }
  }
  
  Compute_Local_Window_Hist_Inside(pCenters[i].y, pCenters[i].x,
				   regLabels[trylabel].segWin,
				   ffamily,
				   animage,
				   tmpHist);
  tmp = Calc_Hist_Divergence(tmpHist,
			     regLabels[crosslabel].fvector,
			     ffamily->totalBin);
  
  Free_Array(tmpHist);
  return tmp;
}


float  Check_Calc_Threshold_Cross_Orient(int row, int col, 
					 REGION_LABEL *regLabels,
					 int trylabel,
					 int crosslabel,
					 int local_orient,
					 IMAGEINT *labelim,
					 IMAGEINT *animage,
					 FILTERBANK *ffamily)
{
  float tmp =0.0;
  int  i,j, k;
  POINT2D  pCenters[4];
  int  labelNum[4];
  float bestDist;
  float *tmpHist;
  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;
  
  for (k=0; k<4; k++) {
    labelNum[k] = 0;
    if ( pCenters[k].y < regLabels[trylabel].segWsize  ||
	 (pCenters[k].y+regLabels[trylabel].segWsize) >= 
	 labelim->nrow ||
	 pCenters[k].x < regLabels[trylabel].segWsize ||
	 (pCenters[k].x+regLabels[trylabel].segWsize) >=
	 labelim->ncol ) {
      mexPrintf("%d Constructed window %d, %d at %d,%d with size %d ",
	     k, pCenters[k].x, pCenters[k].y, col, row,
	     regLabels[trylabel].segWsize);
      mexPrintf("out of bound.\n");
      continue;
    }
    for (i=0-regLabels[trylabel].segWsize; 
	 i <= regLabels[trylabel].segWsize; i++) {
      for (j=0-regLabels[trylabel].segWsize;
	   j <= regLabels[trylabel].segWsize; j++) {
	labelNum[k] += 
	  (labelim->data[i+pCenters[k].y][j+pCenters[k].x] == trylabel);
      }
    }
  }
  
  i = 0;
  tmpHist = Create_Array(ffamily->totalBin);
  bestDist = NOT_CALC_VALUE_DEFAULT;
  for (k=0; k<4; k++) {
    if (regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]
	> NOT_CALC_VALUE_DEFAULT) {
      Compute_Local_Window_Hist_Inside(pCenters[k].y, pCenters[k].x,
				       regLabels[trylabel].segWin,
				       ffamily,
				       animage,
				       tmpHist);
      regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x] =
	Calc_Hist_Divergence(tmpHist,
			     regLabels[trylabel].fvector,
			     ffamily->totalBin);
      
    }
    tmp = regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]/
      (0.1+(float)labelNum[k]);
    if (bestDist > tmp) {
      bestDist = tmp;
      i = k;
    }
  }
  
  k = (crosslabel-1)*CROSS_ORIENT_PER_PIXEL+local_orient;
  if (regLabels[trylabel].crossImg[k].data[row][col] 
      < NOT_VALID_CROSS_VAL/2.) {
    Compute_Local_Window_Hist_Inside(pCenters[i].y, pCenters[i].x,
				     regLabels[trylabel].segWin,
				     ffamily,
				     animage,
				     tmpHist);
    tmp = Calc_Hist_Divergence(tmpHist,
			       regLabels[crosslabel].fvector,
			       ffamily->totalBin);
    regLabels[trylabel].crossImg[k].data[row][col] = tmp;
  }
  else {
    tmp = regLabels[trylabel].crossImg[k].data[row][col];
  }
  Free_Array(tmpHist);
  return tmp;
}


float  Check_Calc_With_Window(int row, int col, 
			      REGION_LABEL *regLabels,
			      int trylabel,
			      IMAGEINT *labelim,
			      IMAGEINT *animage,
			      FILTERBANK *ffamily,
			      int       local_win,
			      float *classThreshold)
{
  float tmp =0.0;
  int  k;
  POINT2D  pCenters[4];
  float *tmpHist;
  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;
  
  tmpHist = Create_Array(ffamily->totalBin);
  
  /*  if (regLabels[trylabel].resImg.data[pCenters[local_win].y][pCenters[local_win].x]
      > NOT_CALC_VALUE_DEFAULT) {
  */
  Compute_Local_Window_Hist_Inside(pCenters[local_win].y, pCenters[local_win].x,
				   regLabels[trylabel].segWin,
				   ffamily,
				   animage,
				   tmpHist);
  regLabels[trylabel].resImg.data[pCenters[local_win].y][pCenters[local_win].x] =
    Calc_Hist_Divergence(tmpHist,
			 regLabels[trylabel].fvector,
			 ffamily->totalBin);
  
    /*}*/
  
  Free_Array(tmpHist);
  /* Figure out the prob model */
  *classThreshold = 
    regLabels[trylabel].resImg.data[pCenters[local_win].y][pCenters[local_win].x];
  
  k = (int)(regLabels[trylabel].resImg.data[pCenters[local_win].y][pCenters[local_win].x]/
	    regLabels[trylabel].histUnit);
  if (k <0) k = 0;
  if (k >= regLabels[trylabel].histLen) {
    tmp = 0.0;
  }
  else {
    tmp = regLabels[trylabel].probHist[k];
  }
  return tmp;
}

int Refine_Bound_Point(int row1, int col1,
		       int row2, int col2,
		       REGION_LABEL *regLabels,
		       IMAGEINT *labelim,
		       IMAGEINT *animage,
		       FILTERBANK *ffamily,
		       CONTROL_INFO *controlInfo)
{
  float tmp[4];
  int   label[2];
  float labelThreshold[4];
  int k;
  if (abs(row1-row2)>1 || abs(col1-col2) > 1) {
    mexPrintf("Error: %d, %d and %d %d should NOT be adjacent boundary points.\n",
	   col1, row1, col2, row2);
    return 0;
  }
  label[0] = labelim->data[row1][col1];
  label[1] = labelim->data[row2][col2];
  if (label[0] == label[1]) {
    mexPrintf("Labels at %d, %d and %d %d are same with value %d\n",
	   col1, row1, col2, row2, label[0]);
    return 0;
  }
  
 
  /* There are three different cases */
  if (label[0] !=0 && label[1] !=0) {
    
    tmp[0] = (1.0 - controlInfo->boundWeight) *
      Check_Calc_Threshold_Cross(row1, col1, regLabels, 
				 label[0],
				 label[1],
				 labelim,
				 animage, ffamily) +
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row1, col1,
					 label[0],
					 labelim, (int)1))/9.0;
    
    
    tmp[1] = (1.0 - controlInfo->boundWeight) *
      Check_Calc_Threshold_Cross(row2, col2, 
				 regLabels, 
				 label[1], 
				 label[0],
				 labelim,
				 animage, ffamily) + 
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row2, col2,
					 label[1],
					 labelim, (int)1))/9.0;
    
    if (tmp[0] > tmp[1]) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    else {
      labelim->data[row1][col1] = label[1];
      return 1;
    }
    return 0;
  }
  
  if (label[0] == 0) {
    tmp[0] = Check_Calc_Threshold(row1, col1, regLabels, label[1], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[1]].threshold * regLabels[label[1]].lammda)) {
      labelim->data[row1][col1] = label[1];
      return 1;
    }
    return 0;
  }
  
  if (label[1] == 0) {
    tmp[0] = Check_Calc_Threshold(row2, col2, regLabels, label[0], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[0]].threshold * regLabels[label[0]].lammda)) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    return 0;
  }  
  return 0;
  
}

int Refine_Bound_Point_Cross(int row1, int col1,
			     int row2, int col2,
			     int  local_orient,
			     REGION_LABEL *regLabels,
			     IMAGEINT *labelim,
			     IMAGEINT *animage,
			     FILTERBANK *ffamily,
			     CONTROL_INFO *controlInfo)
{
  float tmp[4];
  int   label[2];
  float labelThreshold[4];
  int k;
  if (abs(row1-row2)>1 || abs(col1-col2) > 1) {
    mexPrintf("Error: %d, %d and %d %d should NOT be adjacent boundary points.\n",
	   col1, row1, col2, row2);
    return 0;
  }
  label[0] = labelim->data[row1][col1];
  label[1] = labelim->data[row2][col2];
  if (label[0] == label[1]) {
    mexPrintf("Labels at %d, %d and %d %d are same with value %d\n",
	   col1, row1, col2, row2, label[0]);
    return 0;
  }
  
  /* There are three different cases */
  if (label[0] !=0 && label[1] !=0) {
    
    tmp[0] = (1.0 - controlInfo->boundWeight) *
      Check_Calc_Threshold_Cross_Orient(row1, col1, regLabels, 
					label[0],
					label[1],
					local_orient,
					labelim,
					animage, ffamily) +
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row1, col1,
					 label[0],
					 labelim, (int)1))/9.0;
    
    
    tmp[1] = (1.0 - controlInfo->boundWeight) *
      Check_Calc_Threshold_Cross_Orient(row1, col1, 
					regLabels, 
					label[1], 
					label[0],
					local_orient,
					labelim,
					animage, ffamily) + 
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row1, col1,
					 label[1],
					 labelim, (int)1))/9.0;
    
    if (tmp[0] > tmp[1]) {
      tmp[2] =  (1.0 - controlInfo->boundWeight) *
	Check_Calc_Threshold_Cross_Orient(row2, col2, regLabels, 
					  label[0],
					  label[1],
					  local_orient,
					  labelim,
					  animage, ffamily) +
	controlInfo->boundWeight * 
	( (float)Find_Neighbor_Same_Pixels(row2, col2,
					   label[0],
					   labelim, (int)1))/9.0;
      tmp[3] =  (1.0 - controlInfo->boundWeight) *
	Check_Calc_Threshold_Cross_Orient(row2, col2, 
					  regLabels, 
					  label[1], 
					  label[0],
					  local_orient,
					  labelim,
					  animage, ffamily) + 
	controlInfo->boundWeight * 
	( (float)Find_Neighbor_Same_Pixels(row2, col2,
					   label[1],
					   labelim, (int)1))/9.0;
      if (tmp[2] > tmp[3]) {
	labelim->data[row2][col2] = label[0];
	return 1;
      }  
    }
    
    return 0;
  }
  
  if (label[0] == 0) {
    tmp[0] = Check_Calc_Threshold(row1, col1, regLabels, label[1], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[1]].threshold * regLabels[label[1]].lammda)) {
      labelim->data[row1][col1] = label[1];
      return 1;
    }
    return 0;
  }
  
  if (label[1] == 0) {
    tmp[0] = Check_Calc_Threshold(row2, col2, regLabels, label[0], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[0]].threshold * regLabels[label[0]].lammda)) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    return 0;
  }  
  return 0;
  
}

int Refine_Bound_Point1(int row1, int col1,
			int row2, int col2,
			REGION_LABEL *regLabels,
			IMAGEINT *labelim,
			IMAGEINT *animage,
			FILTERBANK *ffamily,
			CONTROL_INFO *controlInfo)
{
  float tmp[4];
  int   label[2];
  float labelThreshold[4];
  int k;
  if (abs(row1-row2)>1 || abs(col1-col2) > 1) {
    mexPrintf("Error: %d, %d and %d %d should NOT be adjacent boundary points.\n",
	   col1, row1, col2, row2);
    return 0;
  }
  label[0] = labelim->data[row1][col1];
  label[1] = labelim->data[row2][col2];
  if (label[0] == label[1]) {
    mexPrintf("Labels at %d, %d and %d %d are same with value %d\n",
	   col1, row1, col2, row2, label[0]);
    return 0;
  }
  
 
  /* There are three different cases */
  if (label[0] !=0 && label[1] !=0) {
    
    for (k=0; k < 2; k++) {
      tmp[k] = (1.0 - controlInfo->boundWeight) *
	Check_Calc(row1, col1, regLabels, label[k], labelim,
		   animage, ffamily, &(labelThreshold[k])) +
	controlInfo->boundWeight * 
	( (float)Find_Neighbor_Same_Pixels(row1, col1,
					   label[k],
					   labelim, (int)1))/9.0;
      
      
      tmp[2+k] = (1.0 - controlInfo->boundWeight) *
	Check_Calc(row2, col2, regLabels, label[k], labelim,
		   animage, ffamily, &(labelThreshold[2+k])) + 
	controlInfo->boundWeight * 
	( (float)Find_Neighbor_Same_Pixels(row2, col2,
					   label[k],
					   labelim, (int)1))/9.0;
      
    }

    /* Check threshold first */
    if (labelThreshold[2] < regLabels[label[0]].threshold &&
	labelThreshold[3] >= regLabels[label[1]].threshold) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    
    if (labelThreshold[1] < regLabels[label[1]].threshold &&
	labelThreshold[0] >= regLabels[label[0]].threshold) {
      labelim->data[row1][col1] = label[1];
      return 1;
    } 
    
    if ( (tmp[0] < tmp[1]) && (tmp[3] < tmp[2]) ) {
      mexPrintf("\nCompeting condition at (%d,%d) with label %d ",
	     col1, row1, label[0]);
      mexPrintf("and (%d,%d) with label %d\n",col2, row2, label[1]);
      mexPrintf("\tValues: ");
      for (k=0; k < 4; k++)
	printf("%8.6f ", tmp[k]);
      mexPrintf("\n");
      if ( tmp[1] > tmp[2]) {
	labelim->data[row1][col1] = label[1];
	printf("Label %d won\n", label[1]);
	return 1;
      }
      labelim->data[row2][col2] = label[0];
      mexPrintf("Label %d won\n", label[0]);
      return 1;
    }
    if (tmp[0] < tmp[1]) {
      labelim->data[row1][col1] = label[1];
      return 1;
    }
    if (tmp[3] < tmp[2]) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    return 0;
  }

  if (label[0] == 0) {
    tmp[0] = Check_Calc_Threshold(row1, col1, regLabels, label[1], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[1]].threshold * regLabels[label[1]].lammda)) {
      labelim->data[row1][col1] = label[1];
      return 1;
    }
    return 0;
  }
  
  if (label[1] == 0) {
    tmp[0] = Check_Calc_Threshold(row2, col2, regLabels, label[0], labelim,
				  animage, ffamily);
    if (tmp[0] < 
	(regLabels[label[0]].threshold * regLabels[label[0]].lammda)) {
      labelim->data[row2][col2] = label[0];
      return 1;
    }
    return 0;
  }  
  return 0;
  
}


int Refine_Region_Boundary(REGION_LABEL *regLabels,
			   int tLabels,
			   IMAGEINT *labelim,
			   IMAGEINT *animage,
			   FILTERBANK *ffamily,
			   CONTROL_INFO *controlInfo)
{
  int i,j;
  int updatedPixel;
  IMAGEINT tmpImg;
  int iter;
  int crow, ccol, k;
  char fname[256], comm[256];
  int  changed;
  int i_start, j_start;
  int ij_grid;
  int odd_even_order;
  int start_i, start_j;
  int *startingFlag;
  int prevUpdated;
  tmpImg.nrow = 0;
  Create_An_Image_Int(labelim->nrow, labelim->ncol, &tmpImg);
  for (i=0; i < labelim->nrow; i++) {
    for (j=0; j < labelim->ncol; j++) {
      tmpImg.data[i][j] = 1;
    }
  }
  iter = 0;
  ij_grid = 2;
  prevUpdated = 1000;
  startingFlag = (int *)malloc(sizeof(int)*(ij_grid*ij_grid));
  odd_even_order =1;
  i = -1; j = -1;
  do {
    updatedPixel = 0;
    mexPrintf("Updating at iteration %d.\n", iter);
    if (controlInfo->interactive) {
      Check_Boundary_Rows(regLabels,
			  tLabels,
			  labelim,
			  animage,
			  ffamily,
			  controlInfo);
    }
    for (k=0; k<(ij_grid *ij_grid); k++)
      startingFlag[k] = 1;
    for (i_start =0; i_start < ij_grid; i_start++) {
      for (j_start=0; j_start < ij_grid; j_start++) {
	do {
	  k = rand()% (ij_grid*ij_grid);
	} while (startingFlag[k] == 0);
	startingFlag[k] = 0;
	start_i = k/ij_grid;
	start_j = k%ij_grid;
	/*printf("Starting index = %d starting point i= %d j=%d\n",
	       k, start_i, start_j);
	*/
	if (odd_even_order) { /* Decrease order */
	  start_i += (labelim->nrow/ij_grid)*ij_grid + ij_grid;
	  while (start_i >= labelim->nrow)
	    start_i -= ij_grid;
	  start_j += (labelim->ncol/ij_grid)*ij_grid + ij_grid;
	  while (start_j >= labelim->ncol)
	    start_j -= ij_grid;
	  mexPrintf("Decrease order: starting i=%d j=%d -> ",
		 start_i, start_j);
	  mexEvalString("drawnow;");
	  for (i=start_i; i >= 0; i -= ij_grid) {
	    if (prevUpdated > 20) {
	      mexPrintf("%d ", i);
	      mexEvalString("drawnow;");
	    }
	    for (j= start_j; j >= 0; j -= ij_grid) {
	      changed = 0;
	      for (k=0; k < CROSS_ORIENT_PER_PIXEL; k++) {
		crow = i + Neighbor_Table[k].y;
		ccol = j + Neighbor_Table[k].x;
		if (crow >=0 && crow < labelim->nrow &&
		    ccol >=0 && ccol < labelim->ncol) {
		  if (labelim->data[i][j] != labelim->data[crow][ccol]) {
		    if (tmpImg.data[i][j] || tmpImg.data[crow][ccol]) {
		      if (Refine_Bound_Point_Cross(i,j, crow, ccol,
						   k,
						   regLabels,
						   labelim,
					      animage,
					      ffamily,
					      controlInfo)) {
			tmpImg.data[i][j] = 1;
			tmpImg.data[crow][ccol] = 1;
			updatedPixel ++;
			changed = 1;
		      }
		    }
		  }
		}
	      }
	      tmpImg.data[i][j] = changed;
	    }
	  }
	}
	else { /* Increase order */
	  mexPrintf("Increase order: starting i=%d j=%d -> ",
		 start_i, start_j);
	  mexEvalString("drawnow;");
	  
	  for (i=start_i; i < (labelim->nrow); i+= ij_grid) {
	    if (prevUpdated > 20) {
	      mexPrintf("%d ", i);
	      mexEvalString("drawnow;");
	    }
	    for (j=start_j; j < (labelim->ncol); j+= ij_grid) {
	      changed = 0;
	      for (k=0; k < CROSS_ORIENT_PER_PIXEL; k++) {
		crow = i + Neighbor_Table[k].y;
		ccol = j + Neighbor_Table[k].x;
		if (crow >=0 && crow < labelim->nrow &&
		    ccol >=0 && ccol < labelim->ncol) {
		  if (labelim->data[i][j] != labelim->data[crow][ccol]) {
		    if (tmpImg.data[i][j] || tmpImg.data[crow][ccol]) {
		      if (Refine_Bound_Point_Cross(i,j, crow, ccol,
						   k,
						   regLabels,
						   labelim,
						   animage,
						   ffamily,
						   controlInfo)) {
			tmpImg.data[i][j] = 1;
			tmpImg.data[crow][ccol] = 1;
			updatedPixel ++;
			changed = 1;
		      }
		    }
		  }
		}
	      }
	      tmpImg.data[i][j] = changed;
	    }
	  }
	}
	printf(" Ending i = %d j = %d.\n",
	       i+(2*odd_even_order-1)*ij_grid,
	       j+(2*odd_even_order-1)*ij_grid);
	odd_even_order = 1-odd_even_order;
	
      }      
    }
    mexPrintf("%d pixels updated at iteration %d\n",updatedPixel, iter);
    prevUpdated = updatedPixel;
    if (controlInfo->interactive) {
      Check_Boundary_Pixels(regLabels,
			    tLabels,
			    labelim,
			    animage,
			    ffamily,
			    controlInfo);
    }
    Remove_Small_Holes(regLabels, labelim);
    if ( (iter % 10) == 0) {
      sprintf(fname,"%s_Boundary_Result_%d.pgm", 
	      controlInfo->prefix, iter);
      Write_An_Image_Int(labelim, (int)(256/(tLabels-1)), fname);
      sprintf(comm, "xv %s &\n", fname);
      system(comm);
      /* 
	 for (k=1; k<tLabels; k++) {
	 sprintf(fname,"Result_%d_%d.pgm", iter, k);
	 Write_An_Image_Float(&(regLabels[k].resImg), fname);
	 sprintf(comm, "xv %s &\n", fname);
	 system(comm);
	 }
      */
    }
    iter++;
  } while( (updatedPixel > 100 && iter < 200) || 
	   (iter <= 21 && updatedPixel >0));
  free(startingFlag);
  Free_Image_Int(&tmpImg); 
  return iter;
}




float  Check_Check_Calc(int row, int col, REGION_LABEL *regLabels,
			int trylabel,
			IMAGEINT *labelim,
			IMAGEINT *animage,
			FILTERBANK *ffamily,
			float *classThreshold)
{
  float tmp =0.0;
  int  i,j, k;
  POINT2D  pCenters[4];
  int  labelNum[4];
  float *tmpHist;
  float bestDist;
  
  if (trylabel <=0) {
    mexPrintf("The label %d is not a valid label.\n", trylabel);
    return 10000.;
  }

  /* Determine the center of the four windows around the pixel */
  pCenters[0].y = row - regLabels[trylabel].segWsize;
  if (pCenters[0].y < regLabels[trylabel].segWsize)
    pCenters[0].y = regLabels[trylabel].segWsize;
  pCenters[0].x = col - regLabels[trylabel].segWsize;
  if (pCenters[0].x < regLabels[trylabel].segWsize) {
    pCenters[0].x = regLabels[trylabel].segWsize;
  }
  
  pCenters[1].y = row + regLabels[trylabel].segWsize;
  if (pCenters[1].y >= (labelim->nrow - regLabels[trylabel].segWsize) )
    pCenters[1].y = labelim->nrow -regLabels[trylabel].segWsize-1;
  pCenters[1].x = pCenters[0].x;
  
  pCenters[2].y =  pCenters[1].y;
  pCenters[2].x = col + regLabels[trylabel].segWsize;
  if (pCenters[2].x >= (labelim->ncol - regLabels[trylabel].segWsize)) {
    pCenters[2].x = labelim->ncol - regLabels[trylabel].segWsize -1;
  }
  
  pCenters[3].y = pCenters[0].y;
  pCenters[3].x = pCenters[2].x;

 
  for (k=0; k<4; k++) {
    labelNum[k] = 0;
    if ( pCenters[k].y < regLabels[trylabel].segWsize  ||
	 (pCenters[k].y+regLabels[trylabel].segWsize) >= 
	 labelim->nrow ||
	 pCenters[k].x < regLabels[trylabel].segWsize ||
	 (pCenters[k].x+regLabels[trylabel].segWsize) >=
	 labelim->ncol ) {
      mexPrintf("%d Constructed window %d, %d at %d,%d with size %d ",
	     k, pCenters[k].x, pCenters[k].y, col, row,
	     regLabels[trylabel].segWsize);
      mexPrintf("out of bound.\n");
      continue;
    }
    for (i=0-regLabels[trylabel].segWsize; 
	 i <= regLabels[trylabel].segWsize; i++) {
      for (j=0-regLabels[trylabel].segWsize;
	   j <= regLabels[trylabel].segWsize; j++) {
	labelNum[k] += 
	  (labelim->data[i+pCenters[k].y][j+pCenters[k].x] == trylabel);
      }
    }
  }
  
  i = 0;
  bestDist = NOT_CALC_VALUE_DEFAULT;
  tmpHist = Create_Array(ffamily->totalBin);
    
  mexPrintf("Windows constructed at %d, %d\n", col, row);
  mexPrintf("\t Center  \t occurences \t  Distance  \t   Average\n");
  for (k=0; k<4; k++) {
    mexPrintf("\t%3d %3d \t    %3d    \t",
	   pCenters[k].x, pCenters[k].y,
	   labelNum[k]);
    if (regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]
	> NOT_CALC_VALUE_DEFAULT) {
      
      Compute_Local_Window_Hist_Inside(pCenters[k].y, pCenters[k].x,
				       regLabels[trylabel].segWin,
				       ffamily,
				       animage,
				       tmpHist);
      regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x] =
	Calc_Hist_Divergence(tmpHist,
			     regLabels[trylabel].fvector,
			     ffamily->totalBin);
    }
    mexPrintf("  %8.6f ", 
	   regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]);
    tmp =  regLabels[trylabel].resImg.data[pCenters[k].y][pCenters[k].x]/
      (0.1+(float)labelNum[k]);
    mexPrintf("\t   %8.6f ", tmp);
    if (bestDist > tmp) {
      i = k;
      bestDist = tmp;
    }
  
    mexPrintf("\n");
  }
  mexPrintf("\t%d was selected with average distance: %8.6f\n",
	 i, bestDist);

  Free_Array(tmpHist);
  *classThreshold = 
    regLabels[trylabel].resImg.data[pCenters[i].y][pCenters[i].x];
  /* Figure out the prob model */
  
  k = (int)(regLabels[trylabel].resImg.data[pCenters[i].y][pCenters[i].x]/
	    regLabels[trylabel].histUnit);
  if (k <0) k = 0;
  if (k >= regLabels[trylabel].histLen) {
    tmp = 0.0;
  }
  else {
    tmp = regLabels[trylabel].probHist[k];
  }
  return tmp;
}


int Check_Refine_Bound_Point(int row1, int col1,
			     int row2, int col2,
			     REGION_LABEL *regLabels,
			     IMAGEINT *labelim,
			     IMAGEINT *animage,
			     FILTERBANK *ffamily,
			     CONTROL_INFO *controlInfo)
{
  float tmp[4];
  float dummy;
  float classThresh[4];
  int label[2];
  int k;
  
  if (abs(row1-row2)>1 || abs(col1-col2) > 1) {
    mexPrintf("Error: %d, %d and %d %d should NOT be adjacent boundary points.\n",
	   col1, row1, col2, row2);
    return 0;
  }
  label[0] = labelim->data[row1][col1];
  label[1] = labelim->data[row2][col2];
  if (label[0] == label[1]) {
    mexPrintf("Labels at %d, %d and %d %d are same with value %d\n",
	   col1, row1, col2, row2, label[0]);
    return 0;
  }
  if (label[0] ==0 || label[1] ==0) {
    mexPrintf("Both labels must NOT be backbackground. One of %d,%d is.\n",
	   label[0],label[1]);
    return 0;
  }
  mexPrintf("Check pixels %d, %d and %d %d with labels %d and %d.\n",
	 col1, row1, col2, row2,label[0],label[1]);
  mexPrintf("\tCheck pixel %d,%d \n", col1, row1);
  for (k=0; k< 2; k++) {
    tmp[k] = (1.0 - controlInfo->boundWeight) * 
      Check_Check_Calc(row1, col1, regLabels, label[k], 
		       labelim,
		       animage, ffamily, &(classThresh[k])) +
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row1, col1,
					 label[k],
					 labelim, (int)1))/9.0;
    mexPrintf("\t\tWith label %d ", label[k]);
    if (label[k] == labelim->data[row1][col1]) {
      mexPrintf("(current label) ");
    }
    mexPrintf("Value: %8.6f (%8.6f %8.6f %8.6f)\n", tmp[k],
	   Check_Calc(row1, col1, regLabels, label[k], 
		      labelim,
		      animage, ffamily, &dummy),
	   ((float)Find_Neighbor_Same_Pixels(row1, col1,
					     label[k],
					     labelim, (int)1))/9.0,
	   classThresh[k]);
    
  }

  mexPrintf("\tCheck pixel %d,%d \n", col2, row2);
  for (k=1; k >= 0; k--) {
    tmp[k] = (1.0 - controlInfo->boundWeight) * 
      Check_Check_Calc(row2, col2, regLabels, label[k], 
		       labelim,
		       animage, ffamily, &(classThresh[k])) +
      controlInfo->boundWeight * 
      ( (float)Find_Neighbor_Same_Pixels(row2, col2,
					 label[k],
					 labelim, (int)1))/9.0;
    mexPrintf("\t\tWith label %d ", label[k]);
    if (label[k] == labelim->data[row2][col2]) {
      mexPrintf("(current label) ");
    }
    mexPrintf("Value: %8.6f (%8.6f %8.6f %8.6f)\n", tmp[k],
	   Check_Calc(row2, col2, regLabels, label[k], 
		      labelim,
		      animage, ffamily, &dummy),
	   ((float)Find_Neighbor_Same_Pixels(row2, col2,
					     label[k],
					     labelim, (int)1))/9.0,
	   classThresh[k]);
  }
  
  
  return 1;
  
}

int Check_Boundary_Pixels(REGION_LABEL *regLabels,
			  int tLabels,
			  IMAGEINT *labelim,
			  IMAGEINT *animage,
			  FILTERBANK *ffamily,
			  CONTROL_INFO *controlInfo)
{
  int row, col;
  int i, k;
  int crow, ccol;
  char fname[256], comm[256];
 
  sprintf(fname,"%s_Check_Bound.pgm", controlInfo->prefix);
  Write_An_Image_Int(labelim, (int)(256/(tLabels-1)), fname);
  sprintf(comm,"xv %s &\n", fname);
  system(comm);
  mexPrintf("Checking pixels along boundary with current label image %s.\n",
	 fname);
  do {
    mexPrintf("A boundary pixel (col, row), please: ");
    scanf("%d", &col);
    if (col < 0 || col >= labelim->ncol) break;
    scanf("%d",&row);
    if (row <0 || row >= labelim->nrow) break;
    for (k=0; k < 8; k++) {
      crow = row + Neighbor_Table[k].y;
      ccol = col + Neighbor_Table[k].x;
      if (crow >=0 && crow < labelim->nrow &&
	  ccol >=0 && ccol < labelim->ncol) {
	if (labelim->data[row][col] != labelim->data[crow][ccol]) {
	  Check_Refine_Bound_Point(row, col, crow, ccol,
				   regLabels,
				   labelim,
				   animage,
				   ffamily,
				   controlInfo);
	  mexPrintf("Press RETURN to continue ... ");
	  fflush(stdin);
	  mexEvalString("drawnow;");
	  do {
	    i = getchar();
	  } while (i != '\n');
	}
	
      }
    }
  } while(1);
  return 1;
}




int Check_Refine_Bound_Row(int row, int upDown,
			   int scol, int ecol,
			   int L1, int L2,
			   REGION_LABEL *regLabels,
			   IMAGEINT *labelim,
			   IMAGEINT *animage,
			   FILTERBANK *ffamily,
			   CONTROL_INFO *controlInfo)
{
  float tmp[4];
  float dummy;
  float classThresh[4];
  int label[2], centers[2];
  int k;
  int col;
  int labels[2];
  float *dist[2];
  float *likelihood[2];
  float *crossdist[2];
  float *crosslikelihood[2];
  
  
  labels[0] = L1;
  labels[1] = L2;
  if (upDown == 0) {
    centers[0] = 0;
    centers[1] = 3;
  }
  else {
    centers[0] = 1;
    centers[1] = 2;
  }

  for ( k=0; k< 2; k++) {
    dist[k] = (float *)malloc(sizeof(float) * animage->ncol);
    likelihood[k] = (float *)malloc(sizeof(float) * animage->ncol);
    crossdist[k] = (float *)malloc(sizeof(float) * animage->ncol);
    crosslikelihood[k]  = (float *)malloc(sizeof(float) * animage->ncol);
  }

  mexPrintf("Calculating information: ");
  for (col = scol; col < ecol; col++) {
    mexPrintf("%d ", col);
    mexEvalString("drawnow;");
    for (k=0; k <2 ; k++) {
      likelihood[k][col] = Check_Calc_With_Window(row, col+k,
						  regLabels,
						  labels[k],
						  labelim,
						  animage,
						  ffamily,
						  centers[k],
						  &(dist[k][col]));
      
      crosslikelihood[k][col] = Check_Calc_With_Window(row, col+k,
						       regLabels,
						       labels[1-k],
						       labelim,
						       animage,
						       ffamily,
						       centers[k],
						       &(crossdist[k][col]));
    }
  }
  mexPrintf("DONE!.\n");
  for (k=0; k < 2; k++) {
    mexPrintf("Information at row %d with ", row);
    if (upDown == 0) {
      mexPrintf("Up ");
    }
    else {
      mexPrintf("Down ");
    }
    mexPrintf("for LABEL %d.\n", labels[k]);
    mexPrintf("\n");
    
    mexPrintf("Col\t");
    for (col = scol; col < ecol; col++) {
      mexPrintf("%8d ", col);
    }
    mexPrintf("\n");
    mexPrintf("Dist\t");
    for (col = scol; col < ecol; col++) {
      mexPrintf("%8.6f ", dist[k][col]);
    }
    mexPrintf("\n");
    mexPrintf("Prob\t");
    for (col = scol; col < ecol; col++) {
      mexPrintf("%8.6f ", likelihood[k][col]);
    }
    mexPrintf("\n");
    mexPrintf("Cr-Dist\t");
    for (col = scol; col < ecol; col++) {
      mexPrintf("%8.6f ", crossdist[k][col]);
    }
    mexPrintf("\n");
    mexPrintf("Cr-Prob\t");
    for (col = scol; col < ecol; col++) {
      mexPrintf("%8.6f ", crosslikelihood[k][col]);
    }
    mexPrintf("\n");
  }
  return 1;
  
}

int Check_Refine_Bound_Col(int col, int leftRight,
			   int srow, int erow,
			   int L1, int L2,
			   REGION_LABEL *regLabels,
			   IMAGEINT *labelim,
			   IMAGEINT *animage,
			   FILTERBANK *ffamily,
			   CONTROL_INFO *controlInfo)
{
  float tmp[4];
  float dummy;
  float classThresh[4];
  int label[2], centers[2];
  int k;
  int row;
  int labels[2];
  float *dist[2];
  float *likelihood[2];
  float *crossdist[2];
  float *crosslikelihood[2];
  
  
  labels[0] = L1;
  labels[1] = L2;
  if (leftRight == 0) {
    centers[0] = 0;
    centers[1] = 1;
  }
  else {
    centers[0] = 3;
    centers[1] = 2;
  }

  for ( k=0; k< 2; k++) {
    dist[k] = (float *)malloc(sizeof(float) * animage->nrow);
    likelihood[k] = (float *)malloc(sizeof(float) * animage->nrow);
    crossdist[k] = (float *)malloc(sizeof(float) * animage->nrow);
    crosslikelihood[k]  = (float *)malloc(sizeof(float) * animage->nrow);
  }

  mexPrintf("Calculating information: ");
  for (row = srow; row < erow; row++) {
    mexPrintf("%d ", row);
    mexEvalString("drawnow;");
    for (k=0; k <2 ; k++) {
      likelihood[k][row] = Check_Calc_With_Window(row+k, col,
						  regLabels,
						  labels[k],
						  labelim,
						  animage,
						  ffamily,
						  centers[k],
						  &(dist[k][row]));
      
      crosslikelihood[k][row] = Check_Calc_With_Window(row+k, col,
						       regLabels,
						       labels[1-k],
						       labelim,
						       animage,
						       ffamily,
						       centers[k],
						       &(crossdist[k][row]));
    }
  }
  mexPrintf("DONE!.\n");
  for (k=0; k < 2; k++) {
    mexPrintf("Information at col %d with ", col);
    if (leftRight == 0) {
      mexPrintf("Left ");
    }
    else {
      mexPrintf("Right ");
    }
    mexPrintf("for LABEL %d.\n", labels[k]);
    mexPrintf("\n");
    
    mexPrintf("Row\t");
    for (row = srow; row < erow; row++) {
      mexPrintf("%8d ", row);
    }
    mexPrintf("\n");
    mexPrintf("Dist\t");
    for (row = srow; row < erow; row++) {
      mexPrintf("%8.6f ", dist[k][row]);
    }
    mexPrintf("\n");
    mexPrintf("Prob\t");
    for (row = srow; row < erow; row++) {
      mexPrintf("%8.6f ", likelihood[k][row]);
    }
    mexPrintf("\n");
    mexPrintf("Cr-Dist\t");
    for (row = srow; row < erow; row++) {
      mexPrintf("%8.6f ", crossdist[k][row]);
    }
    mexPrintf("\n");
    mexPrintf("Cr-Prob\t");
    for (row = srow; row < erow; row++) {
      mexPrintf("%8.6f ", crosslikelihood[k][row]);
    }
    mexPrintf("\n");
  }
  return 1;
  
}

int Check_Boundary_Rows(REGION_LABEL *regLabels,
			int tLabels,
			IMAGEINT *labelim,
			IMAGEINT *animage,
			FILTERBANK *ffamily,
			CONTROL_INFO *controlInfo)
{
  int row, scol, ecol, col, srow, erow;
  int i, k;
  int L1, L2;
  int crow, ccol;
  char fname[256], comm[256];
  
  sprintf(fname,"%s_Check_Row.pgm", controlInfo->prefix);
  Write_An_Image_Int(labelim, (int)(256/(tLabels-1)), fname);
  sprintf(comm,"xv %s &\n", fname);
  system(comm);
  mexPrintf("Checking rows  current label image %s.\n",
	 fname);
  do {
    mexPrintf("Row ('r' or 'R' for row) or column (otherwise): ");
    scanf("%s", fname);
    if (fname[0] == 'r' || fname[0] == 'R') {
      mexPrintf("One row for checking (row), please: ");
      scanf("%d", &row);
      if (row <0 || row >= labelim->nrow) break;
      mexPrintf("Starting and ending cols: ");
      scanf("%d",&scol);
      if (scol < 0 || scol >= labelim->ncol) break;
      scanf("%d",&ecol);
      if (ecol < 0 || ecol >= labelim->ncol) break;
      
      mexPrintf("Left and right labels: ");
      scanf("%d%d", &L1, &L2);
      if (L1 < 1 || L1 >= tLabels || L2 <1 || L2 >= tLabels ) break;
      mexPrintf("Which side, up (0) or down (otherwise): ");
      scanf("%d", &k);
      Check_Refine_Bound_Row(row, k,
			     scol, ecol,
			     L1, L2,
			     regLabels,
			     labelim,
			     animage,
			     ffamily,
			     controlInfo);
    }
    else {
      mexPrintf("One col for checking (col), please: ");
      scanf("%d", &col);
      if (col <0 || col >= labelim->ncol) break;
      mexPrintf("Starting and ending rows: ");
      scanf("%d",&srow);
      if (srow < 0 || srow >= labelim->nrow) break;
      scanf("%d",&erow);
      if (erow < 0 || erow >= labelim->nrow) break;
      
      mexPrintf("Left and right labels: ");
      scanf("%d%d", &L1, &L2);
      if (L1 < 1 || L1 >= tLabels || L2 <1 || L2 >= tLabels ) break;
      mexPrintf("Which side, left (0) or right (otherwise): ");
      scanf("%d", &k);
      Check_Refine_Bound_Col(col, k,
			     srow, erow,
			     L1, L2,
			     regLabels,
			     labelim,
			     animage,
			     ffamily,
			     controlInfo); 
    }

  } while(1);
  return 1;
}

