% matlab code for texture_sysnthesis
clear;
delete('task_image_julesz_syn_0*.pgm');
imagePath = './obs_imgs';
imageName = 'horizon_obs.gif';
resPath ='./res_imgs';

make_synthesis();

obs_image = imread([imagePath '/' imageName]);
if size(obs_image,3) ==3
    obs_image = rgb2gray(obs_image);
end
% special tratement to accomodate old images
if max(max(obs_image)) <=8 
    obs_image = uint8(floor(single(obs_image) *255.0/8));
end
imwrite(obs_image,'task_image.pgm')
syn_julesz_seq('task_image_sparse.par')

% visulize result
figure
nRow = 2; nCol =4;
subplot(nRow,nCol,1)
imshow(obs_image)
title('Observed image')
subplot(nRow,nCol,2)
img = imread('task_image_syn_init.pgm');
imshow(img)
title('Initial image')
interList = dir('task_image_julesz_syn_0*.pgm');
nIter = length(interList);
step = floor(nIter/(nRow*nCol-3));
indImg = 3;
for ii = 0:step:nIter-1
    img = imread(['task_image_julesz_syn_' num2str(ii,'%04d') '.pgm']);
    subplot(nRow,nCol,indImg)
    imshow(img)
    title(['Iteration ' num2str(ii+1)])
    indImg = indImg +1;
end
img = imread('task_image_julesz_syn_seq_0.pgm');
subplot(nRow,nCol,nRow*nCol)
imshow(img);
title('Final result');
saveas(gcf, [resPath '/synth_process' imageName '.png']);
imwrite(img, [resPath '/synth_result' imageName '.png']);

