function ABadjust_adaboost(iRun)

% <iRun>: the No. of the random run
% <Totalsketch>: allowed number of selected Gabors   

templateSize = [100 150]; % template size is 100 (height) * 150 (width)
numGridPoint = 50;
subsampleStep = 2;

% load natural statistics
load(sprintf('naturalStat_run%d',iRun));

% load model
load( sprintf('model_run%d.mat', iRun) );

% load the positive images
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');

% CONSTANTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
epsilon = .1;  % allowed correlation between selected Gabors
Totalsketch = 80;  % allowed number of selected Gabors   
sub = 2;    % subsampling rate for Gabor
Lrange = 3; % allowed shifting in location (times sub pixels)
Orange = 1; % allowed shifting in orientation
%%% Note: Lrange*sub is the pixels allowed to shift along normal
%%%       Lrange*sub should be the same in learning and testing
SHUTUP = 0.; % SHUTUP is to neglect the positions with low average responses          

% special case: single example
if length(posTrainImages) == 1
    storedLrange = Lrange;
    storedOrange = Orange;
    Lrange = 0;
    Orange = 0;
end

% TRAINING EXAMPLES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ==================================================================
%  input images from a folder
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');
nimage = length(posTrainImages);
posTrainImagePaths = cell(1,length(posTrainImages));
for i = 1:length(posTrainImages)
    posTrainImagePaths{i} = sprintf('../posAll/%s',posTrainImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(posTrainImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for all positive examples
posFea = cell(1,nimage);
for i = 1:nimage
	posFea{i} = zeros( Totalsketch, 1 );
	for j = 1:Totalsketch
		posFea{i}(j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end



% ==================================================================
%  input images from a folder
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'negTrainImages');
nimage = length(negTrainImages);
negTrainImagePaths = cell(1,length(negTrainImages));
for i = 1:length(negTrainImages)
    negTrainImagePaths{i} = sprintf('../negAll/%s',negTrainImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(negTrainImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


negFea = cell(1,nimage);
for i = 1:nimage
	negFea{i} = zeros( Totalsketch, 1 );
	for j = 1:Totalsketch
		negFea{i}(j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end


dataWeight = ones( length(posFea)+length(negFea), 1 );
dataWeight = dataWeight / sum(dataWeight);

% ========== adjust by adaboost ==============
[selectedInd selectedThresholds selectedPolars selectedLambdas] = adaboostAdjusting( posFea, negFea, dataWeight, numGridPoint, Totalsketch );



%% testing stage
% ==================================================================
%  input positive testing images
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTestImages');
nimage = length(posTestImages);
posTestImagePaths = cell(1,length(posTestImages));
for i = 1:length(posTestImages)
    posTestImagePaths{i} = sprintf('../posAll/%s',posTestImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(posTestImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for the above examples
posScores = zeros(nimage,1);
for i = 1:nimage
	Fea{i} = zeros( Totalsketch, 1 );
	for j = 1:Totalsketch
		ind = selectedInd(j) + 1;
		r = allfiltered{i,Mi(ind)+1}(Mx(ind),My(ind));
		if selectedPolars(j) > 0
			posScores(i) = posScores(i) + selectedLambdas(j) * r;
		else
			posScores(i) = posScores(i) - selectedLambdas(j) * r;
		end
	end
end


% ==================================================================
%  input negative testing images
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'negTestImages');
nimage = length(negTestImages);
negTestImagePaths = cell(1,length(negTestImages));
for i = 1:length(negTestImages)
    negTestImagePaths{i} = sprintf('../negAll/%s',negTestImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(negTestImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for the above examples
negScores = zeros(nimage,1);
for i = 1:nimage
	Fea{i} = zeros( Totalsketch, 1 );
	for j = 1:Totalsketch
		ind = selectedInd(j) + 1;
		r = allfiltered{i,Mi(ind)+1}(Mx(ind),My(ind));
		if selectedPolars(j) > 0
			negScores(i) = negScores(i) + selectedLambdas(j) * r;
		else
			negScores(i) = negScores(i) - selectedLambdas(j) * r;
		end
	end
end


addpath('../');
[ap testAUC tp fp] = evaluate(posScores,negScores);
save( sprintf('adjusted_adaboost_run%d.mat', iRun), 'selectedInd', 'selectedThresholds', 'selectedPolars', 'selectedLambdas', 'ap', 'testAUC' );





