function ABadjust_lr(iRun)
% Adjusting feature weights by logistic regression.
% <iRun>: the No. of the random run
% <Totalsketch>: allowed number of selected Gabors   

templateSize = [100 150]; % template size is 100 (height) * 150 (width)
subsampleStep = 2;

% load natural statistics
load(sprintf('naturalStat_run%d',iRun));

% load model
load( sprintf('model_run%d.mat', iRun) );

% load the positive images
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');

% CONSTANTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Totalsketch = 80;  % allowed number of selected Gabors   
Lrange = 3; % allowed shifting in location (times sub pixels)
Orange = 1; % allowed shifting in orientation
%%% Note: Lrange*sub is the pixels allowed to shift along normal
%%%       Lrange*sub should be the same in learning and testing

% special case: single example
if length(posTrainImages) == 1
    storedLrange = Lrange;
    storedOrange = Orange;
    Lrange = 0;
    Orange = 0;
end

% TRAINING EXAMPLES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ==================================================================
%  input images from a folder
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');
nimage = length(posTrainImages);
posTrainImagePaths = cell(1,length(posTrainImages));
for i = 1:length(posTrainImages)
    posTrainImagePaths{i} = sprintf('../posAll/%s',posTrainImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(posTrainImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for all positive examples
posFea = zeros(nimage,Totalsketch);
for i = 1:nimage
	for j = 1:Totalsketch
		posFea(i,j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end



% ==================================================================
%  input images from a folder
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'negTrainImages');
nimage = length(negTrainImages);
negTrainImagePaths = cell(1,length(negTrainImages));
for i = 1:length(negTrainImages)
    negTrainImagePaths{i} = sprintf('../negAll/%s',negTrainImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(negTrainImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


negFea = zeros(nimage,Totalsketch);
for i = 1:nimage
	for j = 1:Totalsketch
		negFea(i,j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end

% ========== adjust by logistic regression ==============
C=0.01; % tuning parameter
Xt = [posFea;negFea];
X = sparse(Xt);
Y = ones( size(X,1), 1 );
Y(1+size(posFea,1):end) = -1;    % negative examples
para=['-s 0 -B 1 -c ' num2str(C)]; % -s 0 is for L2-logistic regression, -B 1 is for bias term, -c is for tuning parameter
model = train(Y,X,para);


%% testing stage
% ==================================================================
%  input positive testing images
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTestImages');
nimage = length(posTestImages);
posTestImagePaths = cell(1,length(posTestImages));
for i = 1:length(posTestImages)
    posTestImagePaths{i} = sprintf('../posAll/%s',posTestImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(posTestImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for the above examples
posFea = zeros(nimage,Totalsketch);
for i = 1:nimage
	for j = 1:Totalsketch
		posFea(i,j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end

Xpos=sparse(posFea);
Y=ones(nimage,1);
[posLabel aPos posScores] = predict(Y,Xpos,model,'-b 1');


% ==================================================================
%  input negative testing images
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'negTestImages');
nimage = length(negTestImages);
negTestImagePaths = cell(1,length(negTestImages));
for i = 1:length(negTestImages)
    negTestImagePaths{i} = sprintf('../negAll/%s',negTestImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(negTestImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
Cmax(nimage, norient, allfiltered, templateSize(1), templateSize(2), Lrange, Orange, subsampleStep); % compute Max1 maps
disp(['filtering time: ' num2str(toc) ' seconds']);


% extract selected feature responses for the above examples
negFea = zeros(nimage,Totalsketch);
for i = 1:nimage
	for j = 1:Totalsketch
		negFea(i,j) = allfiltered{i,Mi(j)+1}(Mx(j),My(j));
	end
end

Xneg=sparse(negFea);
Y=-ones(nimage,1);
[negLabel aNeg negScores] = predict(Y,Xneg,model,'-b 1');

addpath('../');
[ap testAUC tp fp] = evaluate(posScores(:,1),negScores(:,1));
RegressionParameters=model.w;
save( sprintf('adjusted_lr_run%d.mat', iRun),  'ap', 'testAUC', 'aPos', 'aNeg','posScores','posLabel','negScores','negLabel','RegressionParameters');

