function tss = ABtest_one(iRun,imagePaths)

load(sprintf('model_run%d.mat',iRun)); % load trained shared-sketch model

nimage = length(imagePaths); % # images

% filter the testing images 
disp('start filtering');
tic
allfiltered = getGaborMaps(imagePaths,templateSize,allfilter); % compute Sum1 maps
% sigmoid transformation
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1), ones(1,nimage)*templateSize(2), Upperbound);

disp(['filtering time: ' num2str(toc) ' seconds']);

% prepare the spaces for C code
Asym = cell(1, nimage);   % symbolic plot for each image with active Gabor
for i = 1 : nimage
    Asym{i} = zeros(templateSize);
end
tss = zeros(nimage, Totalsketch);  % total scores for testing images

% pass on the pointers to C for heavy computation
disp('start testing');
tic
sx = templateSize(1); sy = templateSize(2);
Ctesting(nimage, norient, allfiltered, C, h, sx, sy,...
    Mi, Mx, My, Mm, Mm1, allsymbol(1, :), Asym, Lrange,...
    Orange, sub, Totalsketch, Upperbound, tss, ...
    M, lam, e, lz);

disp(['mex-C testing time: ' num2str(toc) ' seconds']);


