function [ap testAUC tp fp] = evaluate(tssPos,tssNeg)


maxNF = size(tssPos,2);
ap = zeros(maxNF,1);
testAUC = zeros(maxNF,1);
tp = cell(maxNF,1); fp = cell(maxNF,1);
for nF = 1:maxNF
    % Draw ROC curve and calculate AUC
    allScore = [tssPos(:,nF); tssNeg(:,nF)]; % scores of all test images
    gt = [ones(size(tssPos,1),1);-1*ones(size(tssNeg,1),1)]; % ground truth of all test images
    [testAUC(nF) tp{nF}, fp{nF}] = calc_auc(allScore,gt); % obtain ROC curve by comparing predicted scores and ground truth
     % and true positive and false postive rate
    ap(nF) = getAP(gt,allScore);
end