function allfiltered = getGaborMaps(imagePaths,templateSize,allfilter)
%
% Compute S1 maps from images whose paths are specified in <imagePaths>.
%
load parameter;

nimage = length(imagePaths); % number of example images
I = cell(1,nimage);
for i = 1 : nimage
    tmpIm = imread(imagePaths{i});
    if size(tmpIm,3) == 3
        tmpIm = rgb2gray(tmpIm);
    end
    tmpIm = double(tmpIm);
    I{i} = imresize(tmpIm,templateSize,'nearest'); % images are all resized to templateSize
end

allfiltered = applyfilterfftsame(I, allfilter, localOrNot, localHalfx, localHalfy, 1, thresholdFactor); % Gabor filtering
