function ABlearn(iRun)

% <iRun>: the No. of the random run
% <Totalsketch>: allowed number of selected Gabors   

load parameter;

templateSize = [85 127]; % template size is 85 (height) * 127 (width)

% load natural statistics
load(sprintf('naturalStat_run%d',iRun));

% load the positive images
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');

% CONSTANTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
epsilon = .1;  % allowed correlation between selected Gabors
Totalsketch = 80;  % allowed number of selected Gabors   
sub = 2;    % subsampling rate for Gabor
Lrange = 3; % allowed shifting in location (times sub pixels)
Orange = 1; % allowed shifting in orientation
%%% Note: Lrange*sub is the pixels allowed to shift along normal
%%%       Lrange*sub should be the same in learning and testing
SHUTUP = 0.; % SHUTUP is to neglect the positions with low average responses          

% special case: single example
if length(posTrainImages) == 1
    storedLrange = Lrange;
    storedOrange = Orange;
    Lrange = 0;
    Orange = 0;
end

% TRAINING EXAMPLES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ==================================================================
%  input images from a folder
% ==================================================================
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTrainImages');
nimage = length(posTrainImages);
posTrainImagePaths = cell(1,length(posTrainImages));
for i = 1:length(posTrainImages)
    posTrainImagePaths{i} = sprintf('../posAll/%s',posTrainImages{i});
end

% FILTERING IMAGES %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
tic
disp('start filtering');
addpath('../');
[allfilter, allsymbol] = makefilter(scale, norient);  % generate Gabor filters
allfiltered = getGaborMaps(posTrainImagePaths,templateSize,allfilter); % compute Sum1 maps
Ctransform(nimage, norient, allfiltered, ones(1,nimage)*templateSize(1)...
    , ones(1,nimage)*templateSize(2), Upperbound); % sigmoid transform
h = (size(allfilter{1}, 1)-1)/2;  % half size of Gabor
C = corr(allfilter, epsilon);    % generate the inhibition maps between Gabors
disp(['filtering time: ' num2str(toc) ' seconds']);

% VARIABLES FOR MEX-C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Mi = zeros(1, Totalsketch);  % orientation of selected Gabor
Mx = zeros(1, Totalsketch);  % position of selected Gabor
My = zeros(1, Totalsketch); 
Mm = zeros(1, Totalsketch);  % lambda
Mm1 = zeros(1, Totalsketch);  % logZ
sym = zeros(templateSize);  % symbolic plot of selected Gabor
Asym = cell(1, nimage);   % symbolic plot for each image with active Gabor
for i = 1 : nimage
    Asym{i} = zeros(templateSize);  
end
tss = zeros(nimage, 1);  % total scores for testing images
gain = zeros(Totalsketch, 1);  % coding gain for selected Gabor

binnum = 50; % number of bins
% MEX-C %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp('start learning');
tic
Clearn(nimage, norient, allfiltered, C, h, templateSize(1), templateSize(2),...
    Mi, Mx, My, Mm, Mm1, allsymbol(1, :), sym, Asym,...
    Lrange, Orange, sub, Totalsketch, Upperbound,...
    tss, gain, SHUTUP, binnum, M, lam, e, lz);
disp(['mex-C learning time: ' num2str(toc) ' seconds']);

if length(posTrainImages) == 1
    Lrange = storedLrange;
    Orange = storedOrange;
end

save(sprintf('model_run%d.mat',iRun),...
    'Mi','Mx','My', 'Mm','Mm1','C','h','Lrange','Orange','sub','scale',...
    'norient','allfilter','allsymbol','Asym','Upperbound',...
    'Totalsketch','M','lam', 'e', 'lz', 'sym', 'templateSize');

