function ABtest(iRun)

% working environment for shared sketch experiments -- testing phase
load(sprintf('../RandomSplits/split%d.mat',iRun),'posTestImages','negTestImages');
disp('testing...');
posFolder = '../posAll/';  % folder of positive testing images
negFolder = '../negAll/'; % folder of negative testing images
posTestImagePath = cell(1,length(posTestImages));
for i = 1:length(posTestImages)
    posTestImagePath{i} = [posFolder posTestImages{i}];
end
negTestImagePath = cell(1,length(negTestImages));
for i = 1:length(negTestImages)
    negTestImagePath{i} = [negFolder negTestImages{i}];
end

% Begin testing:
disp('testing positive');
tssPos = ABtest_one(iRun,posTestImagePath); % scores on test positives
disp('testing negative');
tssNeg = ABtest_one(iRun,negTestImagePath); % scores on test negatives

addpath('../');
[ap testAUC tp fp] = evaluate(tssPos,tssNeg);

save(sprintf('out_run%d',iRun),'tp','fp','testAUC','ap','tssPos','tssNeg');


