clear all; close all; 
disp(['===============> Getting parameters and mex-c code']);
%% mex-C code
mex Chistogram.c;   % pool histogram from negative images
mex CsharedSketch.c; % learning by shared sketch algorithm
mex Csigmoid.c; % sigmoid transformation
mex CgetMAX1track.c; % get MAX1 maps and track maps
mex Caverage.c; % sigmoid transformation
mex CgetSUM2.c;   % template matching inference
mex CgetMAX2.c;   % template matching inference
mex CgetBack.c;   % template matching inference
mex CgetBackInhibit.c;   % template matching with inhibition 
mex ClocalNormalizeDouble.c; % local normalization of type double
mex ClocalNormalize.c; % local normalization
%% parameters for Gabor filters
numScale = 5; 
scales = [.7 1. 1.3 1.6 2.]; 
numOrient = 15;  % number of orientations
saturation = 6.; % saturation level for sigmoid transformation
%% parameter for exponential model
binSize = .2;  % binsize for computing histogram of q()
numStoredPoint = 50; % number of stored lambda values
spacing = .1; % spacing between two adjacent points
%% parameters for normalization
localOrNot = 1; % if we use local normalization or not. If not, set it to -1 
localHalfx = 20; localHalfy = 20; % the half range for local normalization, has to be quite large
windowNormalizeOrNot = -1; % whether normalize within the scanning window in detection 
if (localOrNot>0)
    windowNormalizeOrNot = -1; 
end % if we use local normalization, we should not use window normalization in detection
thresholdFactor = .01;  % divide the response by max(average, maxAverage*thresholdFactor)
%% save parameters
parameterName = ['parameter'];
save(parameterName, 'numScale', 'scales', 'numOrient', 'saturation', ...
                    'binSize', 'numStoredPoint', 'spacing', ...
                    'localOrNot', 'localHalfx', 'localHalfy', 'windowNormalizeOrNot', 'thresholdFactor');