function activebasis

% Active basis for classification with cross validation.

% Each run features a random sample of positive training examples.
% See splitdata.m for details about how the random runs are generated.

mex Clearn.c
mex Ctesting.c
mex Ctransform.c
mex Chistog.c
mex Cmax.c
mex adaboostAdjusting.c

% mex files for liblinear
if ispc
    make;  % this is used under Windows
end

if isunix
    % the following lines are to be used under Linux
    system('make');
    system('chmod a+x ../svm_learn');
    system('chmod a+x ../svm_classify');
end

% initialization for local normalization
ParameterCodeImage;

for iRun = 1:25
    disp(sprintf('----------run %d starts: ----------',iRun));
    disp(sprintf('----------Fitting Active Basis Model: ----------'));
    tilt(iRun);
    ABlearn(iRun);
    ABtest(iRun);
    disp(sprintf('----------Adjusting by AdaBoost: ----------'));
    ABadjust_adaboost(iRun);
    disp(sprintf('----------Adjusting by Logistic Regression: ----------'));
    ABadjust_lr(iRun);
    disp(sprintf('----------Adjusting by SVM: ----------'));
	ABadjust_svm(iRun);
end

AnalyzeParameterTuning;
