clear

mkdir('RandomSplits')

% load positive images
posImageNames = dir('posAll/*.jpg');
% load negative images
negImageNames = dir('negAll/*.jpg');

nTrainPos = 10; nTrainNeg = 160;

for run = 1:5
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end

nTrainPos = 20; nTrainNeg = 160;

for run = 6:10
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end


nTrainPos = 40; nTrainNeg = 160;

for run = 11:15
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end

nTrainPos = 80; nTrainNeg = 160;

for run = 16:20
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end


nTrainPos = 5; nTrainNeg = 160;

for run = 21:25
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end


nTrainPos = 2; nTrainNeg = 160;

for run = 26:45
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end


nTrainPos = 1; nTrainNeg = 160;

for run = 46:85
    % randomly assign nTrainPos positive images to training
    perm = randperm(length(posImageNames));
    posTrainImages = cell(1,nTrainPos);
    for i = 1:nTrainPos
        posTrainImages{i} = posImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    posTestImages = cell(1,length(posImageNames)-nTrainPos);
    for i = 1:length(posTestImages)
        posTestImages{i} = posImageNames(perm(i+nTrainPos)).name;
    end
    
    % randomly assign nTrainNeg negative images to training
    perm = randperm(length(negImageNames));
    negTrainImages = cell(1,nTrainNeg);
    for i = 1:nTrainNeg
        negTrainImages{i} = negImageNames(perm(i)).name;
    end
    % assign the rest positive images to testing
    negTestImages = cell(1,length(negImageNames)-nTrainNeg);
    for i = 1:length(negTestImages)
        negTestImages{i} = negImageNames(perm(i+nTrainNeg)).name;
    end
    
    save(sprintf('RandomSplits/split%d.mat',run),'negTestImages',...
        'negTrainImages','posTrainImages','posTestImages');
end

