/* SUM-MAX MAPS FOR TEMPLATE MATCHING INFERENCE */
# include <stdio.h>
# include <stdlib.h>
# include "mex.h"        
# include "math.h"
# define PI 3.1415926
# define ROUND(x) (floor((x)+.5))
# define NEGMAX -1e10
/* Generating integer vector */
int *int_vector(int n)
{
    int *v; 
    v = (int*) mxCalloc (n, sizeof(int));
    return v; 
}
/* Generating integer matrix */
int **int_matrix(int m, int n)
{
    int **mat; 
    int i; 
    mat = (int**) mxCalloc(m, sizeof(int*)); 
    for (i=0; i<m; i++)
        mat[i] = int_vector(n); 
    return mat; 
}
/* Free matrix space */
void free_matrix(void **mat, int m, int n)
{
        int i;
        for (i=0; i<m; i++)
              mxFree(mat[i]);
        mxFree(mat);
}
/* Compute pixel index in the vector that stores image */
int px(int x, int y, int lengthx, int lengthy)  /* the image is lengthx*lengthy */
{            
   return (x + (y-1)*lengthx - 1); 
 }
 /* variables */
int numOrient, locationShiftLimit, orientShiftLimit; /* key parameters */
int numResolution, numElement; /* number of resolutions and number of Gabors */   
double *allSizex, *allSizey;  /* sizes of images at multiple resolutions */
float **SUM1map, **MAX1map, **SUM2map, *MAX2score;
int halfFilterSize; /* filter size = 2*halfFilterSize + 1 */ 
double **allSymbol; /* symbols of Gabors */              
int sizex, sizey, subsample, sizexSubsample, sizeySubsample; /* MAX1 maps are smaller than SUM1 maps by subsample */ 
int sizeTemplatex, sizeTemplatey, sizeTemplatexSubsample, sizeTemplateySubsample;
int numShift, **xShift, **yShift, **orientShifted; /* stored shifts in x and y, and the shifted orientations */      
double *selectedOrient, *selectedx, *selectedy, *selectedlambda, *selectedLogZ; /* parameters of learned active basis */  
float **translatedTemplate; /* templates at the maximum likelihood location */    
double *allFx, *allFy; /* detected location over multiple resolutions */
/* store all the shifts or perturbations in local maximum pooling */
void StoreShift()  
{
    int orient, i, j, shift, ci, cj, si, sj, os;
    double alpha; 
    /* store all the possible shifts for all orientations */
    numShift = (locationShiftLimit*2+1)*(orientShiftLimit*2+1); 
    xShift = int_matrix(numOrient, numShift); 
    yShift = int_matrix(numOrient, numShift); 
    orientShifted = int_matrix(numOrient, numShift);
    /* order the shifts from small to large */
    for (orient=0; orient<numOrient; orient++)        
    {
        alpha = PI*orient/numOrient;
        ci = 0; 
        for (i=0; i<=locationShiftLimit; i++)
           for (si=0; si<=1; si++)
           {
             cj = 0;    
             for (j = 0; j<=orientShiftLimit; j++)
                 for (sj=0; sj<=1; sj++)
                  {
                    shift = ci*(2*orientShiftLimit+1) + cj; 
                    xShift[orient][shift] = ROUND(i*(si*2-1)*subsample*cos(alpha)); 
                    yShift[orient][shift] = ROUND(i*(si*2-1)*subsample*sin(alpha)); 
                    os = orient + j*(sj*2-1);
                    if (os<0)
                        os += numOrient; 
                    else if (os>=numOrient)
                        os -= numOrient; 
                    orientShifted[orient][shift] = os; 
                    
                    if (j>0) 
                        cj ++; 
                    else if (sj==1)
                        cj++; 
                 }
             if (i>0)
                 ci ++; 
             else if (si==1)
                 ci++;                     
             }
    }
}
/* local maximum pooling at (x, y, orient) */
float LocalMaximumPooling(int resolution, int orient, int x, int y, int *trace) 
{
   float maxResponse, r;
   int shift, x1, y1, orient1, mshift; 
 
   maxResponse = NEGMAX;  mshift = 0; 
   for (shift=0; shift<numShift; shift++)
   {
       x1 = x + xShift[orient][shift]; 
       y1 = y + yShift[orient][shift]; 
       orient1 = orientShifted[orient][shift];
       if ((x1>=1)&&(x1<=sizex)&&(y1>=1)&&(y1<=sizey))
        {            
           r = SUM1map[orient1*numResolution+resolution][px(x1, y1, sizex, sizey)]; 
           if (r>maxResponse)
                {
                   maxResponse = r;   
                   mshift = shift; 
                }
         }
     }
   trace[0] = mshift;  /* return the shift in local maximum pooling */
   return(maxResponse); 
}
/* plot the bar for Gabor at (mx, my, mo) */
void DrawElement(float *Template, int mo, int mx, int my, double w) 
{
  int x, y, here; 
  float a; 
          
  for (x=mx-halfFilterSize; x<=mx+halfFilterSize; x++)
     for (y=my-halfFilterSize; y<=my+halfFilterSize; y++)
        if ((x>=1)&&(x<=sizex)&&(y>=1)&&(y<=sizey))
        {
         a = allSymbol[mo][px(x-mx+halfFilterSize+1, y-my+halfFilterSize+1, 
                              2*halfFilterSize+1, 2*halfFilterSize+1)]*w; 
         here = px(x, y, sizex, sizey); 
         if (Template[here]<a)
             Template[here] = a;
        }
}
/* compute SUM2 maps for image img, the size of SUM2 is the same as that of MAX1 */
void ComputeSUM2map(int resolution)
{
   int t, x, y, here, x1, y1, besto, bestx, besty; 
   double bestlambda, bestLogZ; 
   
   for (x=1; x<=sizex; x++)
      for (y=1; y<=sizey; y++)
         {  
           here = px(x, y, sizex, sizey);            
           translatedTemplate[resolution][here] = 0.; 
         }  
   for (x=1; x<=sizexSubsample; x++)
      for (y=1; y<=sizeySubsample; y++)
         {  
           here = px(x, y, sizexSubsample, sizeySubsample);            
           SUM2map[resolution][here] = 0.; 
         }  

   t = 0; 
   do  
   {
     besto = ROUND(selectedOrient[t]); bestx = ROUND(selectedx[t]); besty = ROUND(selectedy[t]);  
     bestlambda = selectedlambda[t]; bestLogZ = selectedLogZ[t]; 
     for (x=1; x<=sizexSubsample; x++)
         for (y=1; y<=sizeySubsample; y++)  
          {  
              x1 = x+bestx; y1 = y+besty; 
              if ((x1>=1)&&(x1<=sizexSubsample)&&(y1>=1)&&(y1<=sizeySubsample))
                 SUM2map[resolution][px(x, y, sizexSubsample, sizeySubsample)] +=  
                   (bestlambda*MAX1map[besto*numResolution+resolution][px(x1, y1, sizexSubsample, sizeySubsample)] - bestLogZ);  
              else 
                 SUM2map[resolution][px(x, y, sizexSubsample, sizeySubsample)] -= bestLogZ; 
         }
     t++; 
     }
  while (t<numElement);   
}
/* compute the MAX2 score for each resolution */
void ComputeMAX2score(int resolution)
{
   int x, y, Fx, Fy, t, besto, bestx, besty, shift, trace[2];  
   float F, r, maxResponse; 

   F = NEGMAX; 
   for (x=1; x<=sizexSubsample; x++)
         for (y=1; y<=sizeySubsample; y++)  
          {       
             r = SUM2map[resolution][px(x, y, sizexSubsample, sizeySubsample)]; 
             if (F<r) 
             {
                 F = r; Fx = x; Fy = y; 
             }
          }  
   MAX2score[resolution] = F; allFx[resolution] = Fx*subsample; allFy[resolution] = Fy*subsample; 
   /* plot the translated and deformed template */ 
   t = 0; 
   do  
     {
       besto = ROUND(selectedOrient[t]); bestx = ROUND(selectedx[t]); besty = ROUND(selectedy[t]);   
       maxResponse = LocalMaximumPooling(resolution, besto, (Fx+bestx)*subsample, (Fy+besty)*subsample, trace);
       shift = trace[0]; 
       DrawElement(translatedTemplate[resolution], orientShifted[besto][shift], 
            (Fx+bestx)*subsample+xShift[besto][shift], (Fy+besty)*subsample+yShift[besto][shift], sqrt(maxResponse)); 
     t++; 
     }
   while (t<numElement); 
} 
/* read in the input and output variables */
void mexFunction(int nlhs, mxArray *plhs[], 
                 int nrhs, const mxArray *prhs[])                
{
 int img, numImage, resolution, orient, c; 
 mxArray *f;  
 
 c = 0; 
 img = ROUND(mxGetScalar(prhs[c++]))-1;
 numImage = ROUND(mxGetScalar(prhs[c++]));
 numResolution = ROUND(mxGetScalar(prhs[c++]));
 allSizex = mxGetPr(prhs[c++]);
 allSizey = mxGetPr(prhs[c++]);
 numOrient = ROUND(mxGetScalar(prhs[c++]));   
 locationShiftLimit = ROUND(mxGetScalar(prhs[c++]));    
 orientShiftLimit = ROUND(mxGetScalar(prhs[c++]));  
 subsample = ROUND(mxGetScalar(prhs[c++]));
 sizeTemplatex = ROUND(mxGetScalar(prhs[c++]));  
 sizeTemplatey = ROUND(mxGetScalar(prhs[c++])); 
 halfFilterSize = ROUND(mxGetScalar(prhs[c++]));    
 SUM1map = mxCalloc(numResolution*numOrient, sizeof(float*));   
 for (resolution=0; resolution<numResolution; resolution++)
     for (orient=0; orient<numOrient; orient++)
      {  
       f = mxGetCell(prhs[c], orient*numResolution*numImage+img*numResolution+resolution); 
       SUM1map[orient*numResolution+resolution] = mxGetPr(f);       
      }
 c++;
 allSymbol = mxCalloc(numOrient, sizeof(double*));    
 for (orient=0; orient<numOrient; orient++)
     {  
       f = mxGetCell(prhs[c], orient); 
       allSymbol[orient] = mxGetPr(f);       
     }
 c++; 
 numElement = ROUND(mxGetScalar(prhs[c++])); 
 selectedOrient = mxGetPr(prhs[c++]);              
 selectedx = mxGetPr(prhs[c++]);         
 selectedy = mxGetPr(prhs[c++]);   
 selectedlambda = mxGetPr(prhs[c++]);  
 selectedLogZ = mxGetPr(prhs[c++]);  
 
 MAX1map = mxCalloc(numResolution*numOrient, sizeof(float*));   
 for (resolution=0; resolution<numResolution; resolution++)
     for (orient=0; orient<numOrient; orient++)
      {  
       f = mxGetCell(prhs[c], orient*numResolution*numImage+img*numResolution+resolution); 
       MAX1map[orient*numResolution+resolution] = mxGetPr(f);         
      }
 c++;
 SUM2map = mxCalloc(numResolution, sizeof(float*)); 
 for (resolution=0; resolution<numResolution; resolution++)
   {
     f = mxGetCell(prhs[c], img*numResolution+resolution); 
     SUM2map[resolution] = mxGetPr(f);  
  } 
 c++; 
 translatedTemplate = mxCalloc(numResolution, sizeof(float*)); 
 for (resolution=0; resolution<numResolution; resolution++)
   {
     f = mxGetCell(prhs[c], img*numResolution+resolution); 
     translatedTemplate[resolution] = mxGetPr(f);  
  } 
 c++; 
 MAX2score = mxGetPr(prhs[c++]);
 allFx =  mxGetPr(prhs[c++]);
 allFy =  mxGetPr(prhs[c++]);

 StoreShift(); 
 sizeTemplatexSubsample = floor((double)sizeTemplatex/subsample); 
 sizeTemplateySubsample = floor((double)sizeTemplatey/subsample); 
 for (resolution=0; resolution<numResolution; resolution++)
 {
 sizex = ROUND(allSizex[resolution]); 
 sizey = ROUND(allSizey[resolution]); 
 sizexSubsample = floor((double)sizex/subsample); 
 sizeySubsample = floor((double)sizey/subsample); 
 ComputeSUM2map(resolution);   
 ComputeMAX2score(resolution);  
 }
 free_matrix(xShift, numOrient, numShift); 
 free_matrix(yShift, numOrient, numShift); 
 free_matrix(orientShifted, numOrient, numShift);
}

     



 

                    