#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"
#include "hole-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,j,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  FILE *errfp;
  DIGGED_HOLES holes_digged;
  IMAGEFLOAT   all_lambdas;
  double  total_var;
  all_lambdas.nrow = 0;
  holes_digged.nhole = 0;
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  /*
    DisplayParameter(&para_setting);
  */
  srand(para_setting.seed);

  fbank.nfilter = 0;
  
  imageDataBase.nimages =0;
  imageDataBase.num_ref_model =0;
  Read_Filters(para_setting.filterFile, &fbank);
  

  Create_An_Image_Float((int)(para_setting.lambdaIter+3),
			fbank.totalBin, 
			&all_lambdas);
  /* Force not to save Histogram data */
  para_setting.saveHistogram = 0;
  /*
    strcat(para_setting.prefix,"_var_holes");
  */
  sprintf(fname,"%s_lambdas_all.dat", para_setting.prefix);

  if (Read_Multi_Lambdas_Into_Image(fname,
				    &fbank,
				    &all_lambdas,
				    para_setting.lambdaIter) != 
      (fbank.totalBin*para_setting.lambdaIter)) {
    return -1;
  }
  
  k = 0;
  if (para_setting.truelambdaFile[0] != '\0') {
    if (Read_Lambdas_Into_Vector(para_setting.truelambdaFile,
                                 &fbank,
                                 all_lambdas.data[para_setting.lambdaIter]) 
	== fbank.totalBin) {
      k = 1;
    }
  }
  if (k != 1) {
    printf("Cannot load true lambdas from file '%s'.\n",
	   para_setting.truelambdaFile);
    Free_Image_Float(&all_lambdas);
    Free_Filter_Bank(&fbank);
    
    return (-1);
  }
  
  for (i=0; i < all_lambdas.ncol; i++) {
    all_lambdas.data[para_setting.lambdaIter+1][i] = 0.0;
    all_lambdas.data[para_setting.lambdaIter+2][i] = 0.0;
  }
  
  total_err = 0.0;
  for (k=0; k < para_setting.lambdaIter; k++) {
    for (i=0; i < all_lambdas.ncol; i++) {
      all_lambdas.data[para_setting.lambdaIter+2][i] +=
	all_lambdas.data[k][i];
    }
  }
  for (i=0; i < all_lambdas.ncol; i++) {
    all_lambdas.data[para_setting.lambdaIter+2][i] /= 
      (float)para_setting.lambdaIter;
    total_err += fabs(all_lambdas.data[para_setting.lambdaIter+2][i] - 
		      all_lambdas.data[para_setting.lambdaIter][i]); 
  }
  total_err /= (float)(all_lambdas.ncol);
  
  total_var = 0.0;
  for (k=0; k < para_setting.lambdaIter; k++) {
    for (i=0; i < all_lambdas.ncol; i++) {
      all_lambdas.data[para_setting.lambdaIter+1][i] +=
	(all_lambdas.data[k][i]-all_lambdas.data[para_setting.lambdaIter][i]) *
	(all_lambdas.data[k][i]-all_lambdas.data[para_setting.lambdaIter][i]);
      total_var += all_lambdas.data[para_setting.lambdaIter+1][i];
    }
  }
 
  total_var /=  (float)(para_setting.lambdaIter*all_lambdas.ncol);
  
  printf("Average bias of the estimated lambdas is %12.10lf\n",
	 total_err);
  printf("Variance of estimated lambdas is %12.10lf\n", total_var);
  
  sprintf(fname,"%s_from_true.dat", para_setting.prefix);
  errfp = fopen(fname,"ab");
  fprintf(errfp,"Total iteration: %d vector length %d\n",
	  para_setting.lambdaIter, all_lambdas.ncol);
  fprintf(errfp,"Average bias of the estimated lambdas is %12.10lf\n",
	  total_err);
  fprintf(errfp,"Variance of estimated lambdas is %12.10lf\n", total_var);
  
  fclose(errfp);
  
  Free_Image_Float(&all_lambdas);
  Free_Filter_Bank(&fbank);
  
  return 0;
}














