#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"
#include "hist-util.h"
#include "filter-util.h"


int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,k;
  CONTROL_INFO  para_setting;
  FILTERBANK  fbank;
  IMAGEINT   obs_img, syn_img;
  float  total_err, max_err, weighted_err;
  float total_err_sum;
  int   total_err_times;
  FILE *errfp;
  ONE_HOLE center_patch;
  
  obs_img.nrow = 0;
  syn_img.nrow = 0;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;

  imageDataBase.nimages =0;
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  Initialize_Obs(&fbank, &obs_img,
		 &para_setting,
		 &imageDataBase);
  sprintf(fname,"%s_obs.pgm", para_setting.prefix);
  Write_An_Image_Int(&obs_img, (int)(256/para_setting.greyLevel),
		     fname);
  Initialize_Syn(&fbank, &syn_img, &para_setting);
  /* We borrow the target hist to save the histogram of the 
     entire image */
  for (k=0; k < fbank.nfilter; k++) {
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      fbank.fbank[k].target_hist[i] = 
	fbank.fbank[k].hist[i];
    }
  }
 
  /* The center patch in the image */
  center_patch.hole_size = para_setting.hole_size;
  if ( (center_patch.hole_size >= syn_img.nrow) ||
       (center_patch.hole_size >= syn_img.ncol) ) {
    printf("The size (%d) of the central patch is too large ",
	   center_patch.hole_size);
    printf("for the synthesized image (%d,%d).\n",
	   syn_img.ncol,
	   syn_img.nrow);
    exit(-1);
  }
  center_patch.row = (syn_img.nrow-para_setting.hole_size)/2+1;
  center_patch.col = (syn_img.ncol-para_setting.hole_size)/2+1;
  
  if (Read_Lambdas(para_setting.truelambdaFile,&fbank) <0) {
    fprintf(stderr,"Error when reading from lambda file '%s'.\n",
	    para_setting.lambdaFile);
    exit(-1);
  }
  
  Generate_Hist_From_Map_Hole(&fbank, &center_patch);
  for (k=0; k < fbank.nfilter; k++) {
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      fbank.fbank[k].target_hist[i] -= 
	fbank.fbank[k].hist[i];
    }
  }
  
  /* Normalize histogram to 1 */
  for (k=0; k < fbank.nfilter; k++) {
    total_err_sum = 0.0;
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      total_err_sum += fbank.fbank[k].target_hist[i];
    }
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      fbank.fbank[k].target_hist[i] /= total_err_sum;
    }
  }
  
  for (k=0; k < fbank.nfilter; k++) {
    total_err_sum = 0.0;
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      total_err_sum += fbank.fbank[k].hist[i];
    }
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      fbank.fbank[k].hist[i] /= total_err_sum;
    }
  }
  total_err_sum = 0.0;
  
  for (k=0; k < fbank.nfilter; k++) {
    printf("Filter %2d ", k);
    max_err= 0.0;
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      if (fbank.fbank[k].target_hist[i] > 0.0000001) 
	max_err += fbank.fbank[k].hist[i] *
	  log(fbank.fbank[k].hist[i]/fbank.fbank[k].target_hist[i]);
    }
    printf("D(F||B) = %10.6f\n",  max_err);
    total_err_sum += max_err;
    printf("F->\t");
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      printf("%6.4f ", fbank.fbank[k].hist[i]);
    }
    printf("\n");
    printf("B->\t");
    for (i=0; i < fbank.fbank[k].bin_num; i++) {
      printf("%6.4f ", fbank.fbank[k].target_hist[i]);
    }
    printf("\n");
  }
  printf("Total D(F||B) = %12.10f\n",total_err_sum);
  
  Free_Image_Int(&obs_img);
  Free_Image_Int(&syn_img);
  Free_Filter_Bank(&fbank);
  Free_Database(&imageDataBase);
  return 0;
}














