#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "type-def.h"
#include "util.h"
#include "kernel.h"
#include "imageio.h"
#include "smoothing.h"
#include "para-util.h"

int main(int argc, char **argv)
{
  char paraFile[256];
  IMAGEINT obsImg;
  IMAGE_DATABASE imageDataBase;
  int windex, upindex;
  int wsize;
  char prefix[256];
  char fname[256];
  int i,k;
  CONTROL_INFO  para_setting;
  
  FILTERBANK  fbank;
  if (argc < 1) {
    printf("Please specify the parameter file: ");
    scanf("%s", paraFile);
  }
  else {
    strcpy(paraFile, argv[1]);
  }
  
  LoadParameter(paraFile, &para_setting);
  DisplayParameter(&para_setting);
  
  srand(para_setting.seed);

  fbank.nfilter = 0;
  obsImg.nrow = 0;
  imageDataBase.nimages =0;
  Read_An_Image_Int(para_setting.inputFile, &obsImg);
  Read_Filters(para_setting.filterFile, &fbank);
  
  
  /* Check values here */
  if (para_setting.topWin >= fbank.nlevel)
    para_setting.topWin = fbank.nlevel-1;
  if (para_setting.segWin > para_setting.topWin) {
    para_setting.segWin = para_setting.topWin;
  }
  
  if (Load_Database(para_setting.databaseFile, &fbank,
		    &imageDataBase) != 0) {
    Create_Database(&para_setting, &fbank,
		    &imageDataBase);
    Save_Database(para_setting.databaseFile, &fbank,
		  &imageDataBase);
  }
  
  Homogeous_Layer_Test_Before(&fbank, &obsImg, &para_setting,
			      &imageDataBase);
  Free_Filter_Bank(&fbank);
  Free_Image_Int(&obsImg);
  Free_Database(&imageDataBase);
  return 0;
}








