#define  FEATURE_EXTRACT_SOURCE_C_C

#include "feature_extract.h"
#if !defined(DELTA)
# define DELTA 1e-9
#endif

/***********************************************************
							    
   Compute histogram of a local window

********************************************************/

/* Neighborhood system */
POINT2D Neighbor_Table[] = {
  {0,1},   /* 0 */
 
  {1,0},   /* 2 */

  {1,1},   /* 1 */

  {1,-1},  /* 3 */

  {0,-1},  /* 4 */
  {-1,-1}, /* 5 */
  {-1,0},  /* 6 */
  {-1,+1}, /* 7 */
  {0,0}    /* 8 */
};



void Homogeous_Between_Test_Before(FILTERBANK *ffamily,
				   IMAGEINT *animage)
{
  int k;
  float *histTmp[2];
  float diverge;
  int row[2], col[2];
  int windex;
  float *tmpRes;
  
  tmpRes = (float *)malloc(sizeof(float)*ffamily->nfilter);
  for (k=0; k<2; k++) 
    histTmp[k] = (float *)malloc(sizeof(float)*ffamily->totalBin);
  do {
    printf("Please specify the window level (1->%d): ",
	   ffamily->nlevel);
    scanf("%d", &windex);
    if (windex < 1 || windex > ffamily->nlevel) break;
    windex--;
    printf("Please input two pixels (col, row): ");
    for (k=0; k<2; k++) {
      scanf("%d%d", &(col[k]), &(row[k]));
      Compute_Local_Window_Hist(row[k],col[k],windex,
				ffamily, animage, histTmp[k]);
      Print_Pixel_Feature_Vector(row[k], col[k],  histTmp[k], 
				 ffamily, windex);
    }
    diverge = 0.0;
   
    for (k=0; k < ffamily->nfilter; k++) {
      tmpRes[k] = Calc_Hist_Divergence_AFilter(&(histTmp[0][0]),
					 &(histTmp[1][0]),
					 k,
					 ffamily);
      
      diverge += tmpRes[k];
    }
    printf("Divergence for each filter: ");
    for (k=0; k < ffamily->nfilter; k++) {
      printf("%8.6f ", tmpRes[k]);
    }
    printf("Total: %8.6f\n", diverge);
    diverge = 0.0;
    for (k=0; k < ffamily->nfilter; k++) {
      tmpRes[k] = Calc_Hist_Chi_AFilter(&(histTmp[0][0]),
					&(histTmp[1][0]),
					k,
					ffamily);
      
      diverge += tmpRes[k];
    }
    printf("Chi Distance for each filter: ");
    for (k=0; k < ffamily->nfilter; k++) {
      printf("%8.6f ", tmpRes[k]);
    }
    printf("Total: %8.6f\n", diverge);
    
    printf("Total divergence and chi dist between (%d,%d) and (%d,%d) ",
	   col[0], row[0], col[1], row[1]);
    printf("at level %d (%d x %d) is ", windex+1,
	   ffamily->winLevels[windex].x*2+1,
	   ffamily->winLevels[windex].y*2+1);
    
    diverge = Calc_Hist_Divergence(&(histTmp[0][0]),
				   &(histTmp[1][0]),
				   ffamily->totalBin);
    printf("%8.6f and %8.6f.\n", diverge,
	   Calc_Hist_Chi(&(histTmp[1][0]),
			 &(histTmp[0][0]),
			 ffamily->totalBin));
  } while(1);
  for (k=0; k<2; k++)
    free(histTmp[k]);
  return;
}



void Homogeous_Layer_Test_Before(FILTERBANK *ffamily,
				 IMAGEINT *animage,
				 CONTROL_INFO *controlInfo,
				 IMAGE_DATABASE *adatabase)
{
  float *histmp;
  int k,i,j,index,k1;
  float *distMeasure;
  int *similarityOrder;
  IMAGEFLOAT distImg;
  char       fname[256];
  FILE *fp;
  float tmp;
  float tmprow;
  float tmpmin;
  
  if (controlInfo->npoint == 0) {
    Homogeous_Layer_Test_Before_Image(ffamily,animage,
				      controlInfo,
				      adatabase);
    return;

  }


  distMeasure = (float *)malloc(sizeof(float)*adatabase->nimages);
  similarityOrder = (int *)malloc(sizeof(int)*adatabase->nimages);
  histmp = (float *)malloc(sizeof(float)*ffamily->totalBin);
  for (k=0; k < adatabase->nimages; k++) {
    similarityOrder[k] = k;
  }

  for (k=0; k < controlInfo->npoint; k++) {
    Compute_Local_Window_Hist(controlInfo->seedPoints[k].y,
			      controlInfo->seedPoints[k].x,
			      controlInfo->segWin,
			      ffamily, animage, histmp);
    for (i=0; i < adatabase->nimages; i++) {
      distMeasure[i] = Calc_Hist_Divergence(histmp,
					    adatabase->entries[i].fvector,
					    ffamily->totalBin);
    }
    
    do {
      i =0;
      for (j=1; j < adatabase->nimages; j++) {
	if (distMeasure[similarityOrder[j]] < 
	    distMeasure[similarityOrder[j-1]]) {
	  i = similarityOrder[j];
	  similarityOrder[j] = similarityOrder[j-1];
	  similarityOrder[j-1] = i;
	  i = 1;
	}
      }
    } while(i);
    i = 5;
    if (i > adatabase->nimages) i = adatabase->nimages;
    printf("At pixel (%d, %d), the top %d texture classes are \n",
	   controlInfo->seedPoints[k].x, 
	   controlInfo->seedPoints[k].y, i);
    for (j=0; j < i; j++) {
      index = similarityOrder[j];
      printf("\t%d -> divergence = %8.6f Class = %s \n",
	     j+1, distMeasure[index], 
	     adatabase->entries[index].typename);
      printf("\t\tfile name = %s\n", 
	     adatabase->entries[index].fname);
    }
  }
  distImg.nrow = 0;
  Create_An_Image_Float(adatabase->nimages, adatabase->nimages,
			&distImg);
  for (k=0; k < adatabase->nimages; k++) {
    for (i=0; i < adatabase->nimages; i++) {
      distImg.data[k][i]  = Calc_Hist_Divergence(adatabase->entries[k].fvector,
						 adatabase->entries[i].fvector,
						 ffamily->totalBin);
    }
  }
  sprintf(fname,"%s_dat_dist.pgm", controlInfo->prefix);
  fp = fopen(fname,"wb");
  tmp = 0.0;
  tmprow = 0.;
  tmpmin = 1.0;
  
  for (i=0; i < distImg.nrow; i++) {
    tmp = 0.0;
    for (j=0; j < distImg.ncol; j++) {
      if (i!=j) {
	if (tmpmin > distImg.data[i][j]) {
	  tmpmin = distImg.data[i][j];
	  k = i;
	}
      }
      if (distImg.data[i][j] < 1.0)
	tmp += 1.0;
      k1 = (int)(distImg.data[i][j]*10+0.5);
      if (k1 < 10) {
	fprintf(fp,".%d", k1);
      }
      else {
	k1 = (int)(distImg.data[i][j]+0.5);
	if (k1 < 10) {
	  fprintf(fp,"\\ %d", k1);
	}
	else {
	  fprintf(fp,"%d", k1);
	}
      }
      if (j<(distImg.ncol-1)) fprintf(fp,"\\hspace{0.05in}");
    }
    
    if (tmprow < tmp) {
      tmprow = tmp;
      /*k = i; */
    }
    
    fprintf(fp,"\n\n");
  }
  fclose(fp);
  printf("Min Maximum number: %f at row %d\n", tmpmin, k);
  for (j=0; j < distImg.ncol; j++) {
    printf("%8.6f ", distImg.data[k][j]);
  }
  printf("\n");
  
  
  sprintf(fname,"%s_cross_dist.pgm", controlInfo->prefix);
  Write_An_Image_Float(&distImg, fname);
  Free_Image_Float(&distImg);
  free(distMeasure);
  free(similarityOrder);
  free(histmp);
  return;
}

void Homogeous_Layer_Test_Before_Image(FILTERBANK *ffamily,
				 IMAGEINT *animage,
				 CONTROL_INFO *controlInfo,
				 IMAGE_DATABASE *adatabase)
{
  float *histmp;
  int k,i,j,index, k1, k2;
  float *distMeasure;
  int *similarityOrder;
  IMAGEINT labelImg;
  IMAGEFLOAT distImg;
  char fname[256];
  int wsize_x, wsize_y;
  int i1, j1;
  
  labelImg.nrow = 0;
  distImg.nrow = 0;
  Create_An_Image_Int(animage->nrow, animage->ncol,
			&labelImg);
  Create_An_Image_Float(animage->nrow, animage->ncol,
			&distImg);
  wsize_x = ffamily->winLevels[controlInfo->segWin].x;
  wsize_y = ffamily->winLevels[controlInfo->segWin].y;
  distMeasure = (float *)malloc(sizeof(float)*adatabase->nimages);
  similarityOrder = (int *)malloc(sizeof(int)*adatabase->nimages);
  histmp = (float *)malloc(sizeof(float)*ffamily->totalBin);
  for (k=0; k < adatabase->nimages; k++) {
    similarityOrder[k] = k;
  }
  for (k1=0; k1 < animage->nrow; k1++) {
    i1 = k1;
    if (i1 <  wsize_y) i1 =  wsize_y;
    else {
      if (i1 >= (animage->nrow-wsize_y))
	i1 = animage->nrow-wsize_y-1;
    }
    for (k2=0; k2 < animage->ncol; k2++) {
      j1 = k2;
      if (j1 < wsize_x ) j1 = wsize_x;
      else {
	if (j1 >= (animage->ncol-wsize_x))
	  j1 = animage->ncol-wsize_x-1;
      }
      Compute_Local_Window_Hist(i1,
				j1,
				controlInfo->segWin,
				ffamily, animage, histmp);
      for (i=0; i < adatabase->nimages; i++) {
	distMeasure[i] = Calc_Hist_Divergence(histmp,
					      adatabase->entries[i].fvector,
					      ffamily->totalBin);
      }
      
      do {
	i =0;
	for (j=1; j < adatabase->nimages; j++) {
	  if (distMeasure[similarityOrder[j]] < 
	      distMeasure[similarityOrder[j-1]]) {
	    i = similarityOrder[j];
	    similarityOrder[j] = similarityOrder[j-1];
	    similarityOrder[j-1] = i;
	    i = 1;
	  }
	}
      } while(i);
      i = 2;
      if (i > adatabase->nimages) i = adatabase->nimages;
      printf("At pixel (%d, %d), the top %d texture classes are \n",
	     k2, 
	     k1, i);
      index = similarityOrder[0];
      labelImg.data[k1][k2] = index;
      distImg.data[k1][k2] = distMeasure[index];
      for (j=0; j < i; j++) {
	index = similarityOrder[j];
	printf("\t%d -> divergence = %8.6f Class = %s \n",
	       j+1, distMeasure[index], 
	       adatabase->entries[index].typename);
	printf("\t\tfile name = %s\n", 
	       adatabase->entries[index].fname);
      }
    }
  }
  
  
  sprintf(fname,"%s_Label.pgm", controlInfo->prefix);
  Write_An_Image_Int(&labelImg, (int)(256/adatabase->nimages),
		     fname);
  
  sprintf(fname,"%s_Div.pgm", controlInfo->prefix);
  Write_An_Image_Float(&distImg, fname);
  Free_Image_Int(&labelImg);
  Free_Image_Float(&distImg);
  free(distMeasure);
  free(similarityOrder);
  free(histmp);
  return;
}

void Homogeous_Layer_Test_Before_Db(FILTERBANK *ffamily,
				    CONTROL_INFO *controlInfo,
				    IMAGE_DATABASE *adatabase)
{
  float *histmp;
  int k,i,j,index, k1, k2;
  float *distMeasure;
  int *errLabel;
  IMAGEINT animage;
  IMAGEINT labelImg;
  IMAGEFLOAT distImg;
  char fname[256];
  int wsize_x, wsize_y;
  int i1, j1;
  int totalerrLabel;
  int row_num, col_num;
  int *labelStat;
  int npatches;
  labelImg.nrow = 0;
  distImg.nrow = 0;
  animage.nrow = 0;
  if (controlInfo->nInput != adatabase->nimages) {
    printf("Images in the database %d is different from the parameter %d.\n",
	   adatabase->nimages, controlInfo->nInput);
    return;
  }

  wsize_x = ffamily->winLevels[controlInfo->segWin].x;
  wsize_y = ffamily->winLevels[controlInfo->segWin].y;
  errLabel = (int *)malloc(sizeof(int)*adatabase->nimages);
  distMeasure = (float *)malloc(sizeof(float)*adatabase->nimages);
  labelStat = (int *)malloc(sizeof(int)*adatabase->nimages);
  histmp = (float *)malloc(sizeof(float)*ffamily->totalBin);

  Read_An_Image_Int(controlInfo->inputFiles[0], &animage);
  row_num = adatabase->nimages;
  col_num = (animage.nrow / (2*wsize_y+1)) * (animage.ncol / (2*wsize_x+1));
  Create_An_Image_Int(row_num, col_num, &labelImg);
  Create_An_Image_Float(row_num, col_num, &distImg);
  
  for (k=0; k < adatabase->nimages; k++) {
    i1 = 0;
    npatches = 0;
    Read_An_Image_Int(controlInfo->inputFiles[k], &animage);
    errLabel[k] = 0;
    printf("Image %d/%d-> ", k,adatabase->nimages);
    fflush(stdout);
    for (k1=wsize_y; k1<(animage.nrow-wsize_y); k1+=(wsize_y*2+1)) {
      for (k2=wsize_x; k2 < (animage.ncol-wsize_x); k2+=(wsize_x*2+1)) {
	if (npatches %3 ) {
	  printf("%d ", i1);
	  fflush(stdout);
	  Compute_Local_Window_Hist(k1,
				    k2,
				    controlInfo->segWin,
				    ffamily, &animage, histmp);
	  index = 0;
	  for (i=0; i < adatabase->nimages; i++) {
	    distMeasure[i] = 
	      Calc_Hist_Divergence(histmp,
				   adatabase->entries[i].fvector,
				   ffamily->totalBin);
	    if (distMeasure[index] > distMeasure[i]) {
	      index = i;
	    }
	  }
	  errLabel[k] += (index != k);
	  labelImg.data[k][i1] = index;
	  distImg.data[k][i1] = distMeasure[index];
	  i1 ++;
	}
	npatches++;
      }
    }
    printf("Done with error labels= %d/%d\n", errLabel[k], i1);
    /*if (i1 != col_num ) {
      printf("For image %d, the size %d is not equal to %d.\n",
	     i1, col_num);
    }
    */
  }
  
  
  sprintf(fname,"%s_DB_Label.pgm", controlInfo->prefix);
  Write_An_Image_Int(&labelImg, (int)(256/adatabase->nimages),
		     fname);
  sprintf(fname,"%s_DB_Div.pgm", controlInfo->prefix);
  Write_An_Image_Float(&distImg, fname);
  totalerrLabel = 0;
  for (k=0; k < adatabase->nimages; k++) {
    printf("Image %d: err %d %s\n", k, errLabel[k], 
	   controlInfo->inputFiles[k]);
    totalerrLabel += errLabel[k];
  }
  printf("Error labels: ");
  for (k=0; k < adatabase->nimages; k++) {
    printf("%d ", errLabel[k]);
  }
  printf("\n");
  printf("Total error label: %d rate: = %6.4f %%\n",totalerrLabel,
	 (totalerrLabel*100.)/((float)(col_num*adatabase->nimages)));
  do {
    printf("Check an image: ");
    scanf("%d", &k);
    if (k <0 || k >= adatabase->nimages) break;
    printf("Image %d, err labels = %d err rate = %6.4f %% name=%s\n",
	   k, errLabel[k], ((float)errLabel[k])/((float)col_num),
	   controlInfo->inputFiles[k]);
    for (k1=0; k1 < adatabase->nimages; k1++) {
      labelStat[k1] = 0;
      distMeasure[k1] = 0;
    }
    for (k1=0; k1 < col_num; k1++) {
      printf("%4d ",  labelImg.data[k][k1]);
      labelStat[labelImg.data[k][k1]] ++;
      distMeasure[labelImg.data[k][k1]] += distImg.data[k][k1];
    }
    printf("\n");
    for (k1=0; k1 < col_num; k1++) {
      printf("%4.1f ",  distImg.data[k][k1]);
    }
    printf("\n");
    for (k1=0; k1 < adatabase->nimages; k1++) {
      if (labelStat[k1] > 0) {
	printf("\tLabel %d -> occurence = %d avr div = %6.4f\n",
	       k1, labelStat[k1],
	       distMeasure[k1]/((float)labelStat[k1]));
      }
    }
  } while(1);
  Free_Image_Int(&labelImg);
  Free_Image_Float(&distImg);
  free(distMeasure);
  free(errLabel);
  free(labelStat);
  
  Free_Image_Int(&animage);
  free(histmp);
  return;
}

void Homogeous_Layer_Test_Before_Var(FILTERBANK *ffamily,
				     CONTROL_INFO *controlInfo,
				     IMAGE_DATABASE *adatabase)
{
  float **histmp;
  float *avghtmp;
  
  int k,i,j,index, k1, k2;
  float *varMeasure;
  float *featuredivMeasure;
  IMAGEINT animage;
  float tmp;
  int wsize_x, wsize_y;
  int i1, j1;
  int row_num, col_num;
  int npatches;
  animage.nrow = 0;
  
  wsize_x = ffamily->winLevels[controlInfo->segWin].x;
  wsize_y = ffamily->winLevels[controlInfo->segWin].y;
  
  varMeasure = (float *)malloc(sizeof(float)*controlInfo->nInput);
  featuredivMeasure = (float *)malloc(sizeof(float)*controlInfo->nInput);
  Read_An_Image_Int(controlInfo->inputFiles[0], &animage);
  row_num = controlInfo->nInput;
  col_num = (animage.nrow / (2*wsize_y+1)) * (animage.ncol / (2*wsize_x+1));
  histmp = (float **)malloc(sizeof(float *)*col_num);
  for (k=0; k < col_num; k++) {
    histmp[k] = (float *)malloc(sizeof(float)*ffamily->totalBin);
  }
  avghtmp = (float *)malloc(sizeof(float)*ffamily->totalBin);
  
  for (k=0; k < controlInfo->nInput; k++) {
    i1 = 0;
    npatches =0;
    Read_An_Image_Int(controlInfo->inputFiles[k], &animage);
    printf("Image %d/%d-> ", k,controlInfo->nInput);
    fflush(stdout);
    for (k1=wsize_y; k1<(animage.nrow-wsize_y); k1+=(wsize_y*2+1)) {
      for (k2=wsize_x; k2 < (animage.ncol-wsize_x); k2+=(wsize_x*2+1)) {
	if (npatches %2==0) {
	  if (i1 < 5 || i1 >(col_num-5))
	    printf("%d ", i1);
	  if (i1==10) printf("... ");
	  fflush(stdout);
	  Compute_Local_Window_Hist(k1,
				    k2,
				    controlInfo->segWin,
				    ffamily, &animage, histmp[i1]);
	  i1++;
	}
	npatches++;
      }
    }
    if (col_num != i1) {
      col_num = i1;
    }
    for (j=0; j < ffamily->totalBin; j++)
      avghtmp[j] = 0.0;
    for (i=0; i < col_num; i++) {
      for (j=0; j < ffamily->totalBin; j++)
	avghtmp[j] += histmp[i][j];
    }
    for (j=0; j < ffamily->totalBin; j++)
      avghtmp[j] /= (float)col_num;
    varMeasure[k] = 0.0;
    for (i=0; i < col_num; i++) {
      for (j=0; j < ffamily->totalBin; j++) {
	varMeasure[k] += (histmp[i][j]-avghtmp[j])*
	  (histmp[i][j]-avghtmp[j]);
      }
    }
    varMeasure[k] = sqrtf(varMeasure[k]/(float)col_num);
    featuredivMeasure[k] = 0.;
    for (i=0; i < col_num; i++) {
      tmp = Calc_Hist_Divergence(histmp[i],
				 adatabase->entries[k].fvector,
				 ffamily->totalBin);
      if (featuredivMeasure[k] < tmp)
	featuredivMeasure[k] = tmp;
    }
    printf("Done with variance: %8.6f and maximum div: %8.6f",
	   varMeasure[k], featuredivMeasure[k]);
    printf(" with %d entries\n",  i1);
  }
  
  for (k=0; k < controlInfo->nInput; k++) {
    printf("Image %d: var: %8.6f max-div: %8.6f name: %s\n", k, 
	   varMeasure[k],
	   featuredivMeasure[k],
	   controlInfo->inputFiles[k]);
  }
  for (k=0; k < controlInfo->nInput; k++) {
    printf("%8.6f ", varMeasure[k]);
  }
  printf("\n");
  for (k=0; k < controlInfo->nInput; k++) {
    printf("%8.6f ", featuredivMeasure[k]);
  }
  printf("\n");
  free(varMeasure);
  free(featuredivMeasure);
  free(avghtmp);
  Free_Image_Int(&animage);
  for (i=0; i < col_num; i++) 
    free(histmp[i]);
  free(histmp);
  return;
}


void Homogeous_Layer_Test_Before_Cross(FILTERBANK *ffamily,
				       CONTROL_INFO *controlInfo,
				       IMAGE_DATABASE *adatabase)
{
  float *histmp;
  int k,i,j,index,k1;
  float *distMeasure;
  int   *closeClass;
  int *similarityOrder;
  IMAGEFLOAT distImg;
  char       fname[256];
  FILE *fp;
  float tmp;
  float tmprow;
  float tmpmin;
 

  distMeasure = (float *)malloc(sizeof(float)*adatabase->nimages);
  similarityOrder = (int *)malloc(sizeof(int)*adatabase->nimages);
  closeClass = (int *)malloc(sizeof(int)*adatabase->nimages);
  histmp = (float *)malloc(sizeof(float)*ffamily->totalBin);
  for (k=0; k < adatabase->nimages; k++) {
    similarityOrder[k] = k;
  }
  
  distImg.nrow = 0;
  Create_An_Image_Float(adatabase->nimages, adatabase->nimages,
			&distImg);
  for (k=0; k < adatabase->nimages; k++) {
    for (i=0; i < adatabase->nimages; i++) {
      distImg.data[k][i]  = Calc_Hist_Divergence(adatabase->entries[k].fvector,
						 adatabase->entries[i].fvector,
						 ffamily->totalBin);
    }
  }
  sprintf(fname,"%s_dat_dist.pgm", controlInfo->prefix);
  fp = fopen(fname,"wb");
  tmp = 0.0;
  tmprow = 0.;
  tmpmin = 1.0;
  
  for (i=0; i < distImg.nrow; i++) {
    tmp = 0.0;
    closeClass[i] = (i==0); 
    for (j=0; j < distImg.ncol; j++) {
      if (i!=j) {
	if (distImg.data[i][closeClass[i]] > distImg.data[i][j])
	  closeClass[i] = j;
	if (tmpmin > distImg.data[i][j]) {
	  tmpmin = distImg.data[i][j];
	  k = i;
	}
      }
      if (distImg.data[i][j] < 1.0)
	tmp += 1.0;
      k1 = (int)(distImg.data[i][j]*10+0.5);
      if (k1 < 10) {
	fprintf(fp,".%d", k1);
      }
      else {
	k1 = (int)(distImg.data[i][j]+0.5);
	if (k1 < 10) {
	  fprintf(fp,"\\ %d", k1);
	}
	else {
	  fprintf(fp,"%d", k1);
	}
      }
      if (j<(distImg.ncol-1)) fprintf(fp,"\\hspace{0.05in}");
    }
    
    if (tmprow < tmp) {
      tmprow = tmp;
      /*k = i; */
    }
    
    fprintf(fp,"\n\n");
  }
  fclose(fp);
  printf("Min Maximum number: %f at row %d\n", tmpmin, k);
  for (j=0; j < distImg.ncol; j++) {
    printf("%8.6f ", distImg.data[k][j]);
  }
  
  printf("\nMin cross div: ");
  for (i=0; i < distImg.nrow; i++) {
    printf("%8.6f ", distImg.data[i][closeClass[i]]);
  }
  printf("\n");
  for (i=0; i < distImg.nrow; i++) {
    printf("%8d ", closeClass[i]);
  }
  printf("\n");
  
  
  sprintf(fname,"%s_cross_dist.pgm", controlInfo->prefix);
  Write_An_Image_Float(&distImg, fname);
  do {
    printf("Check a sub maxtrix: ");
    scanf("%d", &k);
    if (k <0 || k >adatabase->nimages) break;
    if (k < adatabase->nimages) {
      printf("Please enter %d index: ",k);
      for (i=0; i<k; i++)
	scanf("%d", &(similarityOrder[i]));
      fflush(stdin);
    }
    else {
      for (i=0; i<k; i++)
	similarityOrder[i] = i;
    }
    printf("    ");
    for (j=0; j < k; j++) {
      printf("  %2d   ", similarityOrder[j]);
    }
    printf("\n");
    for (i=0; i < k; i++) {
      printf("%2d  ", similarityOrder[i]); 
      for (j=0; j < k; j++) {
	printf("%6.3f ", 
	       distImg.data[similarityOrder[i]][similarityOrder[j]]);
      }
      printf("\n");
    }
  } while(1);
  
  Free_Image_Float(&distImg);
  free(distMeasure);
  free(closeClass);
  free(similarityOrder);
  free(histmp);
  return;
}

void Homogeous_Between_Test_After(int windex,
				  FILTERBANK *ffamily,
				  IMAGEINT *animage,
				  IMAGEVECTOR *featureImg)
{
  int k;
  float diverge;
  int row[2], col[2];
  int srow[2], scol[2];
  int max_row, max_col;
  max_row = animage->nrow-featureImg->wsize_y-1;
  max_col = animage->ncol-featureImg->wsize_x-1;
  printf("Performance pixel-pair similarity test.\n");
  do {
    printf("Please input two pixels (col: %d->%d, row: %d->%d): ",
	   featureImg->wsize_x, max_col,
	   featureImg->wsize_y, max_row);
    scanf("%d",&(col[0]));
    if (col[0] < featureImg->wsize_x || col[0] > max_col) {
      fflush(stdin);
      break;
    }
    scanf("%d",&(row[0]));
    if (row[0] < featureImg->wsize_y || row[0] > max_row) {
      fflush(stdin);
      break;
    }
    scanf("%d",&(col[1]));
    if (col[1] < featureImg->wsize_x || col[1] > max_col) {
      fflush(stdin);
      break;
    }
    scanf("%d",&(row[1]));
    if (row[1] < featureImg->wsize_y || row[1] > max_row) {
      fflush(stdin);
      break;
    }
    
    for (k=0; k<2; k++) {
      srow[k] = row[k]-featureImg->wsize_y;
      scol[k] = col[k]-featureImg->wsize_x;
      Print_Pixel_Feature_Vector(row[k], col[k],  
				 featureImg->data[srow[k]][scol[k]],
				 ffamily, windex);
    }
    printf("Divergence and Chi distance between (%d,%d) and (%d,%d) ",
	   col[0], row[0], col[1], row[1]);
    printf("at level %d (%d x %d) are ", windex+1,
	   ffamily->winLevels[windex].x*2+1,
	   ffamily->winLevels[windex].y*2+1);
    diverge = 
      Calc_Hist_Divergence(featureImg->data[srow[0]][scol[0]],
			   featureImg->data[srow[1]][scol[1]],
			   ffamily->totalBin);
    printf("%8.6f and %8.6f.\n", diverge,
	   Calc_Hist_Chi(featureImg->data[srow[0]][scol[0]],
			 featureImg->data[srow[1]][scol[1]],
			 ffamily->totalBin));
  } while(1);
  
  return;
}

void Print_Pixel_Feature_Vector(int row, int col, 
				float *hist,
				FILTERBANK *ffamily, 
				int windex)
{
  int startDim =0;
  int k,i;
  printf("Feature vector at pixel (%d,%d) ", col, row);
  printf("at level %d with size %d, %d.\n",
	 windex+1, 2*ffamily->winLevels[windex].x+1,
	 2*ffamily->winLevels[windex].y+1);
  for (k=0; k < ffamily->nfilter; k++) {
    printf("Filter %2d -> ", ffamily->fbank[k].id);
    for (i=0; i < ffamily->fbank[k].bin_num; i++) {
      printf("%8.6f ", hist[i+startDim]);
    }
    printf("\n");
    startDim += ffamily->fbank[k].bin_num;
  }
}


void Calc_Between_Layer_Div(int windex,
			    int upindex,
			    FILTERBANK *ffamily,
			    IMAGEINT *animage,
			    IMAGEFLOAT *layerDiv)
{
  
  float *histTmp[2];
  int i, j;
  int bound_x, bound_y;
 
  for (i=0; i<2; i++) 
    histTmp[i] = (float *)malloc(sizeof(float)*ffamily->totalBin);
  bound_x = ffamily->winLevels[upindex].x+
    ffamily->max_wid;
  bound_y = ffamily->winLevels[upindex].y+
    ffamily->max_ht;
  printf("Computing Divergence between level %d(%d,%d) ",
	 windex+1, ffamily->winLevels[windex].x*2+1,
	 ffamily->winLevels[windex].y*2+1);
  printf("and %d(%d,%d). \n", upindex+1,
	 ffamily->winLevels[upindex].x*2+1,
	 ffamily->winLevels[upindex].y*2+1);
  for (i = bound_y; i < (animage->nrow-bound_y); i++) {
    printf("%3d ",i);
    if ((i+1-bound_y)%18==0) printf("\n");
    else
      fflush(stdout);
    
    for (j=bound_x; j < (animage->ncol-bound_x); j++) {
      Compute_Local_Window_Hist_Inside(i,j, windex,
				       ffamily, animage,
				       histTmp[0]);
      Compute_Local_Window_Hist_Inside(i,j, upindex,
				       ffamily, animage,
				       histTmp[1]);
      layerDiv->data[i-bound_y][j-bound_x] =  
	Calc_Hist_Divergence(histTmp[0],
			     histTmp[1],
			     ffamily->totalBin);
      
    }
  }
  printf("\n");
  for (i=0; i<2; i++) 
    free(histTmp[i]);
  return;
}




void Check_Connection_After(int windex,
			    FILTERBANK *ffamily,
			    IMAGEINT *animage,
			    IMAGEVECTOR *featureImg)
{
  int k;
  float diverge[8];
  float chi[8];
  int row[2], col[2];
  int srow[2], scol[2];
  
  int max_row, max_col;
  max_row = animage->nrow - featureImg->wsize_y-1;
  max_col = animage->ncol - featureImg->wsize_x-1;
  printf("Performing lateral connection testing.\n");
  do {
    printf("Please input a pixel (col: %d->%d, row: %d->%d): ",
	   featureImg->wsize_x, max_col,
	   featureImg->wsize_y, max_row);
    scanf("%d",&(col[0]));
    if (col[0] < featureImg->wsize_x || col[0] > max_col) {
      fflush(stdin);
      break;
    }
    scanf("%d",&(row[0]));
    if (row[0] < featureImg->wsize_y || row[0] > max_row) {
      fflush(stdin);
      break;
    }
    srow[0] = row[0] - featureImg->wsize_y;
    scol[0] = col[0] - featureImg->wsize_x;
    Print_Pixel_Feature_Vector(row[0], col[0],  
			       featureImg->data[srow[0]][scol[0]],
			       ffamily, windex);
    for (k=0; k<8; k++) {
      col[1] = col[0] + Neighbor_Table[k].x;
      diverge[k] = -1;
      chi[k] = -1;
      if (col[1] < featureImg->wsize_x || col[1] > max_col) {
	continue;
      }
      row[1] = row[0] + Neighbor_Table[k].y;
      if (row[1] < featureImg->wsize_y || row[1] > max_row) {
	continue;
      }
      srow[1] = row[1] - featureImg->wsize_y;
      scol[1] = col[1] - featureImg->wsize_x;
      
      diverge[k] = Calc_Hist_Divergence(featureImg->data[srow[0]][scol[0]],
					featureImg->data[srow[1]][scol[1]],
					ffamily->totalBin);
      chi[k] = Calc_Hist_Chi(featureImg->data[srow[0]][scol[0]],
			     featureImg->data[srow[1]][scol[1]],
			     ffamily->totalBin);
    }
    printf("Divergence: "); 
    for (k=0; k<8; k++) {
      if (diverge[k] < -0.2) 
	printf("  ----   ");
      else
	printf("%8.6f ", diverge[k]);
    }
    printf("\nChi:        "); 
    for (k=0; k<8; k++) {
      if (chi[k] < -0.2) 
	printf("  ----   ");
      else
	printf("%8.6f ", chi[k]);
    }
    printf("\n");
  } while(1);
  
  return;
}




void Estimate_Region_Parameter(int row, int col, 
			      int segWin,
			      FILTERBANK *ffamily,
			      IMAGEINT *animage,
			      REGION_LABEL *alabel)
{ 
  float *histTmp;
  int i, j, k, k1,k2;
  int bound_x, bound_y;
  float *resHist;
  float tmp;
  float min, max;
  float unit;
  int bin_num;
  int index;
  int wsize;
  int peak, trough;
  float threshold;
  float regArea;

  alabel->segWin = segWin;
  alabel->segWsize = ffamily->winLevels[alabel->segWin].y;
  alabel->len = ffamily->totalBin;
  alabel->fvector = (float *)malloc(sizeof(float)*ffamily->totalBin);
  Create_An_Image_Float(animage->nrow, animage->ncol, 
			&(alabel->resImg));
  /* We can find the min/max from the image. Here we simply use
     reasonable values */
  min = 0.; max = 2.0; unit = SMOOTH_HIST_UNIT;
  bin_num = (max-min)/unit;
  resHist = (float *)malloc(sizeof(float)*bin_num);
  for (k=0; k< bin_num; k++)
    resHist[k] =0.0;
  
  bound_x = ffamily->winLevels[segWin].x;
  bound_y = ffamily->winLevels[segWin].y;
  
  wsize = (bound_y+1)/4;
  if (wsize < 1) wsize = 1;
  if (wsize > bound_y) wsize = bound_y;
  
  /* Rememver the size of the window */
  alabel->wsize = wsize;
  
  histTmp  = (float *)malloc(sizeof(float)*ffamily->totalBin);
  Compute_Local_Window_Hist(row,col, segWin,
			    ffamily, animage, 
			    alabel->fvector);
  
  
  for (i=0; i< alabel->resImg.nrow; i++) {
    for (j=0; j< alabel->resImg.ncol; j++) {
      alabel->resImg.data[i][j] = 2.0;
    }
  }
  alabel->bound_x = bound_x;
  alabel->bound_y = bound_y;
  printf("Estimating parameter for candidate label %d with ",
	 alabel->label);
  printf("Window level %d and size %d x %d\n",
	 segWin, bound_x*2+1, bound_y*2+1);
  
  for (i=bound_y; i < (animage->nrow-bound_y); i+= (2*wsize+1)) {
    printf("%d ", i);
    fflush(stdout);
    
    for (j=bound_x; j < (animage->ncol-bound_x); j+= (2*wsize+1)) {
      Compute_Local_Window_Hist(i,j,segWin,
				ffamily, animage, histTmp);
      tmp  = 
	Calc_Hist_Divergence(alabel->fvector, histTmp,
			     ffamily->totalBin);
      index = (int)((tmp-min)/unit);
      if (index < 0)
	index = 0;
      else {
	if (index >= bin_num)
	  index = bin_num-1;
      }
      resHist[index]++;
      
      for (k1=-wsize; k1<=wsize; k1++) {
	for (k2=-wsize; k2 <= wsize; k2++) {
	  alabel->resImg.data[i+k1][j+k2] = tmp;
	}
      }
      
    }
  }
  printf("Done.\n");
  
  printf("Resulting histogram:\n");
  for (k=0; k<bin_num; k++) {
    printf("%4.0f ", resHist[k]);
  }
  printf("\n");
  Smoothing_Hist(resHist, bin_num, (int)SMOOTH_HIST_SCALE);
  printf("Smoothed version of Resulting histogram:\n");
  for (k=0; k<bin_num; k++) {
    printf("%4.2f ", resHist[k]);
  }
  printf("\n");
  
  peak = 0;
  if (resHist[0] > resHist[1])
    peak = 0;
  else {
    for (k=1; k < (bin_num-1); k++) {
      if ( (resHist[k] > resHist[k-1]) && 
	   (resHist[k] > resHist[k+1]) ) {
	peak = k;
	break;
      }
    }
  }
  
  /* Peak value in the histogram */
  alabel->peakVal = ((float)peak*unit)+min;
 
  trough = peak+1;
  for (k=peak+1; k < (bin_num-1); k++) {
    if ( (resHist[k] <= resHist[k-1]) &&
	 (resHist[k] <= resHist[k+1])) {
      trough = k;
      break;
    }
  }
  
  
  alabel->threshold = ((float)trough*unit)+min;
  alabel->threshold = (alabel->peakVal+alabel->threshold)/2.;

  regArea = 0;
  for (k=0; k<= trough; k++) {
    regArea += resHist[k];
  }
  regArea *= (2*wsize+1) * (2*wsize+1);
  i = regArea/6;
  if (i < (animage->nrow * animage->ncol /50)) { /* At least 2 percent */
    i = animage->nrow * animage->ncol /50;
  }
  
  alabel->regThres = i;
  /* Create the probability hist model here */
  alabel->histLen = trough+1;
  alabel->histUnit = unit;
  alabel->probHist = Create_Array(alabel->histLen);
  tmp = 0.0;
  for (k=0; k < alabel->histLen; k++) {
    alabel->probHist[k] = resHist[k];
    tmp += alabel->probHist[k];
  }
  for (k=0; k < alabel->histLen; k++) {
    alabel->probHist[k] /= tmp;
  }
  
  alabel->refWin = 
    Find_Refine_Window(row, col,
		       ffamily,
		       animage,
		       segWin,
		       alabel->threshold);
  alabel->refWsize = ffamily->winLevels[alabel->refWin].y;
  alabel->refineVec = (float *)malloc(sizeof(float)*ffamily->totalBin);
  
  Compute_Local_Window_Hist(row,col, alabel->refWin,
			    ffamily, animage, 
			    alabel->refineVec);
  
  
  alabel->seed_row = row;
  alabel->seed_col = col;
  free(histTmp);
  free(resHist);
  return;
}

int Find_Refine_Window(int row, int col,
		       FILTERBANK *ffamily,
		       IMAGEINT *animage,
		       int segWin,
		       float segthresh)
{
  int i, k;
  float *histTmp[2];
  float threshold;
  int next;
  
  threshold = segthresh * 0.25;
  
  for (k=0; k < 2; k++) 
    histTmp[k] = (float *)malloc(sizeof(float)*ffamily->totalBin);
  
  Compute_Local_Window_Hist(row, col, segWin,
			    ffamily, animage, histTmp[0]);
  next = 1;
  for (i=segWin-1; i >=0; i--) {
    Compute_Local_Window_Hist(row,col, i,
			      ffamily, animage, histTmp[next]);
    if ( Calc_Hist_Divergence(histTmp[next],
			      histTmp[1-next],
			      ffamily->totalBin) > threshold) {
      break;
    }
    next = 1-next;
  }
  
  for (k=0; k< 2 ; k++)
    free(histTmp[k]);
  i = i+1;
  if (i > segWin) i = segWin;
  return i;
}

void Remove_Not_Calc_Points(REGION_LABEL *alabel)
{ 
  
  int i, j, k1,k2;
  IMAGEINT tmpImg;

  tmpImg.nrow = 0;
  Create_An_Image_Int(alabel->resImg.nrow, alabel->resImg.ncol,
		      &tmpImg);
  for (i=0; i < alabel->resImg.nrow; i++) {
    for (j=0; j < alabel->resImg.ncol; j++) {
      tmpImg.data[i][j] = 0;
    }
  }
  
  for (i=alabel->bound_y; i < (alabel->resImg.nrow-alabel->bound_y);
       i+= (2*alabel->wsize+1)) {
    for (j=alabel->bound_x; j < (alabel->resImg.ncol-alabel->bound_x); 
	 j+= (2*alabel->wsize+1)) {
      tmpImg.data[i][j] = 1;
    }
  }
  for (i=0; i < alabel->resImg.nrow; i++) {
    for (j=0; j < alabel->resImg.ncol; j++) {
      /*  if (tmpImg.data[i][j] == 0) */
      alabel->resImg.data[i][j]  =
	(float)(NOT_CALC_VALUE_DEFAULT+1.0);
    }
  }
  Free_Image_Int(&tmpImg);
  return;
}
  
int Find_Region_Seed_Pixels(IMAGEINT *animage,
			    FILTERBANK *ffamily,
			    CONTROL_INFO *controlInfo)
{
  int maxseedPixel;
  HOMO_GROUP  *seedPixels;
  int i, j, k;
  int bound_x, bound_y;
  float *histmp;
  int total_Candidate;
  int seg_bound_x, seg_bound_y;
  int center_x, center_y;
  float tmp;
  float K1, K2, K3;
  int nextLab;
  IMAGEINT inputImg;
  
  histmp = Create_Array(ffamily->totalBin);
  inputImg.nrow = 0;
  /* Estimate how many seed pixel points needed */
  maxseedPixel = 2;
  seedPixels = (HOMO_GROUP *)malloc(sizeof(HOMO_GROUP)*maxseedPixel);
  for (i=0; i < maxseedPixel; i++) {
    seedPixels[i].fvector = Create_Array(ffamily->totalBin);
  }
 
  bound_x = ffamily->winLevels[controlInfo->seedWin].x;
  bound_y = ffamily->winLevels[controlInfo->seedWin].y;
  seg_bound_x = ffamily->winLevels[controlInfo->segWin].x;
  seg_bound_y = ffamily->winLevels[controlInfo->segWin].y;
  
  total_Candidate = 0;
  seedPixels[0].total_dist = 1000.;
  printf("Identifying homogenous patch: ");
  for (i=bound_y; i <(animage->nrow-bound_y); i+= controlInfo->seedGrid) {
    for (j=bound_x; j <(animage->ncol-bound_x); j+=controlInfo->seedGrid) {
      printf("%d ", total_Candidate);
      fflush(stdout);
      Compute_Local_Window_Hist_Inside(i, j, controlInfo->segWin,
				       ffamily, animage,
				       seedPixels[1].fvector);
      Compute_Local_Window_Hist_Inside(i, j, controlInfo->seedWin,
				       ffamily, animage, 
				       histmp);
      seedPixels[1].btw_layerDist =
	Calc_Hist_Divergence(histmp,
			     seedPixels[1].fvector,
			     ffamily->totalBin);
      seedPixels[1].within_layerDist = -1.0;
      for (k=0; k<4; k++) {
	switch(k) {
	case 0:
	  center_x = j-bound_x+seg_bound_x;
	  center_y = i-bound_y+seg_bound_y;
	  break;
	case 1:
	  center_x = j-bound_x+seg_bound_x;
	  center_y = i+bound_y-seg_bound_y;
	  break;
	case 2:
	  center_x = j+bound_x-seg_bound_x;
	  center_y = i+bound_y-seg_bound_y;
	  break;
	case 3:
	  center_x = j+bound_x-seg_bound_x;
	  center_y = i-bound_y+seg_bound_y;
	  break;
	}
	Compute_Local_Window_Hist_Inside(center_y, center_x, 
					 controlInfo->segWin,
					 ffamily, animage,
					 histmp);
	tmp = Calc_Hist_Divergence(histmp,
				   seedPixels[1].fvector,
				   ffamily->totalBin);
	if (seedPixels[1].within_layerDist < tmp) {
	  seedPixels[1].within_layerDist = tmp;
	}
      }
      seedPixels[1].total_dist = (1.0-controlInfo->sameLayerWeight) *
	seedPixels[1].btw_layerDist +
	controlInfo->sameLayerWeight * seedPixels[1].within_layerDist;
      if (seedPixels[0].total_dist > seedPixels[1].total_dist) {
	seedPixels[0].row = i;
	seedPixels[0].col = j;
	seedPixels[0].btw_layerDist = seedPixels[1].btw_layerDist;
	seedPixels[0].within_layerDist = seedPixels[1].within_layerDist;
	seedPixels[0].total_dist = seedPixels[1].total_dist;
      }
      total_Candidate++;
    }
  }
  printf("DONE!\n");
  
  printf("The representative patch is ");
  printf(" at (%d,%d): btw layer: %8.6f within %8.6f ",
	 seedPixels[0].col,
	 seedPixels[0].row,
	 seedPixels[0].btw_layerDist, seedPixels[0].within_layerDist);
  printf("total %8.6f.\n", seedPixels[0].total_dist);
  
  for (k=0; k < controlInfo->nInput; k++) {
    printf("Trying %s ... ", controlInfo->inputFiles[k]);
    fflush(stdout);
    controlInfo->similarityMeasure[k] = 1000.;
    Read_An_Image_Int(controlInfo->inputFiles[k], &inputImg);
    for (i=bound_y; i <(animage->nrow-bound_y); i+= controlInfo->seedGrid) {
      for (j=bound_x; j <(animage->ncol-bound_x); j+=controlInfo->seedGrid) {
	Compute_Local_Window_Hist_Inside(i, j, controlInfo->segWin,
					 ffamily, animage,
					 histmp);
	tmp = Calc_Hist_Divergence(histmp,
				   seedPixels[0].fvector,
				   ffamily->totalBin);
	if (controlInfo->similarityMeasure[k] > tmp) {
	  controlInfo->similarityMeasure[k] = tmp;
	}
      }
    }
    printf("Done with similarity %8.6f\n", 
	   controlInfo->similarityMeasure[k]);
  }
  
  for (i=0; i < maxseedPixel; i++) {
    Free_Array(seedPixels[i].fvector); 
  }
  free(seedPixels);
  Free_Array(histmp);
  Free_Image_Int(&inputImg);
  return 0;
}





