/*******************************************************

   this file includes the filtering operators

********************************************************/
#define FILTER_UTIL_SOURCE_C_C
#include "filter-util.h"

void Update_Patch(FILTERBANK *ffamily, IMAGEINT *syn, 
		  int row, int col)
{
  ARRAY  patch, kernel;
  MAT    map;
  FILTER *filter;
  int  layer_no, filter_no;   
  int   height, width;
  float diff;
  int   i,j, val, old, mid, *pr, *pc;
  int   crow, ccol;
  
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++)  {
    filter=&(ffamily->fbank[filter_no]);
    if (filter->flag==0) continue;
    map=filter->map.data;
    kernel=filter->kernel;
    width=filter->wid; height=filter->ht;
    
    old=syn->data[row][col]; 
    mid=filter->size-1;
    
    if(row < height || row >= (syn->nrow-height) || 
       col < width || col >= (syn->ncol-width) ) {
      for(val= 0; val< ffamily->greyLevel; val++) { 
	patch= filter->patch[val];
	pr=filter->rlist; pc=filter->clist; 
	if(val==old) {  /* the current value, and just copy */
	  for(i=0; i<filter->size; i++) { 
	    crow = (row + (*pr) + syn->nrow*1000 ) % syn->nrow;
	    ccol = (col + (*pc) + syn->ncol*1000 ) % syn->ncol;
	    patch[i]=map[crow][ccol]; pr++; pc++;
	  }
	}
	else {
	  diff=(val-old);
	  for(i=0; i<filter->size; i++) {
	    crow = (row + (*pr) + syn->nrow *1000) % syn->nrow;
	    ccol = (col + (*pc) + syn->ncol *1000) % syn->ncol;
	    patch[i]=
	      map[crow][ccol]+diff*kernel[mid-i];
            pr++; pc++;
          }
        }
      }
    }
    else {   /* without checking the boundary to save time */
      for(val=0; val<ffamily->greyLevel; val++) {
	patch= filter->patch[val];
	pr=filter->rlist; pc=filter->clist; 
	if(val==old) {  
	  for(i=0; i<filter->size; i++) {
	    patch[i]=map[row+ *pr][col+ *pc];  
	    pr++;  pc++; 
	  }
	}
	else {
	  diff=(val-old);
          for(i=0; i<filter->size; i++) { 
	    patch[i]=map[row+ *pr][col+ *pc] + diff*kernel[mid-i]; 
	    pr++; pc++;
	  }
	}
      } 
    }
  }
  return;
}

/********************************************************
   Once the pixel [row][col] has been set to val
   we need to update the map of convolution by copying
     the corresponding patch into the map
*********************************************************/
void Update_Map(FILTERBANK *ffamily, int row, int col, int val)
{
  FILTER *filter;
  MAT    map;
  ARRAY  patch;
  int    filter_no;
  int    i, *pr, *pc;
  int    crow, ccol;
  for(filter_no=0; filter_no< ffamily->nfilter; filter_no++)  {
    filter = &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    patch=filter->patch[val];
    map=filter->map.data;
    
    pr=filter->rlist; pc=filter->clist;
    if(row < filter->ht || row >= (filter->map.nrow-filter->ht) || 
       col < filter->wid || col >= (filter->map.ncol-filter->wid) ) {
      for(i=0; i<filter->size; i++) {
	crow = (row + (*pr) + filter->map.nrow*1000 ) % filter->map.nrow;
	ccol = (col + (*pc) + filter->map.ncol*1000 ) % filter->map.ncol;
	map[crow][ccol]=patch[i]; 
	pr++; pc++;
      }
    }
    else {
      for(i=0; i<filter->size; i++) {
	map[row+(*pr)][col+(*pc)]=patch[i]; 
	pr++; pc++;
      }
    }
  }
  return;
}


/***********************************************************

  To flip the pixel[row][col] to val, we need to know the
 cond. prob.  P( val | neighbors), the new convolution
 are given in filter->patch[val-Min][][], it is independent
 of any other pixel values. so the prob can be calculated 
         directly from patch[][]

************************************************************/
void  Calc_Energy(FILTERBANK *ffamily, int row, int col, 
		  float *energy)
{
  ARRAY   resp;
  ARRAY   lambda, mark;
  FILTER *filter;
  float   sum;
  int     height, width, bin_num,  filter_no;
  int     i, index, val;
  
  for(val=0; val < ffamily->greyLevel; val++) energy[val]=0;
  
  for(filter_no=0; filter_no < ffamily->nfilter; filter_no++)  {
    filter = &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    for(val = 0; val < ffamily->greyLevel; val++) {
      resp=filter->patch[val];
      lambda=filter->lambda;    
      mark=filter->mark;
      bin_num=filter->bin_num;
      sum=0.0;
      for(i=0; i<filter->size; i++) {
	index=Round((resp[i]-mark[0])/(filter->unit));
	if(index<0) index=0;
	else if(index>=bin_num-1) index=bin_num-1;
	
	sum +=lambda[index];   
      }
      energy[val] += sum;
    }
  }
  return;
}

void  Calc_Energy_With_Patch_Hist(FILTERBANK *ffamily, int row, int col, 
				  double *energy,
				  IMAGEFLOAT *patch_hist)
{
  ARRAY   resp;
  ARRAY   lambda, mark;
  FILTER *filter;
  float   sum;
  int     height, width, bin_num,  filter_no;
  int     i, index, val;
  
  for(val=0; val < ffamily->greyLevel; val++) {
    energy[val]=0;
    for (i=0; i < ffamily->totalBin; i++) {
      patch_hist->data[val][i] = 0.;
    }
  }
  for(filter_no=0; filter_no < ffamily->nfilter; filter_no++)  {
    filter = &(ffamily->fbank[filter_no]);
    if (filter->flag ==0) continue;
    for(val = 0; val < ffamily->greyLevel; val++) {
      resp=filter->patch[val];
      lambda=filter->lambda;    
      mark=filter->mark;
      bin_num=filter->bin_num;
      sum=0.0;
      for(i=0; i<filter->size; i++) {
	index=Round((resp[i]-mark[0])/(filter->unit));
	if(index<0) index=0;
	else if(index>=bin_num-1) index=bin_num-1;
	patch_hist->data[val][ffamily->filterDim[filter_no]+index] += 1.0;
	sum +=lambda[index];   
      }
      energy[val] += sum;
    }
  }
  return;
}


void Flip(IMAGEINT *syn, FILTERBANK *ffamily,
	  CONTROL_INFO *controlInfo)
{
  float least, sum, r;
  int   val, i,k;
  int count, row, col;
  int prevIndex = -1;
  float *energy, *prob;
  int sweep;
  sweep = syn->nrow * syn->ncol;
  printf("Doing one sweep with %d updates  .... ",
	 sweep);
  fflush(stdout);
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  for(count=0; count<sweep; count++) {   
    do {
      row=(int) (Unit_Random()*syn->nrow);   
      col=(int) (Unit_Random()*syn->ncol);
    } while (row == syn->nrow || col == syn->ncol);
    if (controlInfo->interactive) {
      if ((count+1)%(sweep/10) == 0) {
	printf("%d ", count);
	fflush(stdout);
      }
    }
    
    Update_Patch(ffamily, syn, row, col);
    
    Calc_Energy(ffamily, row, col, energy);
    
    least=energy[0];
    
    for(val = 1; val< ffamily->greyLevel; val++) {
      if(least>energy[val]) {
	least=energy[val];
      }
    }
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++)
      sum+=prob[val]=exp(0.0-(energy[val]-least));
    
    for( val= 0; val< ffamily->greyLevel; val++)
      prob[val] /= sum;
    
    sum=0;
    for(val=0; val< ffamily->greyLevel; val++) {
      prob[val]+=sum;
      sum=prob[val];
    }
    /** choose the pixel value by the cdf **/
    r=Unit_Random(); val = 0;
    while(r>prob[val]) val++;
    
    if( val>= ffamily->greyLevel)  
      val= ffamily->greyLevel-1;
    
    Update_Map(ffamily, row, col, val);
    
    syn->data[row][col]=val;
    /*if ((count+1)%1000 ==0) {
      printf("Self testing for texture type %d\n", prevIndex);
      Self_Testing(ffamily,syn);
    }
    */
  }
  printf("DONE.\n");
  free(energy);
  free(prob);
  return;
}


void Flip_With_T(IMAGEINT *syn, FILTERBANK *ffamily,
		 CONTROL_INFO *controlInfo)
{
  float least, sum, r;
  int   val, i,k;
  int count, row, col;
  int prevIndex = -1;
  float *energy, *prob;
  int sweep;
  sweep = syn->nrow * syn->ncol;
  printf("Doing one sweep with %d updates at temp = %6.2f .... ",
	 sweep, controlInfo->synTemp);
  fflush(stdout);
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  for(count=0; count<sweep; count++) {   
    do {
      row=(int) (Unit_Random()*syn->nrow);   
      col=(int) (Unit_Random()*syn->ncol);
    } while (row == syn->nrow || col == syn->ncol);
    if (controlInfo->interactive) {
      if ((count+1)%(sweep/10) == 0) {
	printf("%d ", count);
	fflush(stdout);
      }
    }
    
    Update_Patch(ffamily, syn, row, col);
    
    Calc_Energy(ffamily, row, col, energy);
    for(val=0; val<ffamily->greyLevel; val++) {
      energy[val] /= controlInfo->synTemp;
    }

    least=energy[0];
    
    for(val = 1; val< ffamily->greyLevel; val++) {
      if(least>energy[val]) {
	least=energy[val];
      }
    }
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++)
      sum+=prob[val]=exp(0.0-(energy[val]-least));
    
    for( val= 0; val< ffamily->greyLevel; val++)
      prob[val] /= sum;
    
    sum=0;
    for(val=0; val< ffamily->greyLevel; val++) {
      prob[val]+=sum;
      sum=prob[val];
    }
    /** choose the pixel value by the cdf **/
    r=Unit_Random(); val = 0;
    while(r>prob[val]) val++;
    
    if( val>= ffamily->greyLevel)  
      val= ffamily->greyLevel-1;
    
    Update_Map(ffamily, row, col, val);
    
    syn->data[row][col]=val;
    /*if ((count+1)%1000 ==0) {
      printf("Self testing for texture type %d\n", prevIndex);
      Self_Testing(ffamily,syn);
    }
    */
  }
  printf("DONE.\n");
  free(energy);
  free(prob);
  /* Cooling the temperature */
  controlInfo->synTemp /= controlInfo->synCoolingRatio;
  if (controlInfo->synTemp < controlInfo->synLowTemp)
    controlInfo->synTemp = controlInfo->synLowTemp;
  return;
}



void Flip_With_T_Hole(IMAGEINT *syn, FILTERBANK *ffamily,
		       CONTROL_INFO *controlInfo,
		       ONE_HOLE *synpatch)
{
  float least, sum, r;
  int   val, i,k;
  int count, row, col;
  int prevIndex = -1;
  float *energy, *prob;
  int sweep;
  sweep = synpatch->hole_size*synpatch->hole_size;
  printf("Doing one sweep with %d updates at temp = %6.2f .... ",
	 sweep, controlInfo->synTemp);
  fflush(stdout);
  energy = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  prob = (float *)malloc(sizeof(float)*ffamily->greyLevel);
  for(count=0; count<sweep; count++) {   
    do {
      row=(int) (Unit_Random()*synpatch->hole_size);   
      col=(int) (Unit_Random()*synpatch->hole_size);
    } while (row == synpatch->hole_size || col == synpatch->hole_size);
    row +=  synpatch->row;
    col +=  synpatch->col;
    if (controlInfo->interactive) {
      if ((count+1)%(sweep/10) == 0) {
	printf("%d ", count);
	fflush(stdout);
      }
    }
    
    Update_Patch(ffamily, syn, row, col);
    
    Calc_Energy(ffamily, row, col, energy);
    for(val=0; val<ffamily->greyLevel; val++) {
      energy[val] /= controlInfo->synTemp;
    }

    least=energy[0];
    
    for(val = 1; val< ffamily->greyLevel; val++) {
      if(least>energy[val]) {
	least=energy[val];
      }
    }
    sum = 0.0;      /* shift and normalize the probability */
    for(val = 0; val < ffamily->greyLevel; val++)
      sum+=prob[val]=exp(0.0-(energy[val]-least));
    
    for( val= 0; val< ffamily->greyLevel; val++)
      prob[val] /= sum;
    
    sum=0;
    for(val=0; val< ffamily->greyLevel; val++) {
      prob[val]+=sum;
      sum=prob[val];
    }
    /** choose the pixel value by the cdf **/
    r=Unit_Random(); val = 0;
    while(r>prob[val]) val++;
    
    if( val>= ffamily->greyLevel)  
      val= ffamily->greyLevel-1;
    
    Update_Map(ffamily, row, col, val);
    
    syn->data[row][col]=val;
    /*if ((count+1)%1000 ==0) {
      printf("Self testing for texture type %d\n", prevIndex);
      Self_Testing(ffamily,syn);
    }
    */
  }
  printf("DONE.\n");
  free(energy);
  free(prob);
  /* Cooling the temperature */
  controlInfo->synTemp /= controlInfo->synCoolingRatio;
  if (controlInfo->synTemp < controlInfo->synLowTemp)
    controlInfo->synTemp = controlInfo->synLowTemp;
  return;
}






