#define FUNCTIONS_SOURCE_C_C
#include "functions.h"
float Gaussain_Kernel_3[] = 
         {0.07050946066121, 0.85898107867759, 0.07050946066121};

void Smoothing_Hist(float *hist_In, int hist_len, int iteration)
{
  float *tmpHist[2];
  int   whichOne;
  int   i,j,k;
  whichOne = 0;
  for (i=0; i<2; i++) {
    tmpHist[i] = (float *)malloc(sizeof(float)*hist_len);
  }
  for (i=0; i<hist_len; i++) {
    tmpHist[whichOne][i] = hist_In[i];
  }
  
  for (k=0; k< iteration; k++) {
    for (i=1; i<(hist_len-1); i++) {
      tmpHist[1-whichOne][i] = 0.0;
      for (j= 0-1; j <=1; j++) {
	tmpHist[1-whichOne][i] += 
	  tmpHist[whichOne][i+j]*Gaussain_Kernel_3[j+1];
      }
    }
    i = 0;
    tmpHist[1-whichOne][i] = 0.0;
    for (j= 0; j <=1; j++) {
      tmpHist[1-whichOne][i] += 
	tmpHist[whichOne][i+j]*Gaussain_Kernel_3[j+1];
    }
    tmpHist[1-whichOne][i] += Gaussain_Kernel_3[0] * tmpHist[whichOne][i];
    
    
    i = hist_len-1;
    tmpHist[1-whichOne][i] = 0.0;
    for (j= -1; j <=0; j++) {
      tmpHist[1-whichOne][i] += 
	tmpHist[whichOne][i+j]*Gaussain_Kernel_3[j+1];
    }
    tmpHist[1-whichOne][i] += Gaussain_Kernel_3[2] * tmpHist[whichOne][i];
    
    whichOne = 1-whichOne;
  }
  
  for (i=0; i<hist_len; i++) {
   hist_In[i] = tmpHist[whichOne][i];
  }
  for (i=0; i<2; i++) {
    free(tmpHist[i]);
  }
}

float Calc_Hist_Divergence(float *H1, float *H2, int hist_len)
{
  int i;
  float tmp = 0.0;
 
  for (i=0; i<hist_len; i++) {
    /*tmp += (H1[i]-H2[i])*logf(H1[i]/H2[i]);*/
    if ( (H1[i]+H2[i]) >DELTA) 
      tmp += 2.0*(H1[i]-H2[i])*(H1[i]-H2[i])/(H1[i]+H2[i]);
  }
  return tmp;
}

float Calc_Hist_Dist_L1(float *H1, float *H2, int hist_len)
{
  int i;
  float tmp = 0.0;
 
  for (i=0; i<hist_len; i++) {
    tmp += fabs(H1[i]-H2[i]);
  }
  return tmp;
}


float Calc_Hist_Divergence_AFilter(float *H1, float *H2, 
				   int filter_no,
				   FILTERBANK *ffamily)
{
  int i;
  i = ffamily->filterDim[filter_no];
  return Calc_Hist_Divergence(&(H1[i]), &(H2[i]),
			      ffamily->fbank[filter_no].bin_num);
}

float Calc_Hist_Chi(float *H1, float *H2, int hist_len)
{
 int i;
  float tmp = 0.0;
  for (i=0; i<hist_len; i++) {
    if ( (H1[i]+H2[i]) >DELTA) 
      tmp += 2.0*(H1[i]-H2[i])*(H1[i]-H2[i])/(H1[i]+H2[i]);
  }
  return tmp;
}

float Calc_Hist_Chi_AFilter(float *H1, float *H2, 
			    int filter_no,
			    FILTERBANK *ffamily)
{
  int i;
  i = ffamily->filterDim[filter_no];
  return Calc_Hist_Chi(&(H1[i]), &(H2[i]),
			      ffamily->fbank[filter_no].bin_num);
}


void Compute_Local_Window_Hist(int row, int col, int windex,
			       FILTERBANK *ffamily,
			       IMAGEINT *animage,
			       float *histVec)
{
  float  sum;
  int bin;
  int i,j,k;
  int i1, j1, index;
  int wsize_x, wsize_y;
  int filter_no;
  int x_size, y_size, x_bias, y_bias;
  FILTER *filter;
  float *hist;
  int   startDim;
  
  wsize_x = ffamily->winLevels[windex].x;
  wsize_y = ffamily->winLevels[windex].y;
  x_size = 2*wsize_x+1;
  x_bias = 0;
  if (col-wsize_x < 0) {
    x_size += col-wsize_x;
    x_bias = wsize_x-col;
  }
  if (col+wsize_x >= animage->ncol) {
    x_size -= (col+wsize_x-animage->ncol+1);
  }
  y_size = 2*wsize_y+1;
  y_bias = 0;
  if (row-wsize_y < 0) {
    y_size += row-wsize_y;
    y_bias = wsize_y-row;
  }
  
  if (row+wsize_y >= animage->nrow) {
    y_size -= (row+wsize_y-animage->nrow+1);
  }
  
  /* printf("Size of valid window at level %d is %d x %d with bias %d x %d\n",
	 windex, y_size, x_size, y_bias, x_bias);
  */
  startDim = 0;
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    hist = &(histVec[startDim]);
    startDim += filter->bin_num;
    for (bin=0; bin  < filter->bin_num; bin++) {
      hist[bin] = 0;
    }    
    for (i=0; i<= 2*wsize_y; i++) {
      for (j=0; j<= 2*wsize_x; j++) {
	sum = 0.0;
	for (k=0; k <  filter->size; k++) {
	  i1 = (i+filter->rlist[k]+100*y_size)%y_size;
	  j1 = (j+filter->clist[k]+100*x_size)%x_size;
	  
	  i1 = i1+row-wsize_y+y_bias;
	  j1 = j1+col-wsize_x+x_bias;
	  if (i1 <0 || i1 >= animage->nrow || j1 <0 ||
	      j1 >= animage->ncol) {
	    printf("%d,%d is out of bound %d, %d, which should not happen\n",
		   j1, i1, animage->nrow, animage->ncol);
	    printf("At pixel %d,%d (%d,%d), ", col,row, j,i);
	    printf("size of valid window at level %d is %d x %d ",
		   windex, x_size, y_size);
	    printf("with bias %d x %d\n",
		   y_bias, x_bias);
	    exit(-1);
	  }
	  sum += filter->kernel[k] *
	    animage->data[i1][j1];
	}
	/* Add to the hist patch */
	index = 
	  Round((sum-filter->mark[0])/filter->unit);
	if (index <0) index = 0;
	else {
	  if (index >= filter->bin_num)
	    index = filter->bin_num -1;
	}
	hist[index] ++;
      }
    }
    for (bin=0; bin  < filter->bin_num; bin++) {
      hist[bin] /= 
	(float)((2*wsize_x+1)*(2*wsize_y+1));
    }
    Smoothing_Hist(hist, filter->bin_num, (int)GAUSSIAN_SMOOTH_SCALE);
  }
  return;
}

void Compute_Local_Window_Hist_Inside(int row, int col, int windex,
				      FILTERBANK *ffamily,
				      IMAGEINT *animage,
				      float *histVec)
{
  float  sum;
  int bin;
  int i,j,k;
  int i1, j1, index;
  int wsize_x, wsize_y;
  int filter_no;
  FILTER *filter;
  float *hist;
  int   startDim;
  int   x_size, y_size;
  wsize_x = ffamily->winLevels[windex].x;
  wsize_y = ffamily->winLevels[windex].y;
  x_size = 2*wsize_x + 1;
  y_size = 2*wsize_y + 1;
  startDim = 0;
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    hist = &(histVec[startDim]);
    startDim += filter->bin_num;
    for (bin=0; bin  < filter->bin_num; bin++) {
      hist[bin] = 0;
    }    
    for (i=0; i<= 2*wsize_y; i++) {
      for (j=0; j<= 2*wsize_x; j++) {
	sum = 0.0;
	for (k=0; k <  filter->size; k++) {
	  i1 = (i+filter->rlist[k]+100*y_size)%y_size + 
	    row-wsize_y;
	  j1 = (j+filter->clist[k]+100*x_size)%x_size + 
	    col-wsize_x;
	  
	  if (i1 <0 || i1 >= animage->nrow || j1 <0 ||
	      j1 >= animage->ncol) {
	    printf("Hist_Inside: %d,%d is out of bound %d, %d, ",
		   i1, j1, animage->nrow, animage->ncol);
	    printf("which should not happen\n");
	    exit(-1);
	  }
	  sum += filter->kernel[k] *
	    animage->data[i1][j1];
	}
	/* Add to the hist patch */
	index = 
	  Round((sum-filter->mark[0])/filter->unit);
	if (index <0) index = 0;
	else {
	  if (index >= filter->bin_num)
	    index = filter->bin_num -1;
	}
	hist[index] ++;
      }
    }
    for (bin=0; bin  < filter->bin_num; bin++) {
      hist[bin] /= 
	(float)((2*wsize_x+1)*(2*wsize_y+1));
    }
    Smoothing_Hist(hist, filter->bin_num, (int)GAUSSIAN_SMOOTH_SCALE);
  }
  return;
}


void Compute_Local_Hist(int row, int col, 
			FILTERBANK *ffamily,
			IMAGEINT *animage,
			float **histImage)
{
  int windex;
  int filter_no;
  for (windex=0; windex < ffamily->nlevel; windex++) {
    Compute_Local_Window_Hist(row,col, windex,
			      ffamily, animage,
			      histImage[windex]);
  }
  
  return;
}
  
void Compute_Image_Level_Hist(int windex,
			      FILTERBANK *ffamily,
			      IMAGEINT *animage,
			      IMAGEVECTOR *featureImg)
{
  int i,j;
  
  
  printf("Computing fetaure image at level %d\n", windex+1);
  for (i = featureImg->wsize_y; 
       i < (animage->nrow-featureImg->wsize_y); i++) {
    printf("%3d ",i);
    if ((i+1-featureImg->wsize_y)%18==0) printf("\n");
    else
      fflush(stdout);
    
    for (j=featureImg->wsize_x; 
	 j < (animage->ncol-featureImg->wsize_x); j++) {
      Compute_Local_Window_Hist_Inside(i,j, windex,
				ffamily, animage,  
        featureImg->data[i-featureImg->wsize_y][j-featureImg->wsize_x]);
    }
  }
  printf("\n");
}

int Find_Neighbor_Same_Pixels(int row, int col,
			      int trylabel,
			      IMAGEINT *animage,
			      int wsize)
{
  int npoint = 0;
  int k;
  int crow, ccol;

  for (crow=row-wsize; crow <= (row+wsize); crow++) {
    for (ccol = col-wsize; ccol <= (col+wsize); ccol++) {
      if (crow >=0 && crow < animage->nrow &&
	  ccol >=0 && ccol < animage->ncol) {
	if ( (crow != row) || (ccol != col))
	  npoint += (animage->data[crow][ccol] == trylabel);
      }
    }
  }
  return npoint;
}



int Calc_Average_Feature_Vector(FILTERBANK *ffamily,
				CONTROL_INFO *controlInfo,
				IMAGEINT *animage,
				ARRAY fvector)
{
  int maxseedPixel;
  int i, j, k;
  float *histmp;
  int seg_bound_x, seg_bound_y;
  int total_points;
  int npatches;
  histmp = Create_Array(ffamily->totalBin);
  seg_bound_x = ffamily->winLevels[controlInfo->segWin].x;
  seg_bound_y = ffamily->winLevels[controlInfo->segWin].y;
  for (k=0; k < ffamily->totalBin; k++) {
    fvector[k]=0.0;
  }
  total_points = 0;
  npatches =0;
  printf("Calculating average feature vector ... ");
  for (i=seg_bound_y; i <(animage->nrow-seg_bound_y); 
       i+= controlInfo->seedGrid) {
    for (j=seg_bound_x; j <(animage->ncol-seg_bound_x); 
	 j+=controlInfo->seedGrid) {
      if (npatches %3==0) {
	Compute_Local_Window_Hist_Inside(i, j, controlInfo->segWin,
					 ffamily, animage,
					 histmp);
	for (k=0; k < ffamily->totalBin; k++) {
	  fvector[k] += histmp[k];
	}
	total_points++;
      }
      npatches++;
    }
  }
  for (k=0; k < ffamily->totalBin; k++) {
    fvector[k] /= (float)total_points;
  }
  printf("Done.\n");
  Free_Array(histmp);
  return 0;
}



