
/****************************************************************

    This file includes the routines on the data structure: hist

      When we calc the histogram in discrete case, like the 
   intensity filter. We need to pay attension to the mark[], and hist[]
*****************************************************************/
#define HIST_UTIL_SOURCE_C_C
#include "hist-util.h"
/*****************************************************/
float Update_Lambda(int iter, 
		    char *fname,
		    FILTERBANK *ffamily, 
		    CONTROL_INFO *controlInfo,
		    float *max_a_filter_err, 
		    float *returnWeightedSum)
{
  FILTER *filter;
  float alpha;
  int     i, count=0,  filter_no;
  float   delta, sum;
  float   totalErr;
  float   tmp;
  FILE    *fp;
  float   maxErr;
  int     maxFilter;
  float   weightedSum;
  float   totalweightedSum;
  if (controlInfo->saveHistogram) {
    if (iter >0) {
      fp = fopen(fname,"ab");
    }
    else {
      fp = fopen(fname,"wb");
    }
  }
  alpha =  controlInfo->learningAlpha/
    ((float)(ffamily->norm));
  totalErr = 0;
  maxErr = 0.0;
  totalweightedSum =0.0;
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    if (filter->flag==0) continue;
    sum=0;
    weightedSum = 0;
    if (controlInfo->saveHistogram) {
      fprintf(fp,"Target-> ");
      for(i=0; i<filter->bin_num; i++) {
	fprintf(fp,"%8.2f ", filter->target_hist[i]);
      }
      for(; i< ffamily->longestBin; i++)
	fprintf(fp," 0 ");
      fprintf(fp,"\n         ");
      for(i=0; i<filter->bin_num; i++) {
	fprintf(fp,"%8.2f ", filter->hist[i]);
      }
      for(; i< ffamily->longestBin; i++)
	fprintf(fp," 0 ");
      fprintf(fp,"\n");
    }
    for(i=0; i<filter->bin_num; i++) {
      delta=filter->target_hist[i]-filter->hist[i];
      filter->lambda[i] -= alpha*delta;
      
      weightedSum += (filter->hist[i] * filter->lambda[i]);
      sum +=fabs(delta);
    }
    sum /= ((float)(2.*ffamily->norm));
    if (controlInfo->saveHistogram) {
      fprintf(fp,"         ");
      for(i=0; i<filter->bin_num; i++) {
	fprintf(fp,"%8.6f ", filter->lambda[i]);
      }
      
      for(; i< ffamily->longestBin; i++)
	fprintf(fp," 0 ");
      fprintf(fp,"\n");
    }
    if ( maxErr < sum ) {
      maxErr = sum;
      maxFilter = filter_no;
    }
    totalweightedSum += weightedSum;
    totalErr += sum;
    if (controlInfo->saveHistogram) {
      fprintf(fp,"Filter %d %s  error=%f\n", count, filter->name, sum);
      fprintf(fp,"Unit = %8.6f Mark[0] = %8.6f\n", filter->unit,
		filter->mark[0]);
    }
    printf("    Filter %d (the %2dth used) %s  error = %8.6f\n", 
	   filter_no, count, filter->name, sum);
    count++;
  }
  if (controlInfo->saveHistogram) {
    fprintf(fp,"Iteration = %d total Error = %8.6f weighted error = %8.6f\n", 
	    iter, totalErr, totalweightedSum);
    fprintf(fp,"\t\tmax error = %f from filter %d\n",  
	    maxErr, maxFilter);
    fclose(fp);
  }
  printf("Iteration = %d total Error = %8.6f weighted error = %8.6f\n", 
	 iter, totalErr, totalweightedSum);
  printf("\t\tmax error = %f from filter %d\n",  
	    maxErr, maxFilter); 
  *max_a_filter_err = maxErr;
  *returnWeightedSum = totalweightedSum;
  return totalErr;
}


void Save_Lambda_To_File(FILTERBANK *ffamily,
			 char *fname)
{
  FILE *fp;
  FILTER *filter;
  int i, filter_no;   
  fp = fopen(fname,"wb");
  
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    for(i=0; i<filter->bin_num; i++) {
      fprintf(fp,"%8.6f ", filter->lambda[i]);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}


void Save_Lambda_To_File_Append(FILTERBANK *ffamily,
				char *fname)
{
  FILE *fp;
  FILTER *filter;
  int i, filter_no;   
  fp = fopen(fname,"ab");
  fprintf(fp,"\n\n");
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    for(i=0; i<filter->bin_num; i++) {
      fprintf(fp,"%8.6f ", filter->lambda[i]);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}

void Save_Lambda_To_File_Append_From_Vector(FILTERBANK *ffamily,
					    char *fname,
					    ARRAY lambda_vect)
{
  FILE *fp;
  FILTER *filter;
  int i, filter_no;   
  fp = fopen(fname,"ab");
  fprintf(fp,"\n\n");
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    for(i=0; i<filter->bin_num; i++) {
      fprintf(fp,"%8.6f ", 
	      lambda_vect[ffamily->filterDim[filter_no]+i]);
    }
    fprintf(fp,"\n");
  }
  fclose(fp);
}


float Calculate_Errors(FILTERBANK *ffamily, 
		       float *max_a_filter_err, 
		       float *returnWeightedSum)
{
  FILTER *filter;
  float alpha;
  int     i, count=0,  filter_no;
  float   delta, sum;
  float   totalErr;
  float   tmp;
  FILE    *fp;
  float   maxErr;
  int     maxFilter;
  float   weightedSum;
  float   totalweightedSum;
  
  totalErr = 0;
  maxErr = 0.0;
  totalweightedSum =0.0;
  for(filter_no=0; filter_no<ffamily->nfilter; filter_no++) {
    filter = &(ffamily->fbank[filter_no]);
    sum=0;
    weightedSum = 0;
    
    for(i=0; i<filter->bin_num; i++) {
      delta=filter->target_hist[i]-filter->hist[i];
      
      weightedSum += (filter->hist[i] * filter->lambda[i]);
      sum +=fabs(delta);
    }
    sum /= ((float)(2.*ffamily->norm));
    
    if ( maxErr < sum ) {
      maxErr = sum;
      maxFilter = filter_no;
    }
    totalweightedSum += weightedSum;
    totalErr += sum;
    
    printf("    %2d %s  error = %8.6f\n", count, filter->name, sum);
    count++;
  }
  
  printf("Total Error = %8.6f weighted error = %8.6f\n", 
	 totalErr, totalweightedSum);
  printf("\t\tmax error = %f from filter %d\n",  
	    maxErr, maxFilter); 
  *max_a_filter_err = maxErr;
  *returnWeightedSum = totalweightedSum;
  return totalErr;
}



