#if !defined(HIST_UTIL_H_H)
#define HIST_UTIL_H_H
#include <stdio.h>
#include <math.h>
#include <string.h>
#include "type-def.h"
#include "util.h"
#include "functions.h"
#include "imageio.h"

#if defined(HIST_UTIL_SOURCE_C_C)
#define EXTERN_FLAG
#else
#define EXTERN_FLAG extern
#endif

EXTERN_FLAG float Update_Lambda(int iter, 
				char *fname,
				FILTERBANK *ffamily, 
				CONTROL_INFO *controlInfo,
				float *max_a_filter_err, 
				float *returnWeightedSum);
EXTERN_FLAG void Save_Lambda_To_File(FILTERBANK *ffamily,
				     char *fname);

EXTERN_FLAG void Save_Lambda_To_File_Append(FILTERBANK *ffamily,
					    char *fname);

EXTERN_FLAG void Save_Lambda_To_File_Append_From_Vector(FILTERBANK *ffamily,
							char *fname,
							ARRAY lambda_vect);


EXTERN_FLAG float Calculate_Errors(FILTERBANK *ffamily, 
				   float *max_a_filter_err, 
				   float *returnWeightedSum);
#undef  EXTERN_FLAG 
#endif
